/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.infinispan.Cache;
import org.jboss.resteasy.skeleton.key.keystone.model.IdentityStore;
import org.jboss.resteasy.skeleton.key.keystone.model.Role;
import org.jboss.resteasy.skeleton.key.keystone.model.StoredProject;
import org.jboss.resteasy.skeleton.key.keystone.model.StoredUser;

public class Loader {
    final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    final ObjectMapper WRAPPED_MAPPER = new ObjectMapper();

    public Loader() {
        this.DEFAULT_MAPPER.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.DEFAULT_MAPPER.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
        this.DEFAULT_MAPPER.enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY});
    }

    public String export(Cache cache) {
        IdentityStore store = this.toStore(cache);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos, store);
        return new String(baos.toByteArray());
    }

    public IdentityStore importStore(InputStream is) {
        try {
            JsonParser jp = this.DEFAULT_MAPPER.getJsonFactory().createJsonParser(is);
            return (IdentityStore)this.DEFAULT_MAPPER.readValue(jp, IdentityStore.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void importStore(InputStream is, Cache cache) {
        IdentityStore store = this.importStore(is);
        this.importStore(store, cache);
    }

    public void importStore(IdentityStore store, Cache cache) {
        if (store.getRoles() != null) {
            for (Role role : store.getRoles()) {
                cache.put((Object)("/roles/" + role.getId()), (Object)role);
            }
        }
        if (store.getUsers() != null) {
            for (StoredUser user : store.getUsers()) {
                cache.put((Object)("/users/" + user.getId()), (Object)user);
            }
        }
        if (store.getProjects() != null) {
            for (StoredProject project : store.getProjects()) {
                cache.put((Object)("/projects/" + project.getProject().getId()), (Object)project);
            }
        }
    }

    public void export(Cache cache, OutputStream os) {
        IdentityStore store = this.toStore(cache);
        this.write(os, store);
    }

    private void write(OutputStream os, IdentityStore store) {
        try {
            JsonGenerator jg = this.DEFAULT_MAPPER.getJsonFactory().createJsonGenerator(os, JsonEncoding.UTF8);
            this.DEFAULT_MAPPER.writeValue(jg, (Object)store);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IdentityStore toStore(Cache cache) {
        ArrayList<StoredUser> users = new ArrayList<StoredUser>();
        ArrayList<Role> roles = new ArrayList<Role>();
        ArrayList<StoredProject> projects = new ArrayList<StoredProject>();
        IdentityStore store = new IdentityStore();
        for (Object value : cache.values()) {
            if (value instanceof StoredUser) {
                users.add((StoredUser)value);
                store.setUsers(users);
                continue;
            }
            if (value instanceof Role) {
                roles.add((Role)value);
                store.setRoles(roles);
                continue;
            }
            if (!(value instanceof StoredProject)) continue;
            projects.add((StoredProject)value);
            store.setProjects(projects);
        }
        return store;
    }
}

