/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.keystone.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.skeleton.key.keystone.model.Project;
import org.jboss.resteasy.skeleton.key.keystone.model.Role;
import org.jboss.resteasy.skeleton.key.keystone.model.User;

public class StoredProject
implements Serializable {
    private Project project;
    private Map<String, Set<String>> userRoles = new HashMap<String, Set<String>>();
    private Map<String, String> userNameIds = new HashMap<String, String>();

    public StoredProject() {
    }

    public StoredProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Map<String, Set<String>> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(Map<String, Set<String>> userRoles) {
        this.userRoles = userRoles;
    }

    public Set<String> roleMapping(String userId) {
        return this.userRoles.get(userId);
    }

    public void addUserRoleMapping(User user, Role role) {
        this.userNameIds.put(user.getUsername(), user.getId());
        Set<String> roleMapping = this.userRoles.get(user.getId());
        if (roleMapping == null) {
            roleMapping = new HashSet<String>();
            this.userRoles.put(user.getId(), roleMapping);
        }
        roleMapping.add(role.getId());
    }

    public void removeUserRoleMapping(User user, Role role) {
        this.userNameIds.put(user.getUsername(), user.getId());
        Set<String> roleMapping = this.userRoles.get(user.getId());
        if (roleMapping == null) {
            return;
        }
        roleMapping.remove(role.getId());
        if (roleMapping.size() < 1) {
            this.userRoles.remove(user.getId());
            this.userNameIds.remove(user.getUsername());
        }
        roleMapping.add(role.getId());
    }

    public Map<String, String> getUserNameIds() {
        return this.userNameIds;
    }

    public void setUserNameIds(Map<String, String> userNameIds) {
        this.userNameIds = userNameIds;
    }
}

