/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.keystone.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonRootName;
import org.jboss.resteasy.skeleton.key.keystone.model.Link;
import org.jboss.resteasy.skeleton.key.keystone.model.Project;
import org.jboss.resteasy.skeleton.key.keystone.model.Role;

@JsonRootName(value="access")
public class Access
implements Serializable {
    private Token token;
    private List<Service> serviceCatalog;
    private User user;
    private Map<String, Object> metadata;

    public Access() {
    }

    public Access(Token token, List<Service> serviceCatalog, User user, Map<String, Object> metadata) {
        this.token = token;
        this.serviceCatalog = serviceCatalog;
        this.user = user;
        this.metadata = metadata;
    }

    public Token getToken() {
        return this.token;
    }

    public List<Service> getServiceCatalog() {
        return this.serviceCatalog;
    }

    public User getUser() {
        return this.user;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public void setServiceCatalog(List<Service> serviceCatalog) {
        this.serviceCatalog = serviceCatalog;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        return "Access [token=" + this.token + ", serviceCatalog=" + this.serviceCatalog + ", user=" + this.user + ", metadata=" + this.metadata + "]";
    }

    public static final class User
    implements Serializable {
        private String id;
        private String name;
        private String username;
        private Set<Role> roles;

        public User() {
        }

        public User(String id, String name, String username, Set<Role> roles) {
            this.id = id;
            this.name = name;
            this.username = username;
            this.roles = roles;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getUsername() {
            return this.username;
        }

        public Set<Role> getRoles() {
            return this.roles;
        }

        public String toString() {
            return "User [id=" + this.id + ", name=" + this.name + ", username=" + this.username + ", roles=" + this.roles + "]";
        }
    }

    public static final class Service
    implements Serializable {
        private String type;
        private String name;
        private List<Endpoint> endpoints;
        @JsonProperty(value="endpoints_links")
        private List<Link> endpointsLinks;

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public List<Endpoint> getEndpoints() {
            return this.endpoints;
        }

        public List<Link> getEndpointsLinks() {
            return this.endpointsLinks;
        }

        public String toString() {
            return "Service [type=" + this.type + ", name=" + this.name + ", endpoints=" + this.endpoints + ", endpointsLinks=" + this.endpointsLinks + "]";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Endpoint {
            private String region;
            private String publicURL;
            private String internalURL;
            private String adminURL;

            public String getRegion() {
                return this.region;
            }

            public String getPublicURL() {
                return this.publicURL;
            }

            public String getInternalURL() {
                return this.internalURL;
            }

            public String getAdminURL() {
                return this.adminURL;
            }

            public String toString() {
                return "Endpoint [region=" + this.region + ", publicURL=" + this.publicURL + ", internalURL=" + this.internalURL + ", adminURL=" + this.adminURL + "]";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Token
    implements Serializable {
        private String id;
        private Calendar expires;
        private Project project;

        public Token() {
        }

        public Token(String id, Calendar expires, Project project) {
            this.id = id;
            this.expires = expires;
            this.project = project;
        }

        public String getId() {
            return this.id;
        }

        public Calendar getExpires() {
            return this.expires;
        }

        public boolean expired() {
            return this.expires.getTime().getTime() < System.currentTimeMillis();
        }

        public Project getProject() {
            return this.project;
        }

        public String toString() {
            return "Token [id=" + this.id + ", expires=" + this.expires + ", project=" + this.project + "]";
        }
    }
}

