/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.core;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.security.smime.PKCS7SignatureInput;
import org.jboss.resteasy.skeleton.key.core.UserPrincipal;
import org.jboss.resteasy.skeleton.key.keystone.model.Access;
import org.jboss.resteasy.skeleton.key.keystone.model.Role;

public abstract class AbstractTokenAuthFilter
implements ContainerRequestFilter {
    protected X509Certificate certificate;
    protected Logger logger = Logger.getLogger(AbstractTokenAuthFilter.class);
    @Context
    SecurityContext securityContext;
    @Context
    Providers providers;

    protected AbstractTokenAuthFilter(X509Certificate certificate) {
        this.certificate = certificate;
    }

    protected Access signed(String header) {
        PKCS7SignatureInput input = null;
        boolean verify = false;
        try {
            input = new PKCS7SignatureInput(header);
            input.setProviders(this.providers);
            verify = input.verify(this.certificate);
        }
        catch (Exception e) {
            throw new WebApplicationException(403);
        }
        if (!verify) {
            throw new WebApplicationException(403);
        }
        try {
            return (Access)input.getEntity(Access.class, MediaType.APPLICATION_JSON_TYPE);
        }
        catch (Exception e) {
            this.logger.error("Failed to unmarshall", (Throwable)e);
            throw new WebApplicationException(403);
        }
    }

    protected abstract Access getTokenFromServer(String var1);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String xAuthToken = requestContext.getHeaderString("X-Auth-Token");
        String xAuthSignedToken = requestContext.getHeaderString("X-Auth-Signed-Token");
        Access token = null;
        if (xAuthToken == null && xAuthSignedToken == null) {
            return;
        }
        if (xAuthSignedToken != null && this.certificate != null) {
            token = this.signed(xAuthSignedToken);
        } else if (xAuthToken != null) {
            token = this.getTokenFromServer(xAuthToken);
        }
        if (token == null) {
            return;
        }
        if (token.getToken().expired()) {
            return;
        }
        final UserPrincipal principal = new UserPrincipal(token.getUser());
        final HashSet<String> roleSet = new HashSet<String>();
        for (Role role : token.getUser().getRoles()) {
            roleSet.add(role.getName());
        }
        SecurityContext ctx = new SecurityContext(){

            public Principal getUserPrincipal() {
                return principal;
            }

            public boolean isUserInRole(String role) {
                return roleSet.contains(role);
            }

            public boolean isSecure() {
                return AbstractTokenAuthFilter.this.securityContext.isSecure();
            }

            public String getAuthenticationScheme() {
                return AbstractTokenAuthFilter.this.securityContext.getAuthenticationScheme();
            }
        };
        requestContext.setSecurityContext(ctx);
    }
}

