/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.client;

import java.io.IOException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configurable;
import org.jboss.resteasy.client.jaxrs.ProxyBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.skeleton.key.client.SkeletonKeyAdminClient;
import org.jboss.resteasy.skeleton.key.client.TokenFactory;
import org.jboss.resteasy.skeleton.key.keystone.model.Access;
import org.jboss.resteasy.skeleton.key.keystone.model.Authentication;
import org.jboss.resteasy.skeleton.key.keystone.model.Mappers;

public class SkeletonKeyClientBuilder {
    protected ResteasyWebTarget admin;
    protected TokenFactory tokenFactory;
    protected String username;
    protected String password;

    public SkeletonKeyClientBuilder username(String username) {
        this.username = username;
        return this;
    }

    public SkeletonKeyClientBuilder password(String password) {
        this.password = password;
        return this;
    }

    public SkeletonKeyClientBuilder idp(WebTarget uri) {
        this.admin = (ResteasyWebTarget)uri;
        WebTarget target = uri.path("tokens");
        Mappers.registerContextResolver((Configurable)target.configuration());
        this.tokenFactory = (TokenFactory)ProxyBuilder.builder(TokenFactory.class, (WebTarget)target).build();
        return this;
    }

    public Access authenticateTarget(final String projectName, WebTarget target) {
        if (this.username == null) {
            throw new NullPointerException("username is null");
        }
        if (this.password == null) {
            throw new NullPointerException("password is null");
        }
        if (this.tokenFactory == null) {
            throw new NullPointerException("idp is null");
        }
        final Access access = this.obtainToken(projectName);
        ClientRequestFilter tokenFilter = new ClientRequestFilter(){
            volatile Access token;
            {
                this.token = access;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void filter(ClientRequestContext requestContext) throws IOException {
                Access tmp = this.token;
                if (tmp.getToken().expired()) {
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        tmp = this.token;
                        if (tmp.getToken().expired()) {
                            this.token = tmp = SkeletonKeyClientBuilder.this.obtainToken(projectName);
                        }
                    }
                }
                requestContext.getHeaders().putSingle((Object)"X-Auth-Token", (Object)tmp.getToken().getId());
            }
        };
        target.configuration().register((Object)tokenFilter);
        return access;
    }

    public String signed(String projectName, WebTarget target) {
        if (this.username == null) {
            throw new NullPointerException("username is null");
        }
        if (this.password == null) {
            throw new NullPointerException("password is null");
        }
        if (this.tokenFactory == null) {
            throw new NullPointerException("idp is null");
        }
        final String access = this.obtainSignedToken(projectName);
        ClientRequestFilter tokenFilter = new ClientRequestFilter(){

            public void filter(ClientRequestContext requestContext) throws IOException {
                requestContext.getHeaders().putSingle((Object)"X-Auth-Signed-Token", (Object)access);
            }
        };
        target.configuration().register((Object)tokenFilter);
        return access;
    }

    public Access obtainToken(String projectName) {
        Authentication auth = this.authentication(projectName);
        return this.tokenFactory.create(auth);
    }

    public String obtainSignedToken(String projectName) {
        Authentication auth = this.authentication(projectName);
        return this.tokenFactory.createSigned(auth);
    }

    public Authentication authentication(String projectName) {
        Authentication auth = new Authentication();
        Authentication.PasswordCredentials creds = new Authentication.PasswordCredentials();
        creds.setUsername(this.username);
        creds.setPassword(this.password);
        auth.setProjectName(projectName);
        auth.setPasswordCredentials(creds);
        return auth;
    }

    public SkeletonKeyAdminClient admin() {
        ResteasyWebTarget clone = this.admin.clone();
        Mappers.registerContextResolver((Configurable)clone.configuration());
        this.authenticateTarget("Skeleton Key", (WebTarget)clone);
        return (SkeletonKeyAdminClient)clone.proxy(SkeletonKeyAdminClient.class);
    }
}

