/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.plugins.server.netty.RequestHandler;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpRequestDecoder;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpResponseEncoder;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class NettyJaxrsServer
implements EmbeddedJaxrsServer {
    protected ServerBootstrap bootstrap = new ServerBootstrap();
    protected int port = 8080;
    protected ResteasyDeployment deployment = new ResteasyDeployment();
    protected String root = "";
    protected SecurityDomain domain;
    private EventLoopGroup eventLoopGroup;
    private EventLoopGroup eventExecutor;
    private int ioWorkerCount = Runtime.getRuntime().availableProcessors() * 2;
    private int executorThreadCount = 16;
    private SSLContext sslContext;
    private int maxRequestSize = 0xA00000;
    private int backlog = 128;

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setIoWorkerCount(int ioWorkerCount) {
        this.ioWorkerCount = ioWorkerCount;
    }

    public void setExecutorThreadCount(int executorThreadCount) {
        this.executorThreadCount = executorThreadCount;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setDeployment(ResteasyDeployment deployment) {
        this.deployment = deployment;
    }

    public void setRootResourcePath(String rootResourcePath) {
        this.root = rootResourcePath;
        if (this.root != null && this.root.equals("/")) {
            this.root = "";
        }
    }

    public ResteasyDeployment getDeployment() {
        return this.deployment;
    }

    public void setSecurityDomain(SecurityDomain sc) {
        this.domain = sc;
    }

    public void start() {
        this.eventLoopGroup = new NioEventLoopGroup(this.ioWorkerCount);
        this.eventExecutor = new NioEventLoopGroup(this.executorThreadCount);
        this.deployment.start();
        final RequestDispatcher dispatcher = new RequestDispatcher((SynchronousDispatcher)this.deployment.getDispatcher(), this.deployment.getProviderFactory(), this.domain);
        if (this.sslContext == null) {
            ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.eventLoopGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpRequestDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(NettyJaxrsServer.this.maxRequestSize)});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpResponseEncoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new RestEasyHttpRequestDecoder(dispatcher.getDispatcher(), NettyJaxrsServer.this.root, RestEasyHttpRequestDecoder.Protocol.HTTP)});
                    ch.pipeline().addLast(new ChannelHandler[]{new RestEasyHttpResponseEncoder(dispatcher)});
                    ch.pipeline().addLast((EventExecutorGroup)NettyJaxrsServer.this.eventExecutor, new ChannelHandler[]{new RequestHandler(dispatcher)});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)this.backlog)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        } else {
            final SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.eventLoopGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addFirst(new ChannelHandler[]{new SslHandler(engine)});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpRequestDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(NettyJaxrsServer.this.maxRequestSize)});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpResponseEncoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new RestEasyHttpRequestDecoder(dispatcher.getDispatcher(), NettyJaxrsServer.this.root, RestEasyHttpRequestDecoder.Protocol.HTTPS)});
                    ch.pipeline().addLast(new ChannelHandler[]{new RestEasyHttpResponseEncoder(dispatcher)});
                    ch.pipeline().addLast((EventExecutorGroup)NettyJaxrsServer.this.eventExecutor, new ChannelHandler[]{new RequestHandler(dispatcher)});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)this.backlog)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        this.bootstrap.bind(this.port).syncUninterruptibly();
    }

    public void stop() {
        this.eventLoopGroup.shutdownGracefully();
        this.eventExecutor.shutdownGracefully();
    }
}

