/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mod_cluster;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.HostConfig;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.IntrospectionUtils;

public class JBossWeb
extends StandardService {
    private String route = null;

    private void copyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    private static void copyFiles(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdirs();
            }
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                File dest1 = new File(dest, list[i]);
                File src1 = new File(src, list[i]);
                JBossWeb.copyFiles(src1, dest1);
            }
        } else {
            int bytesRead;
            FileInputStream fin = null;
            FileOutputStream fout = null;
            byte[] buffer = new byte[4096];
            fin = new FileInputStream(src);
            fout = new FileOutputStream(dest);
            while ((bytesRead = fin.read(buffer)) >= 0) {
                fout.write(buffer, 0, bytesRead);
            }
            fout.close();
            fin.close();
        }
    }

    private void copyNativeDir(String route) throws IOException {
        File in = new File("bin/");
        if (!in.exists()) {
            return;
        }
        File ou = new File("node1/bin");
        if (!ou.exists()) {
            ou.mkdirs();
        }
        JBossWeb.copyFiles(in, ou);
    }

    public JBossWeb(String route, String host, boolean nat, String webapp, String[] Aliases) throws IOException {
        if (nat) {
            this.copyNativeDir(route);
        }
        System.setProperty("catalina.base", route);
        System.setProperty("catalina.home", route);
        this.route = route;
        StandardEngine baseEngine = new StandardEngine();
        baseEngine.setName(host + "Engine" + route);
        baseEngine.setDefaultHost(host);
        baseEngine.setJvmRoute(route);
        baseEngine.setRealm(null);
        File fd = new File(route + "/webapps/" + webapp);
        fd.mkdirs();
        String docBase = fd.getAbsolutePath();
        String appBase = fd.getParent();
        fd = new File(route + "/webapps/" + webapp, "index.html");
        FileWriter out = new FileWriter(fd);
        out.write(route + ":This is a test\n");
        out.close();
        fd = new File(route + "/webapps/" + webapp + "/WEB-INF/classes");
        fd.mkdirs();
        fd = new File(route + "/webapps/" + webapp + "/WEB-INF/classes", "MyCount.class");
        File fdin = new File("MyCount.class");
        if (!fdin.exists()) {
            fdin = new File("target/classes/MyCount.class");
        }
        this.copyFile(fdin, fd);
        fd = new File(route + "/webapps/" + webapp + "/WEB-INF/classes", "MyTest.class");
        fdin = new File("MyTest.class");
        if (!fdin.exists()) {
            fdin = new File("target/classes/MyTest.class");
        }
        this.copyFile(fdin, fd);
        StandardHost baseHost = new StandardHost();
        baseHost.setAppBase(appBase);
        baseHost.setName(host);
        baseHost.setBackgroundProcessorDelay(1);
        baseHost.setConfigClass("org.apache.catalina.startup.ContextConfig");
        if (Aliases != null && Aliases.length > 0) {
            for (int j = 0; j < Aliases.length; ++j) {
                baseHost.addAlias(Aliases[j]);
            }
        }
        HostConfig hostConfig = new HostConfig();
        baseHost.addLifecycleListener((LifecycleListener)hostConfig);
        baseEngine.addChild((Container)baseHost);
        StandardContext rootContext = new StandardContext();
        rootContext.setDocBase(docBase);
        if (webapp.equals("ROOT")) {
            rootContext.setPath("");
        } else {
            rootContext.setPath("/" + webapp);
        }
        ContextConfig config = new ContextConfig();
        ((Lifecycle)rootContext).addLifecycleListener((LifecycleListener)config);
        rootContext.setIgnoreAnnotations(true);
        rootContext.setPrivileged(true);
        rootContext.setInstanceManager((InstanceManager)new LocalInstanceManager());
        Wrapper testwrapper = rootContext.createWrapper();
        testwrapper.setName("MyCount");
        testwrapper.setServletClass("MyCount");
        testwrapper.setLoadOnStartup(0);
        rootContext.addChild((Container)testwrapper);
        rootContext.addServletMapping("/MyCount", "MyCount");
        Wrapper wrapper = rootContext.createWrapper();
        wrapper.setName("MyTest");
        wrapper.setServletClass("MyTest");
        wrapper.setLoadOnStartup(0);
        rootContext.addChild((Container)wrapper);
        rootContext.addServletMapping("/MyTest", "MyTest");
        baseHost.addChild((Container)rootContext);
        this.container = baseEngine;
        baseEngine.setService((Service)this);
        this.setName(host + "Engine" + route);
    }

    public JBossWeb(String route, String host) throws IOException {
        this(route, host, false);
    }

    public JBossWeb(String route, String host, boolean nat) throws IOException {
        this(route, host, nat, "ROOT");
    }

    public JBossWeb(String route, String host, String webapp) throws IOException {
        this(route, host, false, webapp);
    }

    public JBossWeb(String route, String host, boolean nat, String webapp) throws IOException {
        this(route, host, nat, webapp, null);
    }

    void AddHost(String host, String[] Aliases) {
        File fd = new File(host + "/webapps/");
        fd.mkdirs();
        String appBase = fd.getPath();
        StandardHost baseHost = new StandardHost();
        baseHost.setAppBase(appBase);
        baseHost.setName(host);
        baseHost.setBackgroundProcessorDelay(1);
        baseHost.setConfigClass("org.apache.catalina.startup.ContextConfig");
        if (Aliases != null && Aliases.length > 0) {
            for (int j = 0; j < Aliases.length; ++j) {
                baseHost.addAlias(Aliases[j]);
            }
        }
        HostConfig hostConfig = new HostConfig();
        baseHost.addLifecycleListener((LifecycleListener)hostConfig);
        Engine engine = (Engine)this.getContainer();
        engine.addChild((Container)baseHost);
    }

    void AddContext(String path, String base, String servletname, boolean wait, String hostname) throws IOException {
        File fd = new File(this.route + "/webapps/" + base);
        fd.mkdirs();
        String docBase = fd.getAbsolutePath();
        fd = new File(this.route + "/webapps/" + base + "/WEB-INF/classes");
        fd.mkdirs();
        fd = new File(this.route + "/webapps/" + base + "/WEB-INF/classes", "MyCount.class");
        File fdin = new File("MyCount.class");
        if (!fdin.exists()) {
            fdin = new File("target/classes/MyCount.class");
        }
        this.copyFile(fdin, fd);
        fd = new File(this.route + "/webapps/" + base + "/WEB-INF/classes", "MyTest.class");
        fdin = new File("MyTest.class");
        if (!fdin.exists()) {
            fdin = new File("target/classes/MyTest.class");
        }
        this.copyFile(fdin, fd);
        System.out.println("AddContext: " + path + "/" + servletname + " on " + docBase);
        StandardContext context = new StandardContext();
        context.setDocBase(docBase);
        context.setPath(path);
        context.setInstanceManager((InstanceManager)new LocalInstanceManager());
        ContextConfig config = new ContextConfig();
        ((Lifecycle)context).addLifecycleListener((LifecycleListener)config);
        context.setIgnoreAnnotations(true);
        context.setPrivileged(true);
        if (servletname != null) {
            Wrapper wrapper = context.createWrapper();
            wrapper.setName(servletname);
            wrapper.setServletClass(servletname);
            if (wait) {
                wrapper.addInitParameter("wait", "10000");
                wrapper.setLoadOnStartup(1);
            } else {
                wrapper.setLoadOnStartup(0);
            }
            context.addChild((Container)wrapper);
            context.addServletMapping("/" + servletname, servletname);
        }
        Engine engine = (Engine)this.getContainer();
        Container[] containers = engine.findChildren();
        for (int j = 0; j < containers.length; ++j) {
            if (!(containers[j] instanceof Host)) continue;
            Host host = (Host)containers[j];
            if (hostname != null && !host.getName().equals(hostname)) continue;
            System.out.println("AddContext: " + path + " added on " + host);
            host.addChild((Container)context);
        }
    }

    void AddContext(String path, String docBase, String servletname, boolean wait) throws IOException {
        this.AddContext(path, docBase, servletname, wait, null);
    }

    void AddContext(String path, String docBase) throws IOException {
        this.AddContext(path, docBase, "MyCount", false, null);
    }

    public void addWAR(String file, String route) throws IOException {
        File fd = new File(route + "/" + route + "/webapps");
        fd.mkdirs();
        String sep = System.getProperty("file.separator");
        String[] paths = file.split(sep);
        fd = new File(route + "/" + route + "/webapps", paths[paths.length - 1]);
        File fdin = new File(file);
        this.copyFile(fdin, fd);
    }

    public Connector addConnector(int port) throws Exception {
        return this.addConnector(port, "ajp");
    }

    public Connector addConnector(int port, String scheme) throws Exception {
        return this.addConnector(port, scheme, null);
    }

    public Connector addConnector(int port, String protocol, String address) throws Exception {
        Connector connector = null;
        if (protocol.equals("ajp")) {
            connector = new Connector("org.apache.coyote.ajp.AjpProtocol");
        } else if (protocol.equals("http")) {
            connector = new Connector(protocol);
        }
        if (address != null) {
            IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)("" + address));
        }
        IntrospectionUtils.setProperty((Object)connector, (String)"port", (String)("" + port));
        this.addConnector(connector);
        return connector;
    }

    public void removeContext(String path, String hostname) {
        Engine engine = (Engine)this.getContainer();
        Container[] containers = engine.findChildren();
        for (int j = 0; j < containers.length; ++j) {
            Context context;
            if (!(containers[j] instanceof StandardHost)) continue;
            StandardHost host = (StandardHost)containers[j];
            if (hostname != null && !host.getName().equals(hostname) || (context = (Context)host.findChild(path)) == null) continue;
            containers[j].removeChild((Container)context);
        }
    }

    public void removeContext(String path) {
        this.removeContext(path, null);
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        private LocalInstanceManager() {
        }

        public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(className).newInstance();
        }

        public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(fqcn, false, classLoader).newInstance();
        }

        public Object newInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
            return c.newInstance();
        }

        public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
            throw new IllegalStateException();
        }

        public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        }
    }
}

