/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mod_cluster;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class Client
extends Thread {
    private String jsessionid = null;
    private String URL = null;
    private String BaseURL = "http://localhost:8000";
    String post = null;
    String user = null;
    String pass = null;
    InputStream fd = null;
    private String VirtualHost = null;
    private int nbtest = 10;
    private int delay = 1000;
    private int wait = 100;
    private Random rand = null;
    private boolean checkcookie = true;
    private boolean checknode = true;
    private boolean success = true;
    private String node = null;
    public int httpResponseCode = 0;
    public String requestedSessionId = null;
    private HttpClient httpClient = null;
    private String response = null;
    private boolean logok = Boolean.valueOf(System.getProperty("logok", "false"));

    public static void main(String[] args) throws Exception {
        int i;
        if (args.length != 2) {
            System.err.println("missing command line arguments");
            System.exit(1);
        }
        Client[] client = new Client[50];
        for (i = 0; i < client.length; ++i) {
            client[i] = new Client();
            client[i].runit(args[0], 100000, true, Integer.parseInt(args[1]));
        }
        System.out.println("making \"second\" requests");
        for (i = 0; i < client.length; ++i) {
            client[i].start();
        }
        for (i = 0; i < client.length; ++i) {
            try {
                client[i].join();
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        for (i = 0; i < client.length; ++i) {
            if (client[i].getresultok()) continue;
            System.out.println("Failed: at least one client failed");
            System.exit(1);
        }
        System.out.println("Done");
    }

    public int runit(String URL2, int nbtest, boolean checkcookie, String post, String user, String pass, InputStream fd) throws Exception {
        this.fd = fd;
        return this.runit(URL2, nbtest, checkcookie, post, user, pass);
    }

    public int runit(String URL2, int nbtest, boolean checkcookie, String post, String user, String pass, File fd) throws Exception {
        this.fd = new FileInputStream(fd);
        return this.runit(URL2, nbtest, checkcookie, post, user, pass);
    }

    public int runit(String URL2, int nbtest, boolean checkcookie, String post, String user, String pass) throws Exception {
        this.post = post;
        this.user = user;
        this.pass = pass;
        return this.runit(URL2, nbtest, checkcookie);
    }

    public int runit(String URL2, int nbtest, boolean checkcookie, boolean checknode) throws Exception {
        this.checknode = checknode;
        return this.runit(URL2, nbtest, checkcookie);
    }

    public int runit(String URL2, int nbtest, boolean checkcookie) throws Exception {
        this.URL = URL2.startsWith("http://") ? URL2 : this.BaseURL.concat(URL2);
        this.checkcookie = checkcookie;
        this.nbtest = nbtest;
        return this.runit();
    }

    public int runit(String URL2, int nbtest, boolean checkcookie, int wait) throws Exception {
        this.wait = wait;
        return this.runit(URL2, nbtest, checkcookie);
    }

    public int runit() throws Exception {
        PostMethod pm = null;
        GetMethod gm = null;
        GetMethod bm = null;
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
        }
        if (this.fd != null) {
            pm = new PostMethod(this.URL);
            byte[] buffet = new byte[6144];
            for (int i = 0; i < buffet.length; ++i) {
                buffet[i] = 97;
            }
            ByteArrayRequestEntity buf = new ByteArrayRequestEntity(buffet);
            pm.setRequestEntity((RequestEntity)buf);
            pm.setHttp11(true);
            pm.setContentChunked(true);
            bm = pm;
        } else if (this.post != null) {
            pm = new PostMethod(this.URL);
            pm.setRequestEntity((RequestEntity)new StringRequestEntity(this.post, "application/x-www-form-urlencoded", "UTF8"));
            bm = pm;
        } else {
            bm = gm = new GetMethod(this.URL);
        }
        if (this.user != null) {
            UsernamePasswordCredentials cred = new UsernamePasswordCredentials(this.user, this.pass);
            this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)cred);
        }
        Integer connectionTimeout = 40000;
        bm.getParams().setParameter("http.socket.timeout", (Object)connectionTimeout);
        bm.getParams().setParameter("http.connection.timeout", (Object)connectionTimeout);
        if (this.VirtualHost != null) {
            bm.getParams().setVirtualHost(this.VirtualHost);
        }
        this.httpClient.getParams().setParameter("http.socket.timeout", (Object)connectionTimeout);
        this.httpClient.getParams().setParameter("http.connection.timeout", (Object)connectionTimeout);
        if (this.jsessionid != null) {
            bm.setRequestHeader("Cookie", "JSESSIONID=" + this.jsessionid);
        }
        try {
            long endtime;
            long starttime;
            if (gm == null) {
                pm.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
                starttime = System.currentTimeMillis();
                this.httpResponseCode = this.httpClient.executeMethod((HttpMethod)pm);
                endtime = System.currentTimeMillis();
            } else {
                gm.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
                starttime = System.currentTimeMillis();
                this.httpResponseCode = this.httpClient.executeMethod((HttpMethod)gm);
                endtime = System.currentTimeMillis();
            }
            if (this.httpResponseCode == 200) {
                this.response = bm.getResponseBodyAsString();
                Cookie[] cookies = this.httpClient.getState().getCookies();
                if (cookies != null && cookies.length != 0) {
                    for (int i = 0; i < cookies.length; ++i) {
                        Cookie cookie = cookies[i];
                        if (!cookie.getName().equals("JSESSIONID")) continue;
                        if (this.jsessionid == null) {
                            this.jsessionid = cookie.getValue();
                            String[] nodes = this.jsessionid.split("\\.");
                            if (nodes.length == 2) {
                                this.node = nodes[1];
                            }
                            System.out.println("cookie first time: " + this.jsessionid);
                            bm.releaseConnection();
                            return 0;
                        }
                        if (this.jsessionid.compareTo(cookie.getValue()) == 0) {
                            if (this.logok) {
                                if (bm.getResponseHeader("Date") != null) {
                                    System.out.println("cookie ok: " + bm.getResponseHeader("Date").toString().replace('\r', ' ').replace('\n', ' ') + " response time: " + (endtime - starttime));
                                } else {
                                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                                    Date date = new Date();
                                    System.out.println("cookie ok: " + dateFormat.format(date) + " response time: " + (endtime - starttime));
                                }
                            }
                            bm.releaseConnection();
                            return 0;
                        }
                        System.out.println("cookie \"second\" time: " + cookie.getValue() + " : " + this.jsessionid);
                        System.out.println("cookie changed");
                        bm.releaseConnection();
                        if (this.checkcookie) {
                            return -1;
                        }
                        if (this.checknode) {
                            String[] nodes = cookie.getValue().split("\\.");
                            if (nodes.length != 2) {
                                System.out.println("Can't find node in cookie");
                                return -1;
                            }
                            if (nodes[1].compareTo(this.node) == 0) {
                                return 0;
                            }
                            System.out.println("node " + nodes[1] + " changed too");
                            return -1;
                        }
                        return 0;
                    }
                } else {
                    int len = (int)bm.getResponseContentLength();
                    if (this.jsessionid != null && bm.getResponseBodyAsString(len).indexOf(this.jsessionid) != -1) {
                        bm.releaseConnection();
                        return 0;
                    }
                    if (this.jsessionid == null && !this.checkcookie) {
                        return 0;
                    }
                    System.out.println("No cookies");
                }
                Header head = bm.getResponseHeader("getRequestedSessionId");
                if (head != null) {
                    HeaderElement[] heade = head.getElements();
                    this.requestedSessionId = heade[0].getValue();
                } else {
                    this.requestedSessionId = null;
                }
            } else {
                System.out.println("response: " + this.httpResponseCode);
                System.out.println("response: " + bm.getStatusLine());
                this.response = bm.getResponseBodyAsString();
                this.success = false;
                this.httpClient = null;
            }
        }
        catch (HttpException e) {
            e.printStackTrace();
            this.success = false;
            this.httpClient = null;
        }
        System.out.println("DONE: " + this.httpResponseCode);
        bm.releaseConnection();
        return this.httpResponseCode;
    }

    @Override
    public void run() {
        if (this.rand == null) {
            this.rand = new Random();
        }
        try {
            Client.sleep(this.delay);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (int i = 0; i < this.nbtest; ++i) {
            try {
                if (this.runit() != 0) {
                    this.success = false;
                    return;
                }
                Client.sleep(this.rand.nextInt(this.wait) * 10);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.success = false;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.success = false;
                return;
            }
        }
        System.out.println("DONE!");
    }

    public boolean getresultok() {
        return this.success;
    }

    public void setdelay(int delay) {
        this.delay = delay;
    }

    public void setnode(String node) {
        this.node = node;
    }

    public String getnode() {
        return this.node;
    }

    public void setVirtualHost(String VirtualHost) {
        this.VirtualHost = VirtualHost;
    }

    public String getVirtualHost() {
        return this.VirtualHost;
    }

    public String getResponse() {
        return this.response;
    }
}

