/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.ha.rpc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.ha.rpc.RpcResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRpcResponse<T>
implements RpcResponse<T> {
    private static final long serialVersionUID = -6410563421870835482L;
    private final ClusterNode sender;
    private transient Throwable exception;
    private transient T result;

    public DefaultRpcResponse(ClusterNode sender) {
        this.sender = sender;
    }

    @Override
    public ClusterNode getSender() {
        return this.sender;
    }

    @Override
    public T getResult() {
        if (this.exception != null) {
            throw Utils.convertToUnchecked((Throwable)this.exception);
        }
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public int hashCode() {
        return this.sender.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DefaultRpcResponse)) {
            return false;
        }
        DefaultRpcResponse response = (DefaultRpcResponse)object;
        return this.sender.equals(response.sender) && (this.result != null && response.result != null ? this.result.equals(response.result) : this.result == response.result) && !(this.exception != null ^ response.exception != null);
    }

    public String toString() {
        return MessageFormat.format("{0}({1})", this.sender, this.exception != null ? this.exception : this.result);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.result);
        out.writeObject(this.exception);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.result = in.readObject();
        this.exception = (Throwable)in.readObject();
    }
}

