/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.demo.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jboss.modcluster.demo.client.ChartManager;
import org.jboss.modcluster.demo.client.RequestDriver;
import org.jboss.modcluster.demo.client.load.ServerLoadParam;
import org.jboss.modcluster.demo.client.load.ServerLoadServlets;
import org.jfree.chart.ChartPanel;

public class ModClusterDemo {
    private static final String DEFAULT_HOST_NAME = System.getProperty("mod_cluster.proxy.host", "localhost");
    private static final String DEFAULT_PROXY_PORT = System.getProperty("mod_cluster.proxy.port", "8000");
    private static final String DEFAULT_CONTEXT_PATH = "load-demo";
    private static final String DEFAULT_SESSION_TIMEOUT = "20";
    private static final int DEFAULT_NUM_THREADS = 80;
    private static final int DEFAULT_SESSION_LIFE = 120;
    private static final int DEFAULT_SLEEP_TIME = 100;
    private static final int DEFAULT_STARTUP_TIME = 120;
    private final RequestDriver requestDriver = new RequestDriver();
    private final ChartManager chartManager = new ChartManager(this.requestDriver.getRequestCounts(), this.requestDriver.getSessionCounts());
    private final Timer timer = new Timer("ModClusterDemoTimer", false);
    private TimerTask currentTask;
    private JFrame frame;
    private JTextField proxyHostNameField;
    private JTextField proxyPortField;
    private JTextField contextPathField;
    private JCheckBox destroySessionField;
    private JTextField numThreadsField;
    private JTextField sessionLifeField;
    private JLabel sessionTimeoutLabel;
    private JTextField sessionTimeoutField;
    private JTextField sleepTimeField;
    private JTextField startupTimeField;
    private JTextField targetHostNameField;
    private JTextField targetPortField;
    private JLabel totalClientsLabel;
    private JLabel liveClientsLabel;
    private JLabel failedClientsLabel;
    private JLabel totalClientsLabelReq;
    private JLabel liveClientsLabelReq;
    private JLabel failedClientsLabelReq;
    private JLabel totalClientsLabelSess;
    private JLabel liveClientsLabelSess;
    private JLabel failedClientsLabelSess;
    private ServerLoadServlets selectedLoadServlet;
    private JLabel targetServletParamLabel1;
    private JTextField targetServletParamField1;
    private JLabel targetServletParamLabel2;
    private JTextField targetServletParamField2;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ModClusterDemo window = new ModClusterDemo();
                    window.frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ModClusterDemo() {
        this.createContents();
    }

    private void createContents() {
        this.frame = new JFrame();
        this.frame.setBounds(100, 100, 675, 422);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setTitle("Load Balancing Demonstration");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ModClusterDemo.this.stop();
                ModClusterDemo.this.timer.cancel();
            }
        });
        final JTabbedPane tabbedPane = new JTabbedPane();
        this.frame.getContentPane().add((Component)tabbedPane, "Center");
        tabbedPane.addTab("Client Control", null, this.createClientControlPanel(), null);
        final JPanel loadPanel = this.createServerLoadControlPanel();
        tabbedPane.addTab("Server Load Control", null, loadPanel, null);
        tabbedPane.addTab("Request Balancing", null, this.createRequestBalancingPanel(), null);
        tabbedPane.addTab("Session Balancing", null, this.createSessionBalancingPanel(), null);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (loadPanel.equals(tabbedPane.getSelectedComponent())) {
                    String text = ModClusterDemo.this.targetHostNameField.getText();
                    if (text == null || text.length() == 0) {
                        ModClusterDemo.this.targetHostNameField.setText(ModClusterDemo.this.proxyHostNameField.getText());
                    }
                    if ((text = ModClusterDemo.this.targetPortField.getText()) == null || text.length() == 0) {
                        ModClusterDemo.this.targetPortField.setText(ModClusterDemo.this.proxyPortField.getText());
                    }
                }
            }
        });
    }

    private JPanel createClientControlPanel() {
        JPanel controlPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{7, 0, 7, 0, 7, 0, 7, 7, 0, 0, 7};
        gridBagLayout.rowHeights = new int[]{0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0};
        controlPanel.setLayout(gridBagLayout);
        JLabel label = new JLabel();
        label.setText("Proxy Hostname:");
        label.setToolTipText("Hostname clients should request");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        controlPanel.add((Component)label, gridBagConstraints);
        this.proxyHostNameField = new JTextField();
        this.proxyHostNameField.setText(DEFAULT_HOST_NAME);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        controlPanel.add((Component)this.proxyHostNameField, gridBagConstraints);
        label = new JLabel();
        label.setText("Proxy Port:");
        label.setToolTipText("Port clients should request");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        controlPanel.add((Component)label, gridBagConstraints);
        this.proxyPortField = new JTextField();
        this.proxyPortField.setText(DEFAULT_PROXY_PORT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        controlPanel.add((Component)this.proxyPortField, gridBagConstraints);
        label = new JLabel();
        label.setText("Context Path:");
        label.setToolTipText("Context path of the demo war");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        controlPanel.add((Component)label, gridBagConstraints);
        this.contextPathField = new JTextField();
        this.contextPathField.setText(DEFAULT_CONTEXT_PATH);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        controlPanel.add((Component)this.contextPathField, gridBagConstraints);
        label = new JLabel();
        label.setText("Session Life (s):");
        label.setToolTipText("Number of seconds client should use session before invalidating or abandoning it");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 6;
        controlPanel.add((Component)label, gridBagConstraints);
        this.sessionLifeField = new JTextField();
        this.sessionLifeField.setText(String.valueOf(120));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        controlPanel.add((Component)this.sessionLifeField, gridBagConstraints);
        label = new JLabel();
        label.setText("Invalidate:");
        label.setToolTipText("Check if session should be invalidated at end of life; uncheck to abandon session");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 1;
        controlPanel.add((Component)label, gridBagConstraints);
        this.destroySessionField = new JCheckBox();
        this.destroySessionField.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        controlPanel.add((Component)this.destroySessionField, gridBagConstraints);
        this.sessionTimeoutLabel = new JLabel();
        this.sessionTimeoutLabel.setText("Session Timeout (s):");
        this.sessionTimeoutLabel.setToolTipText("Session maxInactiveInterval if abandoned, in seconds");
        this.sessionTimeoutLabel.setEnabled(this.destroySessionField.isSelected());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 6;
        controlPanel.add((Component)this.sessionTimeoutLabel, gridBagConstraints);
        this.sessionTimeoutField = new JTextField();
        this.sessionTimeoutField.setText(String.valueOf(DEFAULT_SESSION_TIMEOUT));
        this.sessionTimeoutField.setEnabled(this.destroySessionField.isSelected());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        controlPanel.add((Component)this.sessionTimeoutField, gridBagConstraints);
        label = new JLabel();
        label.setText("Num Threads:");
        label.setToolTipText("Number of client threads to launch; max number of concurrent requests");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 1;
        controlPanel.add((Component)label, gridBagConstraints);
        this.numThreadsField = new JTextField();
        this.numThreadsField.setText(String.valueOf(80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        controlPanel.add((Component)this.numThreadsField, gridBagConstraints);
        label = new JLabel();
        label.setText("Sleep Time (ms):");
        label.setToolTipText("Number of ms each client should sleep between requests");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 6;
        controlPanel.add((Component)label, gridBagConstraints);
        this.sleepTimeField = new JTextField();
        this.sleepTimeField.setText(String.valueOf(100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        controlPanel.add((Component)this.sleepTimeField, gridBagConstraints);
        label = new JLabel();
        label.setText("Startup Time (s):");
        label.setToolTipText("Number of seconds over which client threads should be launched");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 1;
        controlPanel.add((Component)label, gridBagConstraints);
        this.startupTimeField = new JTextField();
        this.startupTimeField.setText(String.valueOf(120));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        controlPanel.add((Component)this.startupTimeField, gridBagConstraints);
        JButton startButton = new JButton();
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModClusterDemo.this.start();
            }
        });
        startButton.setText("Start");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        controlPanel.add((Component)startButton, gridBagConstraints);
        JButton stopButton = new JButton();
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModClusterDemo.this.stop();
            }
        });
        stopButton.setText("Stop");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        controlPanel.add((Component)stopButton, gridBagConstraints);
        JPanel statusPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        controlPanel.add((Component)statusPanel, gridBagConstraints);
        gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 7};
        gridBagLayout.rowHeights = new int[]{0, 7, 0, 0};
        statusPanel.setLayout(gridBagLayout);
        label = new JLabel();
        label.setText("Client Status");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        statusPanel.add((Component)label, gridBagConstraints);
        label = new JLabel();
        label.setText("Total clients:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        statusPanel.add((Component)label, gridBagConstraints);
        this.totalClientsLabel = new JLabel();
        this.totalClientsLabel.setText(String.valueOf("0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        statusPanel.add((Component)this.totalClientsLabel, gridBagConstraints);
        label = new JLabel();
        label.setText("Live clients:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        statusPanel.add((Component)label, gridBagConstraints);
        this.liveClientsLabel = new JLabel();
        this.liveClientsLabel.setText(String.valueOf("0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        statusPanel.add((Component)this.liveClientsLabel, gridBagConstraints);
        label = new JLabel();
        label.setText("Failed clients:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        statusPanel.add((Component)label, gridBagConstraints);
        this.failedClientsLabel = new JLabel();
        this.failedClientsLabel.setText(String.valueOf("0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        statusPanel.add((Component)this.failedClientsLabel, gridBagConstraints);
        return controlPanel;
    }

    private JPanel createServerLoadControlPanel() {
        JPanel loadPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{7, 0, 7, 0, 7, 0, 7, 7, 0, 0, 7};
        gridBagLayout.rowHeights = new int[]{0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0};
        loadPanel.setLayout(gridBagLayout);
        JLabel label = new JLabel();
        label.setText("Target Hostname:");
        label.setToolTipText("Hostname clients should request");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        loadPanel.add((Component)label, gridBagConstraints);
        this.targetHostNameField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        loadPanel.add((Component)this.targetHostNameField, gridBagConstraints);
        label = new JLabel();
        label.setText("Target Port:");
        label.setToolTipText("Port clients should request");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        loadPanel.add((Component)label, gridBagConstraints);
        this.targetPortField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        loadPanel.add((Component)this.targetPortField, gridBagConstraints);
        label = new JLabel();
        label.setText("Load Creation Action:");
        label.setToolTipText("Action to invoke on target server to simulate server load");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        loadPanel.add((Component)label, gridBagConstraints);
        EnumSet<ServerLoadServlets> es = EnumSet.allOf(ServerLoadServlets.class);
        Vector<ServerLoadServlets> v = new Vector<ServerLoadServlets>(es);
        JComboBox<ServerLoadServlets> targetLoadServletCombo = new JComboBox<ServerLoadServlets>(v);
        targetLoadServletCombo.setRenderer(new ServerLoadServletCellRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        loadPanel.add(targetLoadServletCombo, gridBagConstraints);
        targetLoadServletCombo.setSelectedItem((Object)ServerLoadServlets.CONNECTOR_THREAD_USAGE);
        this.selectedLoadServlet = ServerLoadServlets.CONNECTOR_THREAD_USAGE;
        ServerLoadParam param = ServerLoadServlets.CONNECTOR_THREAD_USAGE.getParams().get(0);
        this.targetServletParamLabel1 = new JLabel();
        this.targetServletParamLabel1.setText(param.getLabel() + ":");
        this.targetServletParamLabel1.setToolTipText(param.getDescription());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 1;
        loadPanel.add((Component)this.targetServletParamLabel1, gridBagConstraints);
        this.targetServletParamField1 = new JTextField();
        this.targetServletParamField1.setText(param.getValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        loadPanel.add((Component)this.targetServletParamField1, gridBagConstraints);
        param = ServerLoadServlets.CONNECTOR_THREAD_USAGE.getParams().get(1);
        this.targetServletParamLabel2 = new JLabel();
        this.targetServletParamLabel2.setText(param.getLabel() + ":");
        this.targetServletParamLabel2.setToolTipText(param.getDescription());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 1;
        loadPanel.add((Component)this.targetServletParamLabel2, gridBagConstraints);
        this.targetServletParamField2 = new JTextField();
        this.targetServletParamField2.setText(param.getValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        loadPanel.add((Component)this.targetServletParamField2, gridBagConstraints);
        targetLoadServletCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    ModClusterDemo.this.selectedLoadServlet = (ServerLoadServlets)((Object)e.getItem());
                    List<ServerLoadParam> params = ModClusterDemo.this.selectedLoadServlet.getParams();
                    if (params.size() > 0) {
                        ModClusterDemo.this.targetServletParamLabel1.setText(params.get(0).getLabel() + ":");
                        ModClusterDemo.this.targetServletParamLabel1.setToolTipText(params.get(0).getDescription());
                        ModClusterDemo.this.targetServletParamField1.setVisible(true);
                        ModClusterDemo.this.targetServletParamField1.setText(params.get(0).getValue());
                    } else {
                        ModClusterDemo.this.targetServletParamLabel1.setText(" ");
                        ModClusterDemo.this.targetServletParamField1.setVisible(false);
                    }
                    if (params.size() > 1) {
                        ModClusterDemo.this.targetServletParamLabel2.setText(params.get(1).getLabel() + ":");
                        ModClusterDemo.this.targetServletParamLabel2.setToolTipText(params.get(1).getDescription());
                        ModClusterDemo.this.targetServletParamField2.setVisible(true);
                        ModClusterDemo.this.targetServletParamField2.setText(params.get(1).getValue());
                    } else {
                        ModClusterDemo.this.targetServletParamLabel2.setText(" ");
                        ModClusterDemo.this.targetServletParamField2.setVisible(false);
                    }
                }
            }
        });
        JButton createLoadButton = new JButton();
        createLoadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModClusterDemo.this.createLoad();
            }
        });
        createLoadButton.setText("Create Load");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.anchor = 11;
        loadPanel.add((Component)createLoadButton, gridBagConstraints);
        return loadPanel;
    }

    private JPanel createRequestBalancingPanel() {
        JPanel requestBalancingPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        requestBalancingPanel.setLayout(gridBagLayout);
        ChartPanel requestChart = new ChartPanel(this.chartManager.getRequestBalancingChart(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        requestBalancingPanel.add((Component)requestChart, gridBagConstraints);
        JPanel clientStatusPanel = new JPanel();
        gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7};
        gridBagLayout.rowHeights = new int[]{7, 0};
        clientStatusPanel.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        requestBalancingPanel.add((Component)clientStatusPanel, gridBagConstraints);
        JLabel label = new JLabel();
        label.setText("Total clients:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)label, gridBagConstraints);
        this.totalClientsLabelReq = new JLabel();
        this.totalClientsLabelReq.setText(String.valueOf("0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)this.totalClientsLabelReq, gridBagConstraints);
        label = new JLabel();
        label.setText("Live clients:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)label, gridBagConstraints);
        this.liveClientsLabelReq = new JLabel();
        this.liveClientsLabelReq.setText(String.valueOf("0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)this.liveClientsLabelReq, gridBagConstraints);
        label = new JLabel();
        label.setText("Failed clients:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 9;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)label, gridBagConstraints);
        this.failedClientsLabelReq = new JLabel();
        this.failedClientsLabelReq.setText(String.valueOf("0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 11;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)this.failedClientsLabelReq, gridBagConstraints);
        return requestBalancingPanel;
    }

    private JPanel createSessionBalancingPanel() {
        JPanel sessionBalancingPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        sessionBalancingPanel.setLayout(gridBagLayout);
        ChartPanel sessionBalancingChart = new ChartPanel(this.chartManager.getSessionBalancingChart(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        sessionBalancingPanel.add((Component)sessionBalancingChart, gridBagConstraints);
        JPanel clientStatusPanel = new JPanel();
        gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7};
        gridBagLayout.rowHeights = new int[]{7, 0};
        clientStatusPanel.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        sessionBalancingPanel.add((Component)clientStatusPanel, gridBagConstraints);
        JLabel label = new JLabel();
        label.setText("Total clients:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)label, gridBagConstraints);
        this.totalClientsLabelSess = new JLabel();
        this.totalClientsLabelSess.setText(String.valueOf("0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)this.totalClientsLabelSess, gridBagConstraints);
        label = new JLabel();
        label.setText("Live clients:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)label, gridBagConstraints);
        this.liveClientsLabelSess = new JLabel();
        this.liveClientsLabelSess.setText(String.valueOf("0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)this.liveClientsLabelSess, gridBagConstraints);
        label = new JLabel();
        label.setText("Failed clients:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 9;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)label, gridBagConstraints);
        this.failedClientsLabelSess = new JLabel();
        this.failedClientsLabelSess.setText(String.valueOf("0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 11;
        gridBagConstraints.anchor = 17;
        clientStatusPanel.add((Component)this.failedClientsLabelSess, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        sessionBalancingPanel.add((Component)clientStatusPanel, gridBagConstraints);
        return sessionBalancingPanel;
    }

    private void start() {
        URL destroyURL;
        URL requestURL;
        String sessionTimeoutText = this.sessionTimeoutField.getText();
        int sessionTimeout = -1;
        if (sessionTimeoutText != null && sessionTimeoutText.trim().length() > 0) {
            try {
                sessionTimeout = Integer.parseInt(sessionTimeoutText);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        boolean invalidate = this.destroySessionField.isSelected();
        String tmp = this.createBaseURL(this.proxyHostNameField.getText(), this.proxyPortField.getText()) + "record";
        try {
            if (invalidate) {
                requestURL = new URL(tmp);
                destroyURL = new URL(tmp + "?destroy=true");
            } else {
                String timeoutParam = sessionTimeout > 0 ? "?timeout=" + String.valueOf(sessionTimeout) : "";
                destroyURL = requestURL = new URL(tmp + timeoutParam);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.err);
            return;
        }
        int num_threads = 80;
        String numT = this.numThreadsField.getText();
        if (numT != null && numT.trim().length() > 0) {
            num_threads = Integer.parseInt(numT);
        }
        int session_life = 120;
        String sessL = this.sessionLifeField.getText();
        if (sessL != null && sessL.trim().length() > 0) {
            session_life = Integer.parseInt(sessL);
        }
        int sleep_time = 100;
        String sleepT = this.sleepTimeField.getText();
        if (sleepT != null && sleepT.trim().length() > 0) {
            sleep_time = Integer.parseInt(sleepT);
        }
        int startup_time = 120;
        String startT = this.startupTimeField.getText();
        if (startT != null && startT.trim().length() > 0) {
            startup_time = Integer.parseInt(startT);
        }
        this.currentTask = new GUIUpdateTimerTask();
        this.chartManager.start();
        this.timer.schedule(this.currentTask, 2000L, 2000L);
        this.requestDriver.start(requestURL, destroyURL, num_threads, session_life, sleep_time, startup_time);
    }

    private void stop() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        this.requestDriver.stop();
        this.updateStatusPanel();
    }

    private void createLoad() {
        URL requestURL;
        String val;
        String tmp = this.createBaseURL(this.targetHostNameField.getText(), this.targetPortField.getText()) + this.selectedLoadServlet.getServletPath();
        List<ServerLoadParam> params = this.selectedLoadServlet.getParams();
        if (params.size() > 0) {
            val = this.targetServletParamField1.getText();
            params.get(0).setValue(val);
            tmp = tmp + "?" + params.get(0).getName() + "=" + val;
        }
        if (params.size() > 1) {
            val = this.targetServletParamField2.getText();
            params.get(1).setValue(val);
            tmp = tmp + "&" + params.get(1).getName() + "=" + val;
        }
        try {
            requestURL = new URL(tmp);
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.err);
            return;
        }
        Runnable r = new Runnable(){
            private final byte[] buffer = new byte[1024];

            @Override
            public void run() {
                System.out.println("Sending load generation request " + requestURL);
                InputStream input = null;
                HttpURLConnection conn = null;
                try {
                    conn = (HttpURLConnection)requestURL.openConnection();
                    input = conn.getInputStream();
                    while (input.read(this.buffer) > 0) {
                    }
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(r);
        exec.shutdown();
    }

    private String createBaseURL(String hostText, String portText) {
        if (portText == null || portText.trim().length() == 0) {
            portText = "80";
        }
        portText = portText.trim();
        String contextPath = this.contextPathField.getText();
        if (contextPath == null) {
            contextPath = "";
        }
        contextPath.trim();
        if (contextPath.length() > 0 && '/' == contextPath.charAt(0)) {
            String string = contextPath = contextPath.length() == 1 ? "" : contextPath.substring(1);
        }
        if (contextPath.length() > 0 && '/' == contextPath.charAt(contextPath.length() - 1)) {
            contextPath = contextPath.length() == 1 ? "" : contextPath.substring(0, contextPath.length() - 1);
        }
        return "http://" + hostText + ":" + portText + "/" + contextPath + "/";
    }

    private void updateStatusPanel() {
        RequestDriver.ClientStatus status = this.requestDriver.getClientStatus();
        this.totalClientsLabel.setText(String.valueOf(status.clientCount));
        this.liveClientsLabel.setText(String.valueOf(status.liveClientCount));
        this.totalClientsLabelReq.setText(String.valueOf(status.clientCount));
        this.liveClientsLabelReq.setText(String.valueOf(status.liveClientCount));
        this.totalClientsLabelSess.setText(String.valueOf(status.clientCount));
        this.liveClientsLabelSess.setText(String.valueOf(status.liveClientCount));
        int failedCount = status.clientCount - status.successfulClientCount;
        this.failedClientsLabel.setText(String.valueOf(failedCount));
        this.failedClientsLabel.setForeground(failedCount == 0 ? Color.BLACK : Color.RED);
        this.failedClientsLabelReq.setText(String.valueOf(failedCount));
        this.failedClientsLabelReq.setForeground(failedCount == 0 ? Color.BLACK : Color.RED);
        this.failedClientsLabelSess.setText(String.valueOf(failedCount));
        this.failedClientsLabelSess.setForeground(failedCount == 0 ? Color.BLACK : Color.RED);
    }

    private class ServerLoadServletCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -8010662328204072428L;

        private ServerLoadServletCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setToolTipText(((ServerLoadServlets)((Object)value)).getDescription());
            return this;
        }
    }

    private class GUIUpdateTimerTask
    extends TimerTask {
        private GUIUpdateTimerTask() {
        }

        @Override
        public void run() {
            ModClusterDemo.this.chartManager.updateStats();
            ModClusterDemo.this.updateStatusPanel();
        }
    }
}

