/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.demo.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartManager {
    private final Map<String, AtomicInteger> requestCounts;
    private final Map<String, AtomicInteger> sessionCounts;
    private final Map<String, Integer> lastRequestCounts = new HashMap<String, Integer>();
    private final Map<String, XYSeries> requestSeries = new HashMap<String, XYSeries>();
    private final Map<String, XYSeries> sessionSeries = new HashMap<String, XYSeries>();
    private final XYSeriesCollection requestSeriesCollection = new XYSeriesCollection();
    private final XYSeriesCollection sessionSeriesCollection = new XYSeriesCollection();
    private final JFreeChart requestBalancingChart;
    private final JFreeChart sessionBalancingChart;
    private long lastUpdateTime = 0L;
    private int seriesCount;

    public ChartManager(Map<String, AtomicInteger> requestCounts, Map<String, AtomicInteger> sessionCounts) {
        this.requestCounts = requestCounts;
        this.sessionCounts = sessionCounts;
        this.requestBalancingChart = ChartFactory.createXYLineChart((String)"Request Balancing", (String)"Sample", (String)"Requests / Second", (XYDataset)this.requestSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.sessionBalancingChart = ChartFactory.createXYLineChart((String)"Session Balancing", (String)"Sample", (String)"Session Count", (XYDataset)this.sessionSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    }

    public JFreeChart getRequestBalancingChart() {
        return this.requestBalancingChart;
    }

    public JFreeChart getSessionBalancingChart() {
        return this.sessionBalancingChart;
    }

    public void start() {
        this.lastRequestCounts.clear();
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void updateStats() {
        String key;
        Integer xValue = new Integer(++this.seriesCount);
        long now = System.currentTimeMillis();
        long elapsed = (now - this.lastUpdateTime) / 1000L;
        if (elapsed == 0L) {
            --this.seriesCount;
            return;
        }
        this.lastUpdateTime = now;
        for (Map.Entry<String, AtomicInteger> entry : this.requestCounts.entrySet()) {
            Integer current;
            key = entry.getKey();
            Integer last = this.lastRequestCounts.put(key, current = new Integer(entry.getValue().get()));
            if (last == null) {
                last = new Integer(0);
            }
            int perSec = (int)((long)(current - last) / elapsed);
            XYSeries series = this.requestSeries.get(key);
            if (series == null) {
                series = this.createRequestSeries(key);
            }
            series.add((Number)xValue, (Number)new Integer(perSec));
        }
        for (Map.Entry<String, AtomicInteger> entry : this.sessionCounts.entrySet()) {
            key = entry.getKey();
            XYSeries series = this.sessionSeries.get(key);
            if (series == null) {
                series = this.createSessionSeries(key);
            }
            series.add((Number)xValue, (Number)new Integer(entry.getValue().get()));
        }
    }

    private XYSeries createSessionSeries(String key) {
        XYSeries series = new XYSeries((Comparable)((Object)key));
        series.setMaximumItemCount(20);
        this.sessionSeries.put(key, series);
        this.sessionSeriesCollection.addSeries(series);
        return series;
    }

    private XYSeries createRequestSeries(String key) {
        XYSeries series = new XYSeries((Comparable)((Object)key));
        series.setMaximumItemCount(20);
        this.requestSeries.put(key, series);
        this.requestSeriesCollection.addSeries(series);
        return series;
    }
}

