/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.tomcat;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.catalina.LifecycleState;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.threads.ResizableExecutor;
import org.jboss.modcluster.container.Connector;

public class TomcatConnector
implements Connector {
    protected final org.apache.catalina.connector.Connector connector;

    public TomcatConnector(org.apache.catalina.connector.Connector connector) {
        this.connector = connector;
    }

    public InetAddress getAddress() {
        Object value = IntrospectionUtils.getProperty((Object)this.connector.getProtocolHandler(), (String)"address");
        if (value instanceof InetAddress) {
            return (InetAddress)value;
        }
        if (value instanceof String) {
            try {
                return InetAddress.getByName((String)value);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setAddress(InetAddress address) {
        IntrospectionUtils.setProperty((Object)this.connector.getProtocolHandler(), (String)"address", (String)address.getHostAddress());
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public Connector.Type getType() {
        if (TomcatConnector.isAJP(this.connector)) {
            return Connector.Type.AJP;
        }
        ProtocolHandler handler = this.connector.getProtocolHandler();
        return Boolean.TRUE.equals(IntrospectionUtils.getProperty((Object)handler, (String)"SSLEnabled")) ? Connector.Type.HTTPS : Connector.Type.HTTP;
    }

    public boolean isReverse() {
        return Boolean.TRUE.equals(IntrospectionUtils.getProperty((Object)this.connector.getProtocolHandler(), (String)"reverseConnection"));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TomcatConnector)) {
            return false;
        }
        TomcatConnector connector = (TomcatConnector)object;
        return this.connector == connector.connector;
    }

    public int hashCode() {
        return this.connector.hashCode();
    }

    public String toString() {
        InetAddress address = this.getAddress();
        return String.format("%s://%s:%d", this.getType(), address != null ? address.getHostAddress() : "<undefined>", this.connector.getPort());
    }

    public static boolean isAJP(org.apache.catalina.connector.Connector connector) {
        String protocol = connector.getProtocol();
        return protocol.startsWith("AJP") || protocol.startsWith("org.apache.coyote.ajp");
    }

    public boolean isAvailable() {
        return LifecycleState.STARTED.equals((Object)this.connector.getState());
    }

    public int getMaxThreads() {
        Executor executor = this.connector.getProtocolHandler().getExecutor();
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getMaximumPoolSize();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getMaxThreads();
            }
        }
        return 0;
    }

    public int getBusyThreads() {
        Executor executor = this.connector.getProtocolHandler().getExecutor();
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getActiveCount();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getActiveCount();
            }
        }
        return 0;
    }

    protected Object getProtocolHandlerProperty(String property) {
        Field field = this.findField(this.connector.getProtocolHandler().getClass(), property);
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return field.get(this.connector.getProtocolHandler());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    Field findField(Class<?> targetClass, String name) {
        if (targetClass == null || Object.class.equals(targetClass)) {
            return null;
        }
        for (Field field : targetClass.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return this.findField(targetClass.getSuperclass(), name);
    }

    public long getBytesSent() {
        RequestGroupInfo info = this.getRequestGroupInfo();
        return info != null ? this.getRequestGroupInfo().getBytesSent() : 0L;
    }

    public long getBytesReceived() {
        RequestGroupInfo info = this.getRequestGroupInfo();
        return info != null ? this.getRequestGroupInfo().getBytesReceived() : 0L;
    }

    public long getRequestCount() {
        RequestGroupInfo info = this.getRequestGroupInfo();
        return info != null ? (long)this.getRequestGroupInfo().getRequestCount() : 0L;
    }

    protected Object getConnectionHandler() {
        return this.getProtocolHandlerProperty("cHandler");
    }

    protected RequestGroupInfo getRequestGroupInfo() {
        Object connectionHandler = this.getConnectionHandler();
        if (connectionHandler == null) {
            return null;
        }
        return this.getRequestGroupInfo(connectionHandler);
    }

    protected RequestGroupInfo getRequestGroupInfo(Object connectionHandler) {
        AbstractEndpoint.Handler handler = (AbstractEndpoint.Handler)connectionHandler;
        return (RequestGroupInfo)handler.getGlobal();
    }
}

