/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.tomcat;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.core.StandardServer;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;
import org.jboss.modcluster.ModClusterService;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.config.JvmRouteFactory;
import org.jboss.modcluster.config.ProxyConfiguration;
import org.jboss.modcluster.config.SessionDrainingStrategy;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.config.impl.SessionDrainingStrategyEnum;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.tomcat.LifecycleListenerFactory;
import org.jboss.modcluster.container.tomcat.ServiceLoaderTomcatFactory;
import org.jboss.modcluster.container.tomcat.TomcatConnectorConfiguration;
import org.jboss.modcluster.container.tomcat.TomcatEventHandlerAdapterFactory;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.LoadBalanceFactorProviderFactory;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProvider;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.modcluster.load.metric.impl.BusyConnectorsLoadMetric;

public class ModClusterListener
extends ModClusterConfig
implements TomcatConnectorConfiguration,
LifecycleListener,
LoadBalanceFactorProviderFactory,
ModClusterServiceMBean {
    private static final Logger log = Logger.getLogger(ModClusterListener.class);
    private final ModClusterServiceMBean service;
    private final LifecycleListener listener;
    Class<? extends LoadMetric> loadMetricClass = BusyConnectorsLoadMetric.class;
    private int initialLoad = 0;
    private float decayFactor = 2.0f;
    private int history = 9;
    private double capacity = 1.0;
    private String connectorAddress;
    private Integer connectorPort;
    private static final String ROOT_CONTEXT = "ROOT";
    private static final String CONTEXT_DELIMITER = ",";
    private static final String HOST_CONTEXT_DELIMITER = ":";

    public ModClusterListener() {
        ModClusterService service = new ModClusterService((ModClusterConfig)this, (LoadBalanceFactorProviderFactory)this);
        this.service = service;
        this.listener = ((LifecycleListenerFactory)ServiceLoaderTomcatFactory.load(LifecycleListenerFactory.class, TomcatEventHandlerAdapterFactory.class)).createListener((ContainerEventHandler)service, this);
    }

    protected ModClusterListener(ModClusterServiceMBean mbean, LifecycleListener listener) {
        this.service = mbean;
        this.listener = listener;
    }

    public LoadBalanceFactorProvider createLoadBalanceFactorProvider() {
        PrivilegedAction<LoadMetric> action = new PrivilegedAction<LoadMetric>(){

            @Override
            public LoadMetric run() {
                try {
                    return ModClusterListener.this.loadMetricClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        LoadMetric metric = AccessController.doPrivileged(action);
        metric.setCapacity(this.capacity);
        DynamicLoadBalanceFactorProvider provider = new DynamicLoadBalanceFactorProvider(Collections.singleton(metric), this.initialLoad);
        provider.setDecayFactor(this.decayFactor);
        provider.setHistory(this.history);
        return provider;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        this.listener.lifecycleEvent(event);
        Lifecycle source = event.getLifecycle();
        if (source instanceof Server) {
            Server server = (Server)source;
            String type = event.getType();
            if ("after_start".equals(type)) {
                try {
                    ObjectName name = this.getObjectName(server);
                    Registry.getRegistry(null, null).registerComponent((Object)this, name, ModClusterListener.class.getName());
                }
                catch (Exception e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            } else if ("stop".equals(type)) {
                try {
                    ObjectName name = this.getObjectName(server);
                    Registry.getRegistry(null, null).unregisterComponent(name);
                }
                catch (Exception e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    private ObjectName getObjectName(Server server) throws MalformedObjectNameException {
        String domain = server instanceof StandardServer ? ((StandardServer)server).getDomain() : ManagementFactory.getPlatformMBeanServer().getDefaultDomain();
        return ObjectName.getInstance(domain, "type", "ModClusterListener");
    }

    public Class<? extends JvmRouteFactory> getJvmRouteFactoryClass() {
        return this.getJvmRouteFactory().getClass();
    }

    public void setJvmRouteFactoryClass(final Class<? extends JvmRouteFactory> factoryClass) {
        PrivilegedAction<JvmRouteFactory> action = new PrivilegedAction<JvmRouteFactory>(){

            @Override
            public JvmRouteFactory run() {
                try {
                    return (JvmRouteFactory)factoryClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        this.setJvmRouteFactory(AccessController.doPrivileged(action));
    }

    public String getLoadMetricClass() {
        return this.loadMetricClass.getName();
    }

    public void setLoadMetricClass(final String loadMetricClass) {
        PrivilegedAction<Class<? extends LoadMetric>> action = new PrivilegedAction<Class<? extends LoadMetric>>(){

            @Override
            public Class<? extends LoadMetric> run() {
                try {
                    return ModClusterListener.class.getClassLoader().loadClass(loadMetricClass).asSubclass(LoadMetric.class);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        this.loadMetricClass = AccessController.doPrivileged(action);
    }

    public float getLoadDecayFactor() {
        return this.decayFactor;
    }

    public void setLoadDecayFactor(float decayFactor) {
        this.decayFactor = decayFactor;
    }

    public void setLoadDecayFactor(String decayFactor) {
        this.decayFactor = Float.parseFloat(decayFactor);
    }

    public int getLoadHistory() {
        return this.history;
    }

    public void setLoadHistory(int history) {
        this.history = history;
    }

    public double getLoadMetricCapacity() {
        return this.capacity;
    }

    public void setLoadMetricCapacity(String capacity) {
        this.capacity = Double.parseDouble(capacity);
    }

    public int getInitialLoad() {
        return this.initialLoad;
    }

    public void setInitialLoad(int initialLoad) {
        this.initialLoad = initialLoad;
    }

    public void addProxy(String host, int port) {
        this.service.addProxy(host, port);
    }

    public boolean disable() {
        return this.service.disable();
    }

    public boolean disableContext(String hostName, String contextPath) {
        return this.service.disableContext(hostName, contextPath);
    }

    public Map<InetSocketAddress, String> ping() {
        return this.service.ping();
    }

    public Map<InetSocketAddress, String> ping(String jvmRoute) {
        return this.service.ping(jvmRoute);
    }

    public Map<InetSocketAddress, String> ping(String scheme, String host, int port) {
        return this.service.ping(scheme, host, port);
    }

    public boolean enable() {
        return this.service.enable();
    }

    public boolean enableContext(String hostName, String contextPath) {
        return this.service.enableContext(hostName, contextPath);
    }

    public Map<InetSocketAddress, String> getProxyConfiguration() {
        return this.service.getProxyConfiguration();
    }

    public Map<InetSocketAddress, String> getProxyInfo() {
        return this.service.getProxyInfo();
    }

    public void refresh() {
        this.service.refresh();
    }

    public void removeProxy(String host, int port) {
        this.service.removeProxy(host, port);
    }

    public void reset() {
        this.service.reset();
    }

    public boolean stop(long timeout, TimeUnit unit) {
        return this.service.stop(timeout, unit);
    }

    public boolean stopContext(String host, String path, long timeout, TimeUnit unit) {
        return this.service.stopContext(host, path, timeout, unit);
    }

    public String getProxyConfigurationString() {
        String result = null;
        Map map = this.service.getProxyConfiguration();
        if (map.isEmpty()) {
            return null;
        }
        Object[] results = map.values().toArray();
        result = (String)results[0];
        return result;
    }

    public String getProxyInfoString() {
        String result = null;
        Map map = this.service.getProxyInfo();
        if (map.isEmpty()) {
            return null;
        }
        Object[] results = map.values().toArray();
        result = (String)results[0];
        return result;
    }

    public boolean stop(long timeout) {
        return this.service.stop(timeout, TimeUnit.SECONDS);
    }

    public boolean stopContext(String host, String path, long timeout) {
        return this.service.stopContext(host, path, timeout, TimeUnit.SECONDS);
    }

    @Override
    public String getConnectorAddress() {
        return this.connectorAddress;
    }

    public void setConnectorAddress(String connectorAddress) {
        this.connectorAddress = connectorAddress;
    }

    @Override
    public Integer getConnectorPort() {
        return this.connectorPort;
    }

    public void setConnectorPort(int connectorPort) {
        this.connectorPort = connectorPort;
    }

    public String getAdvertiseGroupAddress() {
        return this.getAdvertiseSocketAddress().getHostName();
    }

    public void setAdvertiseGroupAddress(String advertiseGroupAddress) {
        try {
            this.setAdvertiseSocketAddress(new InetSocketAddress(InetAddress.getByName(advertiseGroupAddress), this.getAdvertiseSocketAddress().getPort()));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public int getAdvertisePort() {
        return this.getAdvertiseSocketAddress().getPort();
    }

    public void setAdvertisePort(int advertisePort) {
        this.setAdvertiseSocketAddress(new InetSocketAddress(this.getAdvertiseSocketAddress().getAddress(), advertisePort));
    }

    public void setAdvertiseInterface(String advertiseInterface) {
        try {
            this.setAdvertiseInterface(InetAddress.getByName(advertiseInterface));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setProxyList(String addresses) {
        Collection<Object> proxyConfigurations;
        if (addresses == null || addresses.length() == 0) {
            proxyConfigurations = Collections.emptySet();
        } else {
            String[] tokens = addresses.split(CONTEXT_DELIMITER);
            proxyConfigurations = new ArrayList(tokens.length);
            for (String token : tokens) {
                try {
                    final InetSocketAddress remoteAddress = Utils.parseSocketAddress((String)token.trim(), (int)8000);
                    proxyConfigurations.add(new ProxyConfiguration(){

                        public InetSocketAddress getRemoteAddress() {
                            return remoteAddress;
                        }

                        public InetSocketAddress getLocalAddress() {
                            return null;
                        }
                    });
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        this.setProxyConfigurations(proxyConfigurations);
    }

    public String getProxyList() {
        if (this.getProxyConfiguration().isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (ProxyConfiguration proxy : this.getProxyConfigurations()) {
            InetAddress address;
            int index;
            String host;
            InetSocketAddress socketAddress = proxy.getRemoteAddress();
            if (builder.length() > 0) {
                builder.append(CONTEXT_DELIMITER);
            }
            String string = host = (index = (host = (address = socketAddress.getAddress()).toString()).indexOf("/")) > 0 ? host.substring(0, index) : host.substring(1);
            if (host.contains(HOST_CONTEXT_DELIMITER)) {
                builder.append('[').append(host).append(']');
            } else {
                builder.append(host);
            }
            builder.append(':').append(socketAddress.getPort());
        }
        return builder.toString();
    }

    public void setExcludedContexts(String contexts) {
        Map excludedContextsPerHost = Collections.emptyMap();
        if (contexts == null) {
            excludedContextsPerHost = Collections.emptyMap();
        } else {
            String trimmedContexts = contexts.trim();
            if (trimmedContexts.isEmpty()) {
                this.setExcludedContextsPerHost(Collections.emptyMap());
            } else {
                excludedContextsPerHost = new HashMap();
                for (String context : trimmedContexts.split(CONTEXT_DELIMITER)) {
                    String path;
                    String[] parts = context.trim().split(HOST_CONTEXT_DELIMITER);
                    if (parts.length > 2) {
                        throw new IllegalArgumentException(trimmedContexts + " is not a valid value for excludedContexts");
                    }
                    String host = null;
                    String trimmedContext = parts[0].trim();
                    if (parts.length == 2) {
                        host = trimmedContext;
                        trimmedContext = parts[1].trim();
                    }
                    switch (trimmedContext) {
                        case "ROOT": {
                            log.warn((Object)"Value 'ROOT' for excludedContexts is deprecated, to exclude the root context use '/' instead.");
                        }
                        case "/": {
                            path = "";
                            break;
                        }
                        default: {
                            trimmedContext = trimmedContext.startsWith("/") ? trimmedContext : "/" + trimmedContext;
                            path = trimmedContext.endsWith("/") ? trimmedContext.substring(0, trimmedContext.length() - 1) : trimmedContext;
                        }
                    }
                    HashSet<String> paths = (HashSet<String>)excludedContextsPerHost.get(host);
                    if (paths == null) {
                        paths = new HashSet<String>();
                        excludedContextsPerHost.put(host, paths);
                    }
                    paths.add(path);
                }
            }
        }
        this.setExcludedContextsPerHost(excludedContextsPerHost);
    }

    public String getExcludedContexts() {
        if (this.getExcludedContextsPerHost() == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.getExcludedContextsPerHost().entrySet()) {
            String host = (String)entry.getKey();
            for (String path : (Set)entry.getValue()) {
                if (builder.length() > 0) {
                    builder.append(CONTEXT_DELIMITER);
                }
                if (host != null) {
                    builder.append(host).append(HOST_CONTEXT_DELIMITER);
                }
                builder.append(path.isEmpty() ? ROOT_CONTEXT : path.substring(1));
            }
        }
        return builder.toString();
    }

    public void setSessionDrainingStrategy(String sessionDrainingStrategy) {
        if (sessionDrainingStrategy.equalsIgnoreCase("NEVER")) {
            this.setSessionDrainingStrategy((SessionDrainingStrategy)SessionDrainingStrategyEnum.NEVER);
        } else if (sessionDrainingStrategy.equalsIgnoreCase("ALWAYS")) {
            this.setSessionDrainingStrategy((SessionDrainingStrategy)SessionDrainingStrategyEnum.ALWAYS);
        } else {
            this.setSessionDrainingStrategy((SessionDrainingStrategy)SessionDrainingStrategyEnum.DEFAULT);
        }
    }
}

