/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.jbossweb;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.container.catalina.CatalinaContext;
import org.jboss.modcluster.container.catalina.RequestListenerValveFactory;
import org.jboss.servlet.http.HttpEvent;

public class JBossWebContext
extends CatalinaContext {
    public JBossWebContext(Context context, Host host) {
        super(context, host, new RequestListenerValveFactory(){

            public Valve createValve(ServletRequestListener listener) {
                return new RequestListenerValve(listener);
            }
        });
    }

    public boolean isStarted() {
        return this.context.isStarted() && super.isStarted();
    }

    static class RequestListenerValve
    extends ValveBase {
        private final ServletRequestListener listener;

        RequestListenerValve(ServletRequestListener listener) {
            this.listener = listener;
        }

        public void invoke(Request request, Response response) throws IOException, ServletException {
            this.event(request, response, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
            ServletRequestEvent requestEvent = new ServletRequestEvent(request.getContext().getServletContext(), (ServletRequest)request);
            this.listener.requestInitialized(requestEvent);
            Valve valve = this.getNext();
            try {
                if (event != null) {
                    valve.event(request, response, event);
                } else {
                    valve.invoke(request, response);
                }
            }
            finally {
                this.listener.requestDestroyed(requestEvent);
            }
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof RequestListenerValve)) {
                return false;
            }
            RequestListenerValve valve = (RequestListenerValve)((Object)object);
            return this.listener == valve.listener;
        }
    }
}

