/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.catalina.standalone;

import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.core.StandardServer;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;
import org.jboss.modcluster.ModClusterService;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.modcluster.Strings;
import org.jboss.modcluster.config.JvmRouteFactory;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.catalina.LifecycleListenerFactory;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.LoadBalanceFactorProviderFactory;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProvider;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.modcluster.load.metric.impl.BusyConnectorsLoadMetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModClusterListener
extends ModClusterConfig
implements LifecycleListener,
LoadBalanceFactorProviderFactory,
ModClusterServiceMBean {
    private static final Logger log = Logger.getLogger(ModClusterListener.class);
    private final ModClusterServiceMBean service;
    private final LifecycleListener listener;
    Class<? extends LoadMetric> loadMetricClass = BusyConnectorsLoadMetric.class;
    private int decayFactor = 2;
    private int history = 9;
    private double capacity = 1.0;

    public ModClusterListener() {
        ModClusterService service = new ModClusterService((ModClusterConfig)this, (LoadBalanceFactorProviderFactory)this);
        this.service = service;
        this.listener = this.loadFactory().createListener((ContainerEventHandler)service);
    }

    private LifecycleListenerFactory loadFactory() {
        PrivilegedAction<LifecycleListenerFactory> action = new PrivilegedAction<LifecycleListenerFactory>(){

            @Override
            public LifecycleListenerFactory run() {
                Iterator<LifecycleListenerFactory> i$ = ServiceLoader.load(LifecycleListenerFactory.class, LifecycleListenerFactory.class.getClassLoader()).iterator();
                if (i$.hasNext()) {
                    LifecycleListenerFactory factory = i$.next();
                    return factory;
                }
                throw new ServiceConfigurationError(String.format("No %s service provider found.", LifecycleListenerFactory.class.getName()));
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected ModClusterListener(ModClusterServiceMBean mbean, LifecycleListener listener) {
        this.service = mbean;
        this.listener = listener;
    }

    public LoadBalanceFactorProvider createLoadBalanceFactorProvider() {
        PrivilegedAction<LoadMetric> action = new PrivilegedAction<LoadMetric>(){

            @Override
            public LoadMetric run() {
                try {
                    return ModClusterListener.this.loadMetricClass.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        LoadMetric metric = AccessController.doPrivileged(action);
        metric.setCapacity(this.capacity);
        DynamicLoadBalanceFactorProvider provider = new DynamicLoadBalanceFactorProvider(Collections.singleton(metric));
        provider.setDecayFactor(this.decayFactor);
        provider.setHistory(this.history);
        return provider;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        this.listener.lifecycleEvent(event);
        Lifecycle source = event.getLifecycle();
        if (source instanceof Server) {
            Server server = (Server)source;
            String type = event.getType();
            if ("after_start".equals(type)) {
                try {
                    ObjectName name = this.getObjectName(server);
                    Registry.getRegistry(null, null).registerComponent((Object)this, name, null);
                }
                catch (Exception e) {
                    log.error((Object)Strings.ERROR_JMX_REGISTER.getString(new Object[0]), (Throwable)e);
                }
            } else if ("stop".equals(type)) {
                try {
                    ObjectName name = this.getObjectName(server);
                    Registry.getRegistry(null, null).unregisterComponent(name);
                }
                catch (Exception e) {
                    log.error((Object)Strings.ERROR_JMX_UNREGISTER.getString(new Object[0]), (Throwable)e);
                }
            }
        }
    }

    private ObjectName getObjectName(Server server) throws MalformedObjectNameException {
        String domain = server instanceof StandardServer ? ((StandardServer)server).getDomain() : ManagementFactory.getPlatformMBeanServer().getDefaultDomain();
        return ObjectName.getInstance(domain, "type", "ModClusterListener");
    }

    public Class<? extends JvmRouteFactory> getJvmRouteFactoryClass() {
        return this.getJvmRouteFactory().getClass();
    }

    public void setJvmRouteFactoryClass(final Class<? extends JvmRouteFactory> factoryClass) {
        PrivilegedAction<JvmRouteFactory> action = new PrivilegedAction<JvmRouteFactory>(){

            @Override
            public JvmRouteFactory run() {
                try {
                    return (JvmRouteFactory)factoryClass.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        this.setJvmRouteFactory(AccessController.doPrivileged(action));
    }

    public String getLoadMetricClass() {
        return this.loadMetricClass.getName();
    }

    public void setLoadMetricClass(final String loadMetricClass) {
        PrivilegedAction<Class<? extends LoadMetric>> action = new PrivilegedAction<Class<? extends LoadMetric>>(){

            @Override
            public Class<? extends LoadMetric> run() {
                try {
                    return ModClusterListener.class.getClassLoader().loadClass(loadMetricClass).asSubclass(LoadMetric.class);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        this.loadMetricClass = AccessController.doPrivileged(action);
    }

    public int getLoadDecayFactor() {
        return this.decayFactor;
    }

    public void setLoadDecayFactor(int decayFactor) {
        this.decayFactor = decayFactor;
    }

    public int getLoadHistory() {
        return this.history;
    }

    public void setLoadHistory(int history) {
        this.history = history;
    }

    public double getLoadMetricCapacity() {
        return this.capacity;
    }

    public void setLoadMetricCapacity(String capacity) {
        this.capacity = Double.parseDouble(capacity);
    }

    public void addProxy(String host, int port) {
        this.service.addProxy(host, port);
    }

    public boolean disable() {
        return this.service.disable();
    }

    public boolean disableContext(String hostName, String contextPath) {
        return this.service.disableContext(hostName, contextPath);
    }

    public Map<InetSocketAddress, String> ping() {
        return this.service.ping();
    }

    public Map<InetSocketAddress, String> ping(String jvmRoute) {
        return this.service.ping(jvmRoute);
    }

    public Map<InetSocketAddress, String> ping(String scheme, String host, int port) {
        return this.service.ping(scheme, host, port);
    }

    public boolean enable() {
        return this.service.enable();
    }

    public boolean enableContext(String hostName, String contextPath) {
        return this.service.enableContext(hostName, contextPath);
    }

    public Map<InetSocketAddress, String> getProxyConfiguration() {
        return this.service.getProxyConfiguration();
    }

    public Map<InetSocketAddress, String> getProxyInfo() {
        return this.service.getProxyInfo();
    }

    public void refresh() {
        this.service.refresh();
    }

    public void removeProxy(String host, int port) {
        this.service.removeProxy(host, port);
    }

    public void reset() {
        this.service.reset();
    }

    public boolean stop(long timeout, TimeUnit unit) {
        return this.service.stop(timeout, unit);
    }

    public boolean stopContext(String host, String path, long timeout, TimeUnit unit) {
        return this.service.stopContext(host, path, timeout, unit);
    }
}

