/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.spi.factory;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.plugins.TypeProvider;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.RelatedClassMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyMap
extends HashMap<String, ValueMetaData>
implements MetaDataVisitorNode,
TypeProvider {
    private static final long serialVersionUID = -4295725682462294630L;

    PropertyMap() {
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        visitor.initialVisit(this);
    }

    @Override
    public void describeVisit(MetaDataVisitor vistor) {
        vistor.describeVisit(this);
    }

    @Override
    public Iterator<? extends MetaDataVisitorNode> getChildren() {
        return this.values().iterator();
    }

    @Override
    public ValueMetaData put(String name, ValueMetaData value) {
        ValueInfo info = new ValueInfo(name, value);
        return super.put(name, info);
    }

    @Override
    public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        ValueInfo valueInfo = null;
        for (ValueMetaData value : this.values()) {
            ValueInfo vi = (ValueInfo)ValueInfo.class.cast(value);
            if (vi != previous) continue;
            valueInfo = vi;
            break;
        }
        if (valueInfo == null) {
            throw new IllegalArgumentException("No matching value (" + previous + ") found: " + this.values());
        }
        KernelControllerContext context = visitor.getControllerContext();
        BeanMetaData bmd = context.getBeanMetaData();
        Set<RelatedClassMetaData> related = bmd.getRelated();
        if (related == null || related.size() != 1) {
            throw new IllegalArgumentException("Invalid information for contextual injection: " + bmd);
        }
        RelatedClassMetaData beanClassMetaData = related.iterator().next();
        KernelConfigurator configurator = context.getKernel().getConfigurator();
        BeanInfo beanInfo = configurator.getBeanInfo(beanClassMetaData.getClassName(), context.getClassLoader());
        PropertyInfo pi = beanInfo.getProperty(valueInfo.name);
        TypeInfo typeInfo = pi.getType();
        if (typeInfo.isCollection() || typeInfo.isMap()) {
            throw new IllegalArgumentException("Cannot handle collection or map: " + valueInfo);
        }
        return typeInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueInfo
    extends JBossObject
    implements ValueMetaData,
    Serializable,
    TypeProvider {
        private static final long serialVersionUID = 1L;
        private String name;
        private ValueMetaData value;

        private ValueInfo(String name, ValueMetaData value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
            Stack<MetaDataVisitorNode> visitorNodeStack = visitor.visitorNodeStack();
            MetaDataVisitorNode node = visitorNodeStack.pop();
            try {
                if (node instanceof TypeProvider) {
                    TypeProvider typeProvider = (TypeProvider)((Object)node);
                    TypeInfo typeInfo = typeProvider.getType(visitor, this);
                    return typeInfo;
                }
                throw new IllegalArgumentException("Node not of TypeProvider instance, cannot determine type info.");
            }
            finally {
                visitorNodeStack.push(node);
            }
        }

        @Override
        public Object getUnderlyingValue() {
            return this.value.getUnderlyingValue();
        }

        @Override
        public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
            return this.value.getValue(info, cl);
        }

        @Override
        public void initialVisit(MetaDataVisitor vistor) {
            vistor.initialVisit(this);
        }

        @Override
        public void describeVisit(MetaDataVisitor vistor) {
            vistor.describeVisit(this);
        }

        @Override
        public Iterator<? extends MetaDataVisitorNode> getChildren() {
            return Collections.singleton(this.value).iterator();
        }

        public void toShortString(JBossStringBuilder buffer) {
            this.value.toShortString(buffer);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public String toShortString() {
            return this.value.toShortString();
        }
    }
}

