/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractCollectionMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.beans.metadata.plugins.AbstractMapMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.ValueMetaDataAware;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedBeanHandler {
    private static Logger log = Logger.getLogger(NestedBeanHandler.class);
    protected BeanMetaData root;
    protected int counter;

    public NestedBeanHandler(BeanMetaData root) {
        this.root = root;
    }

    public List<BeanMetaData> checkForNestedBeans() {
        List<BeanMetaData> nestedBeans = this.findNestedBeans();
        if (nestedBeans.isEmpty()) {
            return Collections.singletonList(this.prepareRoot(this.root));
        }
        BeanMetaData clone = (BeanMetaData)this.root.clone();
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        this.addPairs(clone, pairs);
        ArrayList<BeanMetaData> result = new ArrayList<BeanMetaData>();
        for (Pair pair : pairs) {
            MetaDataVisitorNode previous = pair.getPrevious();
            BeanMetaData bean = pair.getBean();
            if (bean.getName() == null) {
                bean.setName(this.generateName(previous));
            }
            NestedBeanHandler.replaceWithInjection(previous, bean);
            result.add(bean);
        }
        result.add(this.prepareRoot(clone));
        return result;
    }

    protected BeanMetaData prepareRoot(BeanMetaData bean) {
        return bean;
    }

    private List<BeanMetaData> findNestedBeans() {
        ArrayList<BeanMetaData> allBeans = new ArrayList<BeanMetaData>();
        this.addBeans(this.root, allBeans);
        return allBeans;
    }

    private void addBeans(MetaDataVisitorNode current, List<BeanMetaData> list) {
        Iterator<? extends MetaDataVisitorNode> children = current.getChildren();
        while (children != null && children.hasNext()) {
            MetaDataVisitorNode next = children.next();
            this.addBeans(next, list);
            if (!(next instanceof BeanMetaData)) continue;
            list.add((BeanMetaData)next);
        }
    }

    private void addPairs(MetaDataVisitorNode current, List<Pair> list) {
        Iterator<? extends MetaDataVisitorNode> children = current.getChildren();
        while (children != null && children.hasNext()) {
            MetaDataVisitorNode next = children.next();
            this.addPairs(next, list);
            if (!(next instanceof BeanMetaData)) continue;
            BeanMetaData bean = (BeanMetaData)next;
            list.add(new Pair(current, bean));
        }
    }

    protected String generateName(MetaDataVisitorNode previous) {
        String name;
        ++this.counter;
        if (previous instanceof PropertyMetaData) {
            PropertyMetaData pmd = (PropertyMetaData)previous;
            name = this.root.getName() + "$" + pmd.getName() + "#" + this.counter;
        } else {
            name = this.root.getName() + "#" + this.counter;
        }
        return name;
    }

    private static void replaceWithInjection(MetaDataVisitorNode previous, BeanMetaData bean) {
        AbstractDependencyValueMetaData injection = new AbstractDependencyValueMetaData(bean.getName());
        if (previous instanceof ValueMetaDataAware) {
            ValueMetaDataAware vmda = (ValueMetaDataAware)((Object)previous);
            vmda.setValue(injection);
        } else if (previous instanceof AbstractClassLoaderMetaData) {
            AbstractClassLoaderMetaData aclmd = (AbstractClassLoaderMetaData)previous;
            aclmd.setClassLoader(injection);
        } else if (previous instanceof AbstractListMetaData) {
            AbstractListMetaData almd = (AbstractListMetaData)previous;
            int index = almd.indexOf(bean);
            almd.remove(index);
            almd.add(index, injection);
        } else if (previous instanceof AbstractCollectionMetaData) {
            AbstractCollectionMetaData acmd = (AbstractCollectionMetaData)previous;
            acmd.remove(bean);
            acmd.add(injection);
        } else if (previous instanceof AbstractMapMetaData) {
            AbstractMapMetaData ammd = (AbstractMapMetaData)previous;
            for (Map.Entry<MetaDataVisitorNode, MetaDataVisitorNode> entry : ammd.entrySet()) {
                MetaDataVisitorNode key = entry.getKey();
                MetaDataVisitorNode value = entry.getValue();
                if (key.equals(bean)) {
                    ammd.remove(key);
                    ammd.put(injection, value);
                }
                if (!value.equals(bean)) continue;
                ammd.put(key, injection);
            }
        } else if (previous instanceof AbstractValueMetaData) {
            AbstractValueMetaData avmd = (AbstractValueMetaData)previous;
            avmd.setValue(injection);
        } else {
            log.warn((Object)("Unknown previous type to do injection replacement: " + previous));
        }
    }

    private class Pair {
        private MetaDataVisitorNode previous;
        private BeanMetaData bean;

        private Pair(MetaDataVisitorNode previous, BeanMetaData bean) {
            this.previous = previous;
            this.bean = bean;
        }

        public MetaDataVisitorNode getPrevious() {
            return this.previous;
        }

        public BeanMetaData getBean() {
            return this.bean;
        }
    }
}

