/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.metadata.test;

import junit.framework.Test;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.kernel.junit.MicrocontainerTest;
import org.jboss.test.kernel.metadata.support.TestAnnotationA;
import org.jboss.test.kernel.metadata.support.TestAnnotationB;
import org.jboss.test.kernel.metadata.support.TestAnnotationC;
import org.jboss.test.kernel.metadata.support.TestCachingMetaDataRepository;
import org.jboss.test.kernel.metadata.test.AbstractMetaDataTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingMetaDataRepositoryTestCase
extends AbstractMetaDataTest {
    public CachingMetaDataRepositoryTestCase(String name) throws Throwable {
        super(name);
    }

    public static Test suite() {
        return CachingMetaDataRepositoryTestCase.suite(CachingMetaDataRepositoryTestCase.class);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        System.setProperty(KernelMetaDataRepository.class.getName(), TestCachingMetaDataRepository.class.getName());
        System.setProperty("LRUPolicyCaching.min", "2");
        System.setProperty("LRUPolicyCaching.max", "10");
        return MicrocontainerTest.getDelegate(clazz);
    }

    protected void tearDown() throws Exception {
        System.clearProperty(KernelMetaDataRepository.class.getName());
        super.tearDown();
    }

    protected MetaData assertMetaData() {
        return this.assertMetaData("Name1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTouchCachingMetaDataRepository() throws Exception {
        TestCachingMetaDataRepository.touched = false;
        KernelDeployment deployment = this.deploy("ClassAnnotationTestCase_Override.xml");
        try {
            MetaData metaData = this.assertMetaData();
            TestAnnotationA a = this.assertAnnotation(metaData, TestAnnotationA.class);
            CachingMetaDataRepositoryTestCase.assertEquals((String)"Overridden", (String)a.value());
            TestAnnotationB b = this.assertAnnotation(metaData, TestAnnotationB.class);
            CachingMetaDataRepositoryTestCase.assertEquals((String)"NotOverridden", (String)b.value());
            this.assertNoAnnotation(metaData, TestAnnotationC.class);
            CachingMetaDataRepositoryTestCase.assertTrue((boolean)TestCachingMetaDataRepository.touched);
        }
        finally {
            this.undeploy(deployment);
        }
    }
}

