/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.deployment.xml.support.Annotation1;
import org.jboss.test.kernel.deployment.xml.support.Annotation2;
import org.jboss.test.kernel.deployment.xml.support.Annotation3;
import org.jboss.test.kernel.deployment.xml.test.AbstractMCTest;

public class InstallJaxbTestCase
extends AbstractMCTest {
    protected InstallMetaData getInstall() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean();
        List installs = bean.getInstalls();
        InstallJaxbTestCase.assertNotNull((Object)installs);
        InstallJaxbTestCase.assertEquals((int)1, (int)installs.size());
        InstallMetaData install = (InstallMetaData)installs.get(0);
        InstallJaxbTestCase.assertNotNull((Object)install);
        return install;
    }

    public void testInstallWithBean() throws Exception {
        InstallMetaData install = this.getInstall();
        InstallJaxbTestCase.assertEquals((String)"Bean", (String)install.getBean());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getState());
        InstallJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        InstallJaxbTestCase.assertNull((Object)install.getAnnotations());
        InstallJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithState() throws Exception {
        InstallMetaData install = this.getInstall();
        InstallJaxbTestCase.assertNull((Object)install.getBean());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)install.getDependentState());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getState());
        InstallJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        InstallJaxbTestCase.assertNull((Object)install.getAnnotations());
        InstallJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithWhenRequired() throws Exception {
        InstallMetaData install = this.getInstall();
        InstallJaxbTestCase.assertNull((Object)install.getBean());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)install.getState());
        InstallJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        InstallJaxbTestCase.assertNull((Object)install.getAnnotations());
        InstallJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithMethod() throws Exception {
        InstallMetaData install = this.getInstall();
        InstallJaxbTestCase.assertNull((Object)install.getBean());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getState());
        InstallJaxbTestCase.assertEquals((String)"Method", (String)install.getMethodName());
        InstallJaxbTestCase.assertNull((Object)install.getAnnotations());
        InstallJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithAnnotation() throws Exception {
        InstallMetaData install = this.getInstall();
        InstallJaxbTestCase.assertNull((Object)install.getBean());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getState());
        InstallJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        this.assertAnnotations(expected, install.getAnnotations());
        InstallJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithAnnotations() throws Exception {
        InstallMetaData install = this.getInstall();
        InstallJaxbTestCase.assertNull((Object)install.getBean());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getState());
        InstallJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        expected.add(Annotation2.class.getName());
        expected.add(Annotation3.class.getName());
        this.assertAnnotations(expected, install.getAnnotations());
        InstallJaxbTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithParameter() throws Exception {
        InstallMetaData install = this.getInstall();
        InstallJaxbTestCase.assertNull((Object)install.getBean());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getState());
        InstallJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        InstallJaxbTestCase.assertNull((Object)install.getAnnotations());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Parameter1");
        this.assertParameters(expected, install.getParameters());
    }

    public void testInstallWithParameters() throws Exception {
        InstallMetaData install = this.getInstall();
        InstallJaxbTestCase.assertNull((Object)install.getBean());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallJaxbTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getState());
        InstallJaxbTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        InstallJaxbTestCase.assertNull((Object)install.getAnnotations());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Parameter1");
        expected.add("Parameter2");
        expected.add("Parameter3");
        this.assertParameters(expected, install.getParameters());
    }

    public static Test suite() {
        return InstallJaxbTestCase.suite(InstallJaxbTestCase.class);
    }

    public InstallJaxbTestCase(String name) {
        super(name);
    }
}

