/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.support.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.logging.Logger;
import org.jboss.test.kernel.deployment.support.container.BaseContext;
import org.jboss.test.kernel.deployment.support.container.BeanContainer;
import org.jboss.test.kernel.deployment.support.container.TestInjectionMetaData;
import org.jboss.test.kernel.deployment.support.container.TestInjectionTargetMetaData;
import org.jboss.test.kernel.deployment.support.container.spi.ComponentBeanMetaDataFactory;
import org.jboss.test.kernel.deployment.support.container.spi.ComponentNameBuilder;
import org.jboss.test.kernel.deployment.support.container.spi.ComponentVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanContextFactory<T>
implements ComponentBeanMetaDataFactory,
KernelControllerContextAware {
    private static final Logger log = Logger.getLogger(BeanContextFactory.class);
    private String beanClass;
    private BeanContainer<T> container;
    private Set<TestInjectionMetaData> beanInjectionMD;
    private KernelConfigurator configurator;
    private Map<String, Set<TestInjectionMetaData>> interceptorInjectionMD = new HashMap<String, Set<TestInjectionMetaData>>();
    private List<String> interceptorNames;

    public String getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(String beanClass) {
        this.beanClass = beanClass;
    }

    public BeanContainer<T> getContainer() {
        return this.container;
    }

    public void setContainer(BeanContainer<T> container) {
        this.container = container;
    }

    public Set<TestInjectionMetaData> getBeanInjectionMD() {
        return this.beanInjectionMD;
    }

    public void setBeanInjectionMD(Set<TestInjectionMetaData> beanInjectionMD) {
        this.beanInjectionMD = beanInjectionMD;
    }

    public Map<String, Set<TestInjectionMetaData>> getInterceptorInjectionMD() {
        return this.interceptorInjectionMD;
    }

    public void setInterceptorInjectionMD(Map<String, Set<TestInjectionMetaData>> interceptorInjectionMD) {
        this.interceptorInjectionMD = interceptorInjectionMD;
    }

    public List<String> getInterceptorNames() {
        return this.interceptorNames;
    }

    public void setInterceptorNames(List<String> interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        if (context != null) {
            this.configurator = context.getKernel().getConfigurator();
        }
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.configurator = null;
    }

    @Override
    public List<BeanMetaData> getBeans(String baseName, long compID, ComponentNameBuilder nameBuilder, ComponentVisitor visitor) {
        ArrayList<BeanMetaData> beans = new ArrayList<BeanMetaData>();
        try {
            String contextName = nameBuilder.buildName(baseName, "ContextFactory", compID);
            BeanMetaDataBuilder contextBuilder = BeanMetaDataBuilder.createBuilder((String)contextName, (String)BaseContext.class.getName());
            contextBuilder.setAccessMode(BeanAccessMode.ALL);
            contextBuilder.addConstructorParameter(BeanContainer.class.getName(), this.container);
            String beanName = nameBuilder.buildName(baseName, "BeanInstance", compID);
            ValueMetaData beanInstance = contextBuilder.createInject((Object)beanName);
            contextBuilder.addPropertyMetaData("instance", beanInstance);
            if (visitor != null) {
                visitor.visit(contextBuilder, baseName, "ContextFactory", compID);
            }
            BeanMetaData beanContext = contextBuilder.getBeanMetaData();
            beans.add(beanContext);
            BeanMetaDataBuilder beanBuilder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)this.beanClass);
            beanBuilder.setAccessMode(BeanAccessMode.ALL);
            if (this.beanInjectionMD != null) {
                this.addDependencyInjection(this.beanClass, this.beanInjectionMD, beanBuilder);
            }
            beans.add(beanBuilder.getBeanMetaData());
            int count = this.interceptorNames != null ? this.interceptorNames.size() : 0;
            for (int n = 0; n < count; ++n) {
                Set<TestInjectionMetaData> injectMDs;
                String iCompName = "Interceptor:" + n;
                String iname = nameBuilder.buildName(baseName, iCompName, compID);
                String iclass = this.interceptorNames.get(n);
                BeanMetaDataBuilder ibuilder = BeanMetaDataBuilder.createBuilder((String)iname, (String)iclass);
                ibuilder.addInstallWithThis("addInterceptor", contextName);
                ibuilder.addUninstallWithThis("removeInterceptor", contextName);
                if (visitor != null) {
                    visitor.visit(contextBuilder, baseName, iCompName, compID);
                }
                if ((injectMDs = this.interceptorInjectionMD.get(iclass)) != null) {
                    this.addDependencyInjection(this.beanClass, injectMDs, beanBuilder);
                }
                BeanMetaData interceptor = ibuilder.getBeanMetaData();
                beans.add(interceptor);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to create component beans", t);
            throw new RuntimeException(t);
        }
        log.info((Object)("getBeans returning: " + beans));
        return beans;
    }

    private void addDependencyInjection(String clazzName, Set<TestInjectionMetaData> injectMDs, BeanMetaDataBuilder beanBuilder) throws Throwable {
        ClassLoader loader = this.getClass().getClassLoader();
        BeanInfo beanInfo = this.configurator.getBeanInfo(clazzName, loader);
        for (TestInjectionMetaData injectMD : injectMDs) {
            if (injectMD.getInjectionTargets() == null) continue;
            for (TestInjectionTargetMetaData targetMD : injectMD.getInjectionTargets()) {
                ValueMetaData injectValue = beanBuilder.createInject((Object)injectMD.getResolvedJndiName());
                String targetName = targetMD.getInjectionTargetName();
                PropertyInfo pinfo = beanInfo.getProperty(targetName);
                if (pinfo != null) {
                    beanBuilder.addPropertyMetaData(targetName, injectValue);
                    continue;
                }
                log.warn((Object)("No property found for injection target:" + targetName + ", on bean: " + this.beanClass));
            }
        }
    }
}

