/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.support;

import java.net.URL;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.util.Classes;

public class XMLUtil {
    private Kernel kernel;
    private AbstractKernelTest test;
    private BasicXMLDeployer deployer;
    private KernelDeployment deployment;

    public XMLUtil(Kernel kernel, AbstractKernelTest test, boolean validate) throws Throwable {
        this.kernel = kernel;
        this.test = test;
        this.deployer = new BasicXMLDeployer(kernel);
        String packageName = Classes.getPackageName(((Object)((Object)test)).getClass());
        packageName = packageName.replace('.', '/');
        String name = "/xml-test/" + packageName + '/' + test.getName() + ".xml";
        test.getLog().debug((Object)("Using " + name));
        URL url = test.getResource(name);
        if (url == null) {
            throw new RuntimeException("Resource not found: " + name);
        }
        test.getLog().debug((Object)("url=" + url));
        this.deployment = this.deployer.deploy(url);
        if (validate) {
            this.validate();
        }
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public BasicXMLDeployer getDeployer() {
        return this.deployer;
    }

    public AbstractKernelTest getTest() {
        return this.test;
    }

    public Object getBean(String name) throws Throwable {
        KernelRegistry registry = this.kernel.getRegistry();
        KernelRegistryEntry entry = registry.getEntry((Object)name);
        return entry.getTarget();
    }

    public void validate() throws Throwable {
        this.deployer.validate();
    }

    public void undeploy() {
        this.deployer.undeploy(this.deployment);
    }
}

