/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.override;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.ThisValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.kernel.annotations.support.AnnotationTester;
import org.jboss.test.kernel.annotations.support.HolderAnnotationTester;
import org.jboss.test.kernel.annotations.test.override.AbstractAnnotationOverrideTestCase;

public class ExternalAnnotationOverrideTestCase
extends AbstractAnnotationOverrideTestCase {
    private KernelController controller;

    public ExternalAnnotationOverrideTestCase(String name) throws Throwable {
        super(name);
    }

    public ExternalAnnotationOverrideTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public static Test suite() {
        return ExternalAnnotationOverrideTestCase.suite(ExternalAnnotationOverrideTestCase.class);
    }

    protected String getType() {
        return "External";
    }

    protected void addMetaData(AbstractBeanMetaData beanMetaData) {
        AbstractParameterMetaData parameter = new AbstractParameterMetaData((ValueMetaData)new ThisValueMetaData());
        ArrayList<AbstractInstallMetaData> installs = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData in = new AbstractInstallMetaData();
        in.setBean("Holder");
        in.setMethodName("addTester");
        in.setParameters(Collections.singletonList(parameter));
        installs.add(in);
        ArrayList<AbstractInstallMetaData> uninstalls = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData un = new AbstractInstallMetaData();
        un.setBean("Holder");
        un.setMethodName("removeTester");
        un.setParameters(Collections.singletonList(parameter));
        uninstalls.add(un);
        beanMetaData.setInstalls(installs);
        beanMetaData.setUninstalls(uninstalls);
    }

    public void testExternalOverride() throws Throwable {
        this.getTester(this.getTesterName(), ControllerState.START);
        AnnotationTester holder = this.getHolder();
        Object val = holder.getValue();
        this.assertInstanceOf(val, Integer.class);
        Integer count = (Integer)val;
        ExternalAnnotationOverrideTestCase.assertNotNull((Object)count);
        ExternalAnnotationOverrideTestCase.assertEquals((int)1, (int)count);
        this.doUndeploy();
        val = holder.getValue();
        this.assertInstanceOf(val, Integer.class);
        count = (Integer)val;
        ExternalAnnotationOverrideTestCase.assertNotNull((Object)count);
        ExternalAnnotationOverrideTestCase.assertEquals((int)0, (int)count);
    }

    protected void afterInstall(KernelController controller, KernelControllerContext context) throws Throwable {
        controller.install((BeanMetaData)new AbstractBeanMetaData("Holder", HolderAnnotationTester.class.getName()));
        this.controller = controller;
    }

    protected AnnotationTester getHolder() throws Throwable {
        ControllerContext context = this.controller.getInstalledContext((Object)"Holder");
        ExternalAnnotationOverrideTestCase.assertNotNull((Object)context);
        Object target = context.getTarget();
        this.assertInstanceOf(target, HolderAnnotationTester.class);
        return (AnnotationTester)target;
    }

    protected void doUndeploy() {
        this.controller.uninstall((Object)this.getTesterName());
        this.controller = null;
    }
}

