/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins.builder;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.api.model.InjectOption;
import org.jboss.beans.metadata.plugins.AbstractAnnotationMetaData;
import org.jboss.beans.metadata.plugins.AbstractArrayMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractCallbackMetaData;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractCollectionMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractFeatureMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.beans.metadata.plugins.AbstractMapMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractRelatedClassMetaData;
import org.jboss.beans.metadata.plugins.AbstractSetMetaData;
import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.DirectAnnotationMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.plugins.ThisValueMetaData;
import org.jboss.beans.metadata.plugins.builder.CreateLifecycleMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.DestroyLifecycleMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.InstallCallbackMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.InstallMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.LifecycleMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.ParameterMetaDataBuilderImpl;
import org.jboss.beans.metadata.plugins.builder.PropertyInstallCallbackMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.PropertyUninstallCallbackMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.StartLifecycleMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.StateActionBuilder;
import org.jboss.beans.metadata.plugins.builder.StopLifecycleMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.UninstallCallbackMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.UninstallMetaDataBuilder;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.RelatedClassMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.beans.metadata.spi.builder.ParameterMetaDataBuilder;
import org.jboss.dependency.spi.Cardinality;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ErrorHandlingMode;
import org.jboss.dependency.spi.graph.SearchInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeanMetaDataBuilderImpl
extends BeanMetaDataBuilder {
    private AbstractBeanMetaData beanMetaData;
    private ParameterMetaDataBuilderImpl<AbstractConstructorMetaData> constructorBuilder;
    private LifecycleMetaDataBuilder createBuilder;
    private LifecycleMetaDataBuilder startBuilder;
    private LifecycleMetaDataBuilder stopBuilder;
    private LifecycleMetaDataBuilder destroyBuilder;
    private StateActionBuilder<AbstractInstallMetaData> installBuilder;
    private StateActionBuilder<AbstractInstallMetaData> uninstallBuilder;
    private StateActionBuilder<AbstractCallbackMetaData> propIncallbackBuilder;
    private StateActionBuilder<AbstractCallbackMetaData> propUncallbackBuilder;
    private StateActionBuilder<AbstractCallbackMetaData> incallbackBuilder;
    private StateActionBuilder<AbstractCallbackMetaData> uncallbackBuilder;

    public BeanMetaDataBuilderImpl(String bean) {
        this(new AbstractBeanMetaData(bean));
    }

    public BeanMetaDataBuilderImpl(String name, String bean) {
        this(new AbstractBeanMetaData(name, bean));
    }

    public BeanMetaDataBuilderImpl(AbstractBeanMetaData beanMetaData) {
        this.beanMetaData = beanMetaData;
        this.createBuilder = this.createCreateLifecycleMetaDataBuilder(beanMetaData);
        this.startBuilder = this.createStartLifecycleMetaDataBuilder(beanMetaData);
        this.stopBuilder = this.createStopLifecycleMetaDataBuilder(beanMetaData);
        this.destroyBuilder = this.createDestroyLifecycleMetaDataBuilder(beanMetaData);
        this.installBuilder = this.createInstallMetaDataBuilder(beanMetaData);
        this.uninstallBuilder = this.createUninstallMetaDataBuilder(beanMetaData);
        this.propIncallbackBuilder = this.createPropertyInstallCallbackMetaDataBuilder(beanMetaData);
        this.propUncallbackBuilder = this.createPropertyUninstallCallbackMetaDataBuilder(beanMetaData);
        this.incallbackBuilder = this.createInstallCallbackMetaDataBuilder(beanMetaData);
        this.uncallbackBuilder = this.createUninstallCallbackMetaDataBuilder(beanMetaData);
    }

    protected LifecycleMetaDataBuilder createCreateLifecycleMetaDataBuilder(AbstractBeanMetaData beanMetaData) {
        return new CreateLifecycleMetaDataBuilder(beanMetaData);
    }

    protected LifecycleMetaDataBuilder createStartLifecycleMetaDataBuilder(AbstractBeanMetaData beanMetaData) {
        return new StartLifecycleMetaDataBuilder(beanMetaData);
    }

    protected LifecycleMetaDataBuilder createStopLifecycleMetaDataBuilder(AbstractBeanMetaData beanMetaData) {
        return new StopLifecycleMetaDataBuilder(beanMetaData);
    }

    protected LifecycleMetaDataBuilder createDestroyLifecycleMetaDataBuilder(AbstractBeanMetaData beanMetaData) {
        return new DestroyLifecycleMetaDataBuilder(beanMetaData);
    }

    protected StateActionBuilder<AbstractInstallMetaData> createInstallMetaDataBuilder(AbstractBeanMetaData beanMetaData) {
        return new InstallMetaDataBuilder(beanMetaData);
    }

    protected StateActionBuilder<AbstractInstallMetaData> createUninstallMetaDataBuilder(AbstractBeanMetaData beanMetaData) {
        return new UninstallMetaDataBuilder(beanMetaData);
    }

    private StateActionBuilder<AbstractCallbackMetaData> createPropertyInstallCallbackMetaDataBuilder(AbstractBeanMetaData beanMetaData) {
        return new PropertyInstallCallbackMetaDataBuilder(beanMetaData);
    }

    private StateActionBuilder<AbstractCallbackMetaData> createPropertyUninstallCallbackMetaDataBuilder(AbstractBeanMetaData beanMetaData) {
        return new PropertyUninstallCallbackMetaDataBuilder(beanMetaData);
    }

    private StateActionBuilder<AbstractCallbackMetaData> createInstallCallbackMetaDataBuilder(AbstractBeanMetaData beanMetaData) {
        return new InstallCallbackMetaDataBuilder(beanMetaData);
    }

    private StateActionBuilder<AbstractCallbackMetaData> createUninstallCallbackMetaDataBuilder(AbstractBeanMetaData beanMetaData) {
        return new UninstallCallbackMetaDataBuilder(beanMetaData);
    }

    @Override
    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    @Override
    public BeanMetaDataFactory getBeanMetaDataFactory() {
        return this.beanMetaData;
    }

    @Override
    public BeanMetaDataBuilder setName(String name) {
        this.beanMetaData.setName(name);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setBean(String bean) {
        this.beanMetaData.setBean(bean);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addRelatedClass(String className, Object ... enabled) {
        RelatedClassMetaData related = this.createRelated(className, enabled);
        return this.addRelatedClass(related);
    }

    @Override
    public BeanMetaDataBuilder addRelatedClass(RelatedClassMetaData related) {
        Set<RelatedClassMetaData> relatedSet = this.beanMetaData.getRelated();
        if (relatedSet == null) {
            relatedSet = new HashSet<RelatedClassMetaData>();
            this.beanMetaData.setRelated(relatedSet);
        }
        relatedSet.add(related);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setRelated(Set<RelatedClassMetaData> related) {
        this.beanMetaData.setRelated(related);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setAliases(Set<Object> aliases) {
        this.beanMetaData.setAliases(aliases);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addAlias(Object alias) {
        Set<Object> aliases = this.beanMetaData.getAliases();
        if (aliases == null) {
            aliases = new HashSet<Object>();
            this.beanMetaData.setAliases(aliases);
        }
        aliases.add(alias);
        return this;
    }

    protected AnnotationMetaData createAnnotationMetaData(String annotation) {
        return new AbstractAnnotationMetaData(annotation);
    }

    protected AnnotationMetaData createAnnotationMetaData(Annotation annotation) {
        return new DirectAnnotationMetaData(annotation);
    }

    protected AnnotationMetaData createAnnotationMetaData(String annotation, boolean replace) {
        AbstractAnnotationMetaData amd = new AbstractAnnotationMetaData(annotation);
        amd.setReplace(replace);
        return amd;
    }

    @Override
    public BeanMetaDataBuilder setAnnotations(Set<String> annotations) {
        if (annotations != null && !annotations.isEmpty()) {
            HashSet<AnnotationMetaData> amds = new HashSet<AnnotationMetaData>();
            for (String annotation : annotations) {
                AnnotationMetaData amd = this.createAnnotationMetaData(annotation);
                amds.add(amd);
            }
            this.beanMetaData.setAnnotations(amds);
        }
        return this;
    }

    protected Set<AnnotationMetaData> getAnnotations() {
        Set<AnnotationMetaData> annotations = this.beanMetaData.getAnnotations();
        if (annotations == null) {
            annotations = new HashSet<AnnotationMetaData>();
            this.beanMetaData.setAnnotations(annotations);
        }
        return annotations;
    }

    @Override
    public BeanMetaDataBuilder addAnnotation(String annotation) {
        Set<AnnotationMetaData> annotations = this.getAnnotations();
        AnnotationMetaData amd = this.createAnnotationMetaData(annotation);
        annotations.add(amd);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addAnnotation(Annotation annotation) {
        Set<AnnotationMetaData> annotations = this.getAnnotations();
        AnnotationMetaData amd = this.createAnnotationMetaData(annotation);
        annotations.add(amd);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addAnnotation(String annotation, boolean replace) {
        Set<AnnotationMetaData> annotations = this.getAnnotations();
        AnnotationMetaData amd = this.createAnnotationMetaData(annotation, replace);
        annotations.add(amd);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setMode(ControllerMode mode) {
        this.beanMetaData.setMode(mode);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setAccessMode(BeanAccessMode mode) {
        this.beanMetaData.setAccessMode(mode);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setErrorHandlingMode(ErrorHandlingMode mode) {
        this.beanMetaData.setErrorHandlingMode(mode);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setAutowireType(AutowireType type) {
        this.beanMetaData.setAutowireType(type);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setAutowireCandidate(boolean candidate) {
        this.beanMetaData.setAutowireCandidate(candidate);
        return null;
    }

    protected ClassLoaderMetaData createClassLoaderMetaData(ValueMetaData classLoader) {
        return new AbstractClassLoaderMetaData(classLoader);
    }

    @Override
    public BeanMetaDataBuilder setClassLoader(ValueMetaData classLoader) {
        ClassLoaderMetaData clvmd = this.createClassLoaderMetaData(classLoader);
        this.beanMetaData.setClassLoader(clvmd);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setClassLoader(ClassLoaderMetaData classLoader) {
        this.beanMetaData.setClassLoader(classLoader);
        return this;
    }

    protected AbstractConstructorMetaData createAbstractConstructorMetaData() {
        return new AbstractConstructorMetaData();
    }

    protected void checkConstructorBuilder() {
        AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)this.beanMetaData.getConstructor();
        if (constructor == null) {
            constructor = this.createAbstractConstructorMetaData();
            this.beanMetaData.setConstructor(constructor);
            this.constructorBuilder = new ParameterMetaDataBuilderImpl<AbstractConstructorMetaData>(constructor);
        }
    }

    @Override
    public BeanMetaDataBuilder setFactory(ValueMetaData factory) {
        this.checkConstructorBuilder();
        AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)this.beanMetaData.getConstructor();
        constructor.setFactory(factory);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setFactoryClass(String factoryClass) {
        this.checkConstructorBuilder();
        AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)this.beanMetaData.getConstructor();
        constructor.setFactoryClass(factoryClass);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setFactoryMethod(String factoryMethod) {
        this.checkConstructorBuilder();
        AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)this.beanMetaData.getConstructor();
        constructor.setFactoryMethod(factoryMethod);
        return this;
    }

    @Override
    public BeanMetaDataBuilder setConstructorValue(ValueMetaData value) {
        this.checkConstructorBuilder();
        AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)this.beanMetaData.getConstructor();
        constructor.setValue(value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addConstructorParameter(String type, Object value) {
        this.checkConstructorBuilder();
        this.constructorBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addConstructorParameter(String type, String value) {
        this.checkConstructorBuilder();
        this.constructorBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addConstructorParameter(String type, ValueMetaData value) {
        this.checkConstructorBuilder();
        this.constructorBuilder.addParameterMetaData(type, value);
        return this;
    }

    protected PropertyMetaData createPropertyMetaData(String name, Object value) {
        return new AbstractPropertyMetaData(name, value);
    }

    @Override
    public BeanMetaDataBuilder addPropertyMetaData(String name, Object value) {
        Set<PropertyMetaData> properties = this.getProperties();
        this.removeProperty(properties, name);
        properties.add(this.createPropertyMetaData(name, value));
        return this;
    }

    protected PropertyMetaData createPropertyMetaData(String name, String value) {
        return new AbstractPropertyMetaData(name, value);
    }

    @Override
    public BeanMetaDataBuilder addPropertyMetaData(String name, String value) {
        Set<PropertyMetaData> properties = this.getProperties();
        this.removeProperty(properties, name);
        properties.add(this.createPropertyMetaData(name, value));
        return this;
    }

    protected PropertyMetaData createPropertyMetaData(String name, ValueMetaData value) {
        return new AbstractPropertyMetaData(name, value);
    }

    @Override
    public BeanMetaDataBuilder addPropertyMetaData(String name, ValueMetaData value) {
        Set<PropertyMetaData> properties = this.getProperties();
        this.removeProperty(properties, name);
        properties.add(this.createPropertyMetaData(name, value));
        return this;
    }

    @Override
    public BeanMetaDataBuilder addPropertyMetaData(String name, Collection<ValueMetaData> value) {
        Set<PropertyMetaData> properties = this.getProperties();
        this.removeProperty(properties, name);
        if (value instanceof ValueMetaData) {
            properties.add(this.createPropertyMetaData(name, (ValueMetaData)((Object)value)));
        } else {
            properties.add(this.createPropertyMetaData(name, value));
        }
        return this;
    }

    @Override
    public BeanMetaDataBuilder addPropertyMetaData(String name, Map<ValueMetaData, ValueMetaData> value) {
        Set<PropertyMetaData> properties = this.getProperties();
        this.removeProperty(properties, name);
        if (value instanceof ValueMetaData) {
            properties.add(this.createPropertyMetaData(name, (ValueMetaData)((Object)value)));
        } else {
            properties.add(this.createPropertyMetaData(name, value));
        }
        return this;
    }

    @Override
    public BeanMetaDataBuilder addPropertyAnnotation(String name, String annotation) {
        AnnotationMetaData amd = this.createAnnotationMetaData(annotation);
        return this.addPropertyAnnotation(name, amd);
    }

    @Override
    public BeanMetaDataBuilder addPropertyAnnotation(String name, String annotation, boolean replace) {
        AnnotationMetaData amd = this.createAnnotationMetaData(annotation, replace);
        return this.addPropertyAnnotation(name, amd);
    }

    @Override
    public BeanMetaDataBuilder addPropertyAnnotation(String name, Annotation annotation) {
        AnnotationMetaData amd = this.createAnnotationMetaData(annotation);
        return this.addPropertyAnnotation(name, amd);
    }

    protected BeanMetaDataBuilder addPropertyAnnotation(String name, AnnotationMetaData amd) {
        PropertyMetaData pmd = this.beanMetaData.getProperty(name);
        Set<AnnotationMetaData> annotations = pmd.getAnnotations();
        if (annotations == null) {
            if (!(pmd instanceof AbstractFeatureMetaData)) {
                throw new IllegalArgumentException("PropertyMetaData is not AbstractFeatureMetaData instance: " + pmd);
            }
            annotations = new HashSet<AnnotationMetaData>();
            AbstractFeatureMetaData afmd = (AbstractFeatureMetaData)AbstractFeatureMetaData.class.cast(pmd);
            afmd.setAnnotations(annotations);
        }
        annotations.add(amd);
        return this;
    }

    private Set<PropertyMetaData> removeProperty(Set<PropertyMetaData> properties, String name) {
        Iterator<PropertyMetaData> it = properties.iterator();
        while (it.hasNext()) {
            PropertyMetaData property = it.next();
            if (!name.equals(property.getName())) continue;
            it.remove();
        }
        return properties;
    }

    private Set<PropertyMetaData> getProperties() {
        Set<PropertyMetaData> properties = this.beanMetaData.getProperties();
        if (properties == null) {
            properties = new HashSet<PropertyMetaData>();
            this.beanMetaData.setProperties(properties);
        }
        return properties;
    }

    @Override
    public BeanMetaDataBuilder ignoreCreate() {
        this.createBuilder.setIgnored();
        return this;
    }

    @Override
    public BeanMetaDataBuilder setCreate(String methodName) {
        this.createBuilder.createStateActionMetaData(methodName);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addCreateParameter(String type, Object value) {
        this.createBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addCreateParameter(String type, String value) {
        this.createBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addCreateParameter(String type, ValueMetaData value) {
        this.createBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder ignoreStart() {
        this.startBuilder.setIgnored();
        return this;
    }

    @Override
    public BeanMetaDataBuilder setStart(String methodName) {
        this.startBuilder.createStateActionMetaData(methodName);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addStartParameter(String type, Object value) {
        this.startBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addStartParameter(String type, String value) {
        this.startBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addStartParameter(String type, ValueMetaData value) {
        this.startBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder ignoreStop() {
        this.stopBuilder.setIgnored();
        return this;
    }

    @Override
    public BeanMetaDataBuilder setStop(String methodName) {
        this.stopBuilder.createStateActionMetaData(methodName);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addStopParameter(String type, Object value) {
        this.stopBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addStopParameter(String type, String value) {
        this.stopBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addStopParameter(String type, ValueMetaData value) {
        this.stopBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder ignoreDestroy() {
        this.destroyBuilder.setIgnored();
        return this;
    }

    @Override
    public BeanMetaDataBuilder setDestroy(String methodName) {
        this.destroyBuilder.createStateActionMetaData(methodName);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addDestroyParameter(String type, Object value) {
        this.destroyBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addDestroyParameter(String type, String value) {
        this.destroyBuilder.addParameterMetaData(type, value);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addDestroyParameter(String type, ValueMetaData value) {
        this.destroyBuilder.addParameterMetaData(type, value);
        return this;
    }

    protected SupplyMetaData createSupplyMetaData(Object supply, String type) {
        AbstractSupplyMetaData asmd = new AbstractSupplyMetaData(supply);
        if (type != null) {
            asmd.setType(type);
        }
        return asmd;
    }

    @Override
    public BeanMetaDataBuilder addSupply(Object supply, String type) {
        Set<SupplyMetaData> supplies = this.beanMetaData.getSupplies();
        if (supplies == null) {
            supplies = new HashSet<SupplyMetaData>();
            this.beanMetaData.setSupplies(supplies);
        }
        supplies.add(this.createSupplyMetaData(supply, type));
        return this;
    }

    protected DemandMetaData createDemandMetaData(Object demand, ControllerState whenRequired, ControllerState targetState, String transformer) {
        AbstractDemandMetaData admd = new AbstractDemandMetaData(demand);
        if (whenRequired != null) {
            admd.setWhenRequired(whenRequired);
        }
        if (targetState != null) {
            admd.setTargetState(targetState);
        }
        if (transformer != null) {
            admd.setTransformer(transformer);
        }
        return admd;
    }

    @Override
    public BeanMetaDataBuilder addDemand(Object demand, ControllerState whenRequired, ControllerState targetState, String transformer) {
        Set<DemandMetaData> demands = this.beanMetaData.getDemands();
        if (demands == null) {
            demands = new HashSet<DemandMetaData>();
            this.beanMetaData.setDemands(demands);
        }
        demands.add(this.createDemandMetaData(demand, whenRequired, targetState, transformer));
        return this;
    }

    protected DependencyMetaData createDependencyMetaData(Object dependency) {
        return new AbstractDependencyMetaData(dependency);
    }

    @Override
    public BeanMetaDataBuilder addDependency(Object dependency) {
        Set<DependencyMetaData> dependencies = this.beanMetaData.getDepends();
        if (dependencies == null) {
            dependencies = new HashSet<DependencyMetaData>();
            this.beanMetaData.setDepends(dependencies);
        }
        dependencies.add(this.createDependencyMetaData(dependency));
        return this;
    }

    @Override
    public ParameterMetaDataBuilder addInstallWithParameters(String methodName, String bean, ControllerState state, ControllerState whenRequired) {
        AbstractInstallMetaData install = this.installBuilder.createStateActionMetaData(methodName);
        install.setBean(bean);
        if (state != null) {
            install.setDependentState(state);
        }
        if (whenRequired != null) {
            install.setState(whenRequired);
        }
        return new ParameterMetaDataBuilderImpl<AbstractInstallMetaData>(install);
    }

    @Override
    public ParameterMetaDataBuilder addUninstallWithParameters(String methodName, String bean, ControllerState state, ControllerState whenRequired) {
        AbstractInstallMetaData uninstall = this.uninstallBuilder.createStateActionMetaData(methodName);
        uninstall.setBean(bean);
        if (state != null) {
            uninstall.setDependentState(state);
        }
        if (whenRequired != null) {
            uninstall.setState(whenRequired);
        }
        return new ParameterMetaDataBuilderImpl<AbstractInstallMetaData>(uninstall);
    }

    @Override
    public BeanMetaDataBuilder addPropertyInstallCallback(String property, String signature, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality) {
        AbstractCallbackMetaData callback = this.propIncallbackBuilder.createStateActionMetaData(property);
        callback.setSignature(signature);
        callback.setState(whenRequired);
        if (dependentState != null) {
            callback.setDependentState(dependentState);
        }
        callback.setCardinality(cardinality);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addPropertyUninstallCallback(String property, String signature, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality) {
        AbstractCallbackMetaData callback = this.propUncallbackBuilder.createStateActionMetaData(property);
        callback.setSignature(signature);
        callback.setState(whenRequired);
        if (dependentState != null) {
            callback.setDependentState(dependentState);
        }
        callback.setCardinality(cardinality);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addMethodInstallCallback(String method, String signature, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality) {
        AbstractCallbackMetaData callback = this.incallbackBuilder.createStateActionMetaData(method);
        callback.setSignature(signature);
        callback.setState(whenRequired);
        if (dependentState != null) {
            callback.setDependentState(dependentState);
        }
        callback.setCardinality(cardinality);
        return this;
    }

    @Override
    public BeanMetaDataBuilder addMethodUninstallCallback(String method, String signature, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality) {
        AbstractCallbackMetaData callback = this.uncallbackBuilder.createStateActionMetaData(method);
        callback.setSignature(signature);
        callback.setState(whenRequired);
        if (dependentState != null) {
            callback.setDependentState(dependentState);
        }
        callback.setCardinality(cardinality);
        return this;
    }

    @Override
    public RelatedClassMetaData createRelated(String className, Object ... enabled) {
        AbstractRelatedClassMetaData related = new AbstractRelatedClassMetaData();
        related.setClassName(className);
        if (enabled != null && enabled.length > 0) {
            related.setEnabled(new HashSet<Object>(Arrays.asList(enabled)));
        }
        return related;
    }

    @Override
    public ValueMetaData createNull() {
        return new AbstractValueMetaData();
    }

    @Override
    public ValueMetaData createThis() {
        return new ThisValueMetaData();
    }

    @Override
    public ValueMetaData createValue(Object value) {
        return new AbstractValueMetaData(value);
    }

    @Override
    public ValueMetaData createValueFactory(Object bean, String method, ParameterMetaData ... parameters) {
        AbstractValueFactoryMetaData value = new AbstractValueFactoryMetaData(bean, method);
        value.setParameters(Arrays.asList(parameters));
        return value;
    }

    @Override
    public ParameterMetaData createParameter(ValueMetaData value, String type, int index) {
        AbstractParameterMetaData parameter = new AbstractParameterMetaData(type, value);
        parameter.setIndex(index);
        return parameter;
    }

    @Override
    public ValueMetaData createString(String type, String value) {
        StringValueMetaData result = new StringValueMetaData(value);
        result.setType(type);
        return result;
    }

    protected AbstractDependencyValueMetaData createAbstractDependencyValueMetaData(Object bean, String property) {
        return new AbstractDependencyValueMetaData(bean, property);
    }

    @Override
    public ValueMetaData createInject(Object bean, String property, ControllerState whenRequired, ControllerState dependentState, SearchInfo search) {
        AbstractDependencyValueMetaData result = this.createAbstractDependencyValueMetaData(bean, property);
        if (whenRequired != null) {
            result.setWhenRequiredState(whenRequired);
        }
        if (dependentState != null) {
            result.setDependentState(dependentState);
        }
        if (search != null) {
            result.setSearch(search);
        }
        return result;
    }

    protected AbstractInjectionValueMetaData createAbstractInjectionValueMetaData() {
        return new AbstractInjectionValueMetaData();
    }

    protected AbstractInjectionValueMetaData createAbstractInjectionValueMetaData(Object name) {
        return new AbstractInjectionValueMetaData(name);
    }

    @Override
    public ValueMetaData createContextualInject(ControllerState whenRequired, ControllerState dependentState, AutowireType autowire, InjectOption option, SearchInfo search) {
        AbstractInjectionValueMetaData result = this.createAbstractInjectionValueMetaData();
        if (whenRequired != null) {
            result.setWhenRequiredState(whenRequired);
        }
        if (dependentState != null) {
            result.setDependentState(dependentState);
        }
        if (autowire != null) {
            result.setInjectionType(autowire);
        }
        if (option != null) {
            result.setInjectionOption(option);
        }
        if (search != null) {
            result.setSearch(search);
        }
        return result;
    }

    @Override
    public ValueMetaData createFromContextInject(FromContext fromContext, Object contextName, ControllerState dependentState, SearchInfo search) {
        AbstractInjectionValueMetaData result = this.createAbstractInjectionValueMetaData(contextName);
        result.setFromContext(fromContext);
        if (dependentState != null) {
            result.setDependentState(dependentState);
        }
        if (search != null) {
            result.setSearch(search);
        }
        return result;
    }

    @Override
    public Collection<ValueMetaData> createCollection(String collectionType, String elementType) {
        AbstractCollectionMetaData collection = new AbstractCollectionMetaData();
        if (collectionType != null) {
            collection.setType(collectionType);
        }
        if (elementType != null) {
            collection.setElementType(elementType);
        }
        return collection;
    }

    @Override
    public List<ValueMetaData> createList(String listType, String elementType) {
        AbstractListMetaData collection = new AbstractListMetaData();
        if (listType != null) {
            collection.setType(listType);
        }
        if (elementType != null) {
            collection.setElementType(elementType);
        }
        return collection;
    }

    @Override
    public Set<ValueMetaData> createSet(String setType, String elementType) {
        AbstractSetMetaData collection = new AbstractSetMetaData();
        if (setType != null) {
            collection.setType(setType);
        }
        if (elementType != null) {
            collection.setElementType(elementType);
        }
        return collection;
    }

    @Override
    public List<ValueMetaData> createArray(String arrayType, String elementType) {
        AbstractArrayMetaData collection = new AbstractArrayMetaData();
        if (arrayType != null) {
            collection.setType(arrayType);
        }
        if (elementType != null) {
            collection.setElementType(elementType);
        }
        return collection;
    }

    @Override
    public Map<ValueMetaData, ValueMetaData> createMap(String mapType, String keyType, String valueType) {
        AbstractMapMetaData map = new AbstractMapMetaData();
        if (mapType != null) {
            map.setType(mapType);
        }
        if (keyType != null) {
            map.setKeyType(keyType);
        }
        if (valueType != null) {
            map.setValue(valueType);
        }
        return map;
    }
}

