/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.event.test;

import java.util.ArrayList;
import junit.framework.Test;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventFilter;
import org.jboss.kernel.spi.event.KernelEventListener;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntryNotFoundException;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.test.kernel.event.support.EventTestCaseSupport;
import org.jboss.test.kernel.event.support.TestEmitter;
import org.jboss.test.kernel.event.support.TestFilter;
import org.jboss.test.kernel.event.support.TestListener;

public class EventManagerTestCase
extends AbstractKernelTest {
    public static Test suite() {
        return EventManagerTestCase.suite(EventManagerTestCase.class);
    }

    public EventManagerTestCase(String name) {
        super(name);
    }

    public void testSimpleFireEvent() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelRegistry registry = kernel.getRegistry();
        KernelEventManager eventManager = kernel.getEventManager();
        TestEmitter emitter = new TestEmitter();
        KernelRegistryEntry entry = EventManagerTestCase.makeEntry((Object)emitter);
        registry.registerEntry((Object)"Emitter", entry);
        TestListener listener = new TestListener();
        eventManager.registerListener((Object)"Emitter", (KernelEventListener)listener, null, null);
        emitter.testFire("testtype", null);
        ArrayList<KernelEvent> expected = new ArrayList<KernelEvent>();
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 0L, null, null));
        EventTestCaseSupport.check(listener, expected);
    }

    public void testDoubleFireEvent() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelRegistry registry = kernel.getRegistry();
        KernelEventManager eventManager = kernel.getEventManager();
        TestEmitter emitter = new TestEmitter();
        KernelRegistryEntry entry = EventManagerTestCase.makeEntry((Object)emitter);
        registry.registerEntry((Object)"Emitter", entry);
        TestListener listener = new TestListener();
        eventManager.registerListener((Object)"Emitter", (KernelEventListener)listener, null, null);
        emitter.testFire("testtype", null);
        emitter.testFire("testtype", null);
        ArrayList<KernelEvent> expected = new ArrayList<KernelEvent>();
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 0L, null, null));
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 1L, null, null));
        EventTestCaseSupport.check(listener, expected);
    }

    public void testFilter() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelRegistry registry = kernel.getRegistry();
        KernelEventManager eventManager = kernel.getEventManager();
        TestEmitter emitter = new TestEmitter();
        KernelRegistryEntry entry = EventManagerTestCase.makeEntry((Object)emitter);
        registry.registerEntry((Object)"Emitter", entry);
        TestListener listener = new TestListener();
        TestFilter filter = new TestFilter();
        eventManager.registerListener((Object)"Emitter", (KernelEventListener)listener, (KernelEventFilter)filter, null);
        emitter.testFire("testtype", null);
        filter.fireEvent = false;
        emitter.testFire("testtype", null);
        ArrayList<KernelEvent> expected = new ArrayList<KernelEvent>();
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 0L, null, null));
        EventTestCaseSupport.check(listener, expected);
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 1L, null, null));
        EventTestCaseSupport.check(filter, expected);
    }

    public void testHandback() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelRegistry registry = kernel.getRegistry();
        KernelEventManager eventManager = kernel.getEventManager();
        TestEmitter emitter = new TestEmitter();
        KernelRegistryEntry entry = EventManagerTestCase.makeEntry((Object)emitter);
        registry.registerEntry((Object)"Emitter", entry);
        TestListener listener = new TestListener();
        TestFilter filter = new TestFilter();
        Object handback = new Object();
        eventManager.registerListener((Object)"Emitter", (KernelEventListener)listener, (KernelEventFilter)filter, handback);
        emitter.testFire("testtype", null);
        ArrayList<KernelEvent> expected = new ArrayList<KernelEvent>();
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 0L, null, handback));
        EventTestCaseSupport.check(listener, expected);
        EventTestCaseSupport.check(filter, expected);
    }

    public void testDoesNotExist() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelEventManager eventManager = kernel.getEventManager();
        TestListener listener = new TestListener();
        try {
            eventManager.registerListener((Object)"doesnotexist", (KernelEventListener)listener, null, null);
            EventManagerTestCase.fail((String)"Should not be here");
        }
        catch (KernelRegistryEntryNotFoundException expected) {
            // empty catch block
        }
    }

    public void testNotAnEmitter() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelRegistry registry = kernel.getRegistry();
        KernelEventManager eventManager = kernel.getEventManager();
        Object notAnEmitter = new Object();
        KernelRegistryEntry entry = EventManagerTestCase.makeEntry(notAnEmitter);
        registry.registerEntry((Object)"notanemitter", entry);
        TestListener listener = new TestListener();
        try {
            eventManager.registerListener((Object)"notanemitter", (KernelEventListener)listener, null, null);
            EventManagerTestCase.fail((String)"Should not be here");
        }
        catch (ClassCastException expected) {
            // empty catch block
        }
    }

    protected void configureLoggingAfterBootstrap() {
    }
}

