/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.NamedAliasMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.test.kernel.deployment.xml.support.Annotation1;
import org.jboss.test.kernel.deployment.xml.support.AnnotationWithAttributes;
import org.jboss.test.kernel.deployment.xml.support.TestBeanMetaDataFactory;
import org.jboss.test.kernel.deployment.xml.support.TestBeanMetaDataFactory1;
import org.jboss.test.kernel.deployment.xml.support.TestBeanMetaDataFactory2;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class DeploymentTestCase
extends AbstractXMLTest {
    public void testDeployment() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("Deployment.xml");
        DeploymentTestCase.assertNull((Object)deployment.getName());
        DeploymentTestCase.assertNull((Object)deployment.getClassLoader());
        DeploymentTestCase.assertNull((Object)deployment.getBeans());
    }

    public void testDeploymentWithName() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithName.xml");
        DeploymentTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentTestCase.assertNull((Object)deployment.getClassLoader());
        DeploymentTestCase.assertNull((Object)deployment.getBeans());
    }

    public void testDeploymentWithClassLoader() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithClassLoader.xml");
        DeploymentTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentTestCase.assertNotNull((Object)deployment.getClassLoader());
        DeploymentTestCase.assertNull((Object)deployment.getBeans());
    }

    public void testDeploymentWithBean() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithBean.xml");
        DeploymentTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentTestCase.assertNull((Object)deployment.getClassLoader());
        List beans = deployment.getBeans();
        DeploymentTestCase.assertNotNull((Object)beans);
        DeploymentTestCase.assertEquals((int)1, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean1", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
    }

    public void testDeploymentWithMultipleBeans() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithMultipleBeans.xml");
        DeploymentTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentTestCase.assertNull((Object)deployment.getClassLoader());
        List beans = deployment.getBeans();
        DeploymentTestCase.assertNotNull((Object)beans);
        DeploymentTestCase.assertEquals((int)3, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean1", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(1);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean2", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(2);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean3", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
    }

    public void testDeploymentWithBeanFactory() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithBeanFactory.xml");
        DeploymentTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentTestCase.assertNull((Object)deployment.getClassLoader());
        List beans = deployment.getBeans();
        DeploymentTestCase.assertNotNull((Object)beans);
        DeploymentTestCase.assertEquals((int)1, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean1", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
    }

    public void testDeploymentWithMultipleBeanFactorys() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithMultipleBeanFactorys.xml");
        DeploymentTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentTestCase.assertNull((Object)deployment.getClassLoader());
        List beans = deployment.getBeans();
        DeploymentTestCase.assertNotNull((Object)beans);
        DeploymentTestCase.assertEquals((int)3, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean1", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(1);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean2", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(2);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean3", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
    }

    public void testDeploymentWithMultipleBeanMetaDataFactorys() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithMultipleBeanMetaDataFactorys.xml");
        DeploymentTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentTestCase.assertNull((Object)deployment.getClassLoader());
        List beanFactories = deployment.getBeanFactories();
        DeploymentTestCase.assertNotNull((Object)beanFactories);
        DeploymentTestCase.assertEquals((int)3, (int)beanFactories.size());
        BeanMetaDataFactory factory = (BeanMetaDataFactory)beanFactories.get(0);
        DeploymentTestCase.assertEquals((String)TestBeanMetaDataFactory.class.getName(), (String)factory.getClass().getName());
        factory = (BeanMetaDataFactory)beanFactories.get(1);
        DeploymentTestCase.assertEquals((String)TestBeanMetaDataFactory1.class.getName(), (String)factory.getClass().getName());
        factory = (BeanMetaDataFactory)beanFactories.get(2);
        DeploymentTestCase.assertEquals((String)TestBeanMetaDataFactory2.class.getName(), (String)factory.getClass().getName());
        List beans = deployment.getBeans();
        DeploymentTestCase.assertNotNull((Object)beans);
        DeploymentTestCase.assertEquals((int)6, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean1", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(1);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean2", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(2);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean3", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(3);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean4", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(4);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean5", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(5);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean6", (String)bean.getBean());
    }

    public void testDeploymentWithBeanMetaDataFactory() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithBeanMetaDataFactory.xml");
        DeploymentTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentTestCase.assertNull((Object)deployment.getClassLoader());
        List beanFactories = deployment.getBeanFactories();
        DeploymentTestCase.assertNotNull((Object)beanFactories);
        DeploymentTestCase.assertEquals((int)1, (int)beanFactories.size());
        BeanMetaDataFactory factory = (BeanMetaDataFactory)beanFactories.get(0);
        DeploymentTestCase.assertEquals((String)TestBeanMetaDataFactory.class.getName(), (String)factory.getClass().getName());
        List beans = deployment.getBeans();
        DeploymentTestCase.assertNotNull((Object)beans);
        DeploymentTestCase.assertEquals((int)2, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean1", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(1);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean2", (String)bean.getBean());
    }

    public void testDeploymentWithMixed() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithMixed.xml");
        DeploymentTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentTestCase.assertNull((Object)deployment.getClassLoader());
        List beans = deployment.getBeans();
        DeploymentTestCase.assertNotNull((Object)beans);
        DeploymentTestCase.assertEquals((int)8, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean1", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(1);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean2", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(2);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean1", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(3);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean2", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(4);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean3", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(5);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean4", (String)bean.getName());
        DeploymentTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(6);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean3", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(7);
        DeploymentTestCase.assertNotNull((Object)bean);
        DeploymentTestCase.assertEquals((String)"Bean4", (String)bean.getBean());
    }

    public void testDeploymentWithLifecycle() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithLifecycle.xml");
        LifecycleMetaData create = deployment.getCreate();
        DeploymentTestCase.assertNotNull((Object)create);
        LifecycleMetaData start = deployment.getStart();
        DeploymentTestCase.assertNotNull((Object)start);
        LifecycleMetaData stop = deployment.getStop();
        DeploymentTestCase.assertNotNull((Object)stop);
        LifecycleMetaData destroy = deployment.getDestroy();
        DeploymentTestCase.assertNotNull((Object)destroy);
        List beans = deployment.getBeans();
        DeploymentTestCase.assertNotNull((Object)beans);
        DeploymentTestCase.assertEquals((int)1, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.iterator().next();
        DeploymentTestCase.assertEquals((Object)create, (Object)bean.getCreate());
        DeploymentTestCase.assertEquals((Object)start, (Object)bean.getStart());
        DeploymentTestCase.assertEquals((Object)stop, (Object)bean.getStop());
        DeploymentTestCase.assertEquals((Object)destroy, (Object)bean.getDestroy());
    }

    public void testDeploymentWithMode() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithMode.xml");
        ControllerMode mode = deployment.getMode();
        DeploymentTestCase.assertNotNull((Object)mode);
        DeploymentTestCase.assertEquals((Object)ControllerMode.ON_DEMAND, (Object)mode);
        List beans = deployment.getBeans();
        DeploymentTestCase.assertNotNull((Object)beans);
        DeploymentTestCase.assertEquals((int)1, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.iterator().next();
        DeploymentTestCase.assertEquals((Object)mode, (Object)bean.getMode());
    }

    public void testDeploymentWithAlias() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithAlias.xml");
        Set aliases = deployment.getAliases();
        DeploymentTestCase.assertNotNull((Object)aliases);
        DeploymentTestCase.assertEquals((int)2, (int)aliases.size());
        TreeSet<String> stringAlias = new TreeSet<String>();
        for (NamedAliasMetaData namd : aliases) {
            DeploymentTestCase.assertNotNull((Object)namd);
            Object ann = namd.getAliasValue();
            DeploymentTestCase.assertNotNull((Object)ann);
            stringAlias.add(ann.toString());
        }
        Iterator iter = stringAlias.iterator();
        String first = (String)iter.next();
        DeploymentTestCase.assertEquals((String)"FirstAlias", (String)first);
        String second = (String)iter.next();
        DeploymentTestCase.assertEquals((String)"SecondAlias", (String)second);
    }

    public void testDeploymentWithAnnotations() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment("DeploymentWithAnnotations.xml");
        Set annotations = deployment.getAnnotations();
        DeploymentTestCase.assertNotNull((Object)annotations);
        DeploymentTestCase.assertEquals((int)2, (int)annotations.size());
        ArrayList annotationList = new ArrayList(annotations);
        Annotation ann = ((AnnotationMetaData)annotationList.get(0)).getAnnotationInstance();
        DeploymentTestCase.assertNotNull((Object)ann);
        DeploymentTestCase.assertEquals((String)Annotation1.class.getName(), (String)ann.annotationType().getName());
        ann = ((AnnotationMetaData)annotationList.get(1)).getAnnotationInstance();
        DeploymentTestCase.assertNotNull((Object)ann);
        DeploymentTestCase.assertEquals((String)AnnotationWithAttributes.class.getName(), (String)ann.annotationType().getName());
        DeploymentTestCase.assertTrue((boolean)(ann instanceof AnnotationWithAttributes));
        AnnotationWithAttributes ann1 = (AnnotationWithAttributes)ann;
        DeploymentTestCase.assertNotNull(ann1.clazz());
        DeploymentTestCase.assertEquals(Integer.class, ann1.clazz());
        DeploymentTestCase.assertNotNull((Object)ann1.integer());
        DeploymentTestCase.assertEquals((int)100, (int)ann1.integer());
        DeploymentTestCase.assertNotNull((Object)ann1.str());
        DeploymentTestCase.assertEquals((String)"Annotations are nice", (String)ann1.str());
    }

    public static Test suite() {
        return DeploymentTestCase.suite(DeploymentTestCase.class);
    }

    public DeploymentTestCase(String name) {
        super(name);
    }
}

