/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.ArrayList;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.AliasMetaData;
import org.jboss.beans.metadata.spi.NamedAliasMetaData;
import org.jboss.beans.metadata.spi.factory.GenericBeanFactoryMetaData;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class AliasTestCase
extends AbstractXMLTest {
    public AliasTestCase(String name) {
        super(name);
    }

    protected AliasTestCase(String name, boolean useClone) {
        super(name, useClone);
    }

    public static Test suite() {
        return AliasTestCase.suite(AliasTestCase.class);
    }

    protected Object getAlias(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        Set aliases = bean.getAliasMetaData();
        AliasTestCase.assertNotNull((Object)aliases);
        AliasTestCase.assertEquals((int)1, (int)aliases.size());
        AliasMetaData alias = (AliasMetaData)aliases.iterator().next();
        AliasTestCase.assertNotNull((Object)alias);
        Object theAlias = alias.getAliasValue();
        AliasTestCase.assertNotNull((Object)theAlias);
        return theAlias;
    }

    public void testAlias() throws Exception {
        Object alias = this.getAlias("Alias.xml");
        AliasTestCase.assertEquals((Object)"SimpleAlias", (Object)alias);
    }

    public void testAliasWithjavaBean() throws Exception {
        Object alias = this.getAlias("AliasWithJavaBean.xml");
        this.assertInstanceOf(alias, ArrayList.class);
    }

    public void testMultipleAliases() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean("MultipleAlias.xml");
        Set aliases = bean.getAliasMetaData();
        AliasTestCase.assertNotNull((Object)aliases);
        int size = aliases.size();
        AliasTestCase.assertTrue((size > 1 ? 1 : 0) != 0);
        for (AliasMetaData alias : aliases) {
            AliasTestCase.assertNotNull((Object)alias);
            AliasTestCase.assertNotNull((Object)alias.getAliasValue());
        }
    }

    public void testAliasAndBeanFactory() throws Exception {
        GenericBeanFactoryMetaData bean = this.unmarshalBeanFactory("AliasWithBeanFactory.xml");
        Set aliases = bean.getAliases();
        AliasTestCase.assertNotNull((Object)aliases);
        AliasTestCase.assertFalse((boolean)aliases.isEmpty());
        AliasTestCase.assertEquals((Object)"SimpleAliasWithBF", (Object)((AliasMetaData)aliases.iterator().next()).getAliasValue());
    }

    public void testAliasAndBeanFactoryJavaBean() throws Exception {
        GenericBeanFactoryMetaData bean = this.unmarshalBeanFactory("AliasWithBeanFactoryJavaBean.xml");
        Set aliases = bean.getAliases();
        AliasTestCase.assertNotNull((Object)aliases);
        AliasTestCase.assertFalse((boolean)aliases.isEmpty());
        this.assertInstanceOf(((AliasMetaData)aliases.iterator().next()).getAliasValue(), ArrayList.class);
    }

    protected NamedAliasMetaData getNamedAlias(String name) throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment(name);
        Set aliases = deployment.getAliases();
        AliasTestCase.assertNotNull((Object)aliases);
        AliasTestCase.assertEquals((int)1, (int)aliases.size());
        NamedAliasMetaData alias = (NamedAliasMetaData)aliases.iterator().next();
        AliasTestCase.assertNotNull((Object)alias);
        return alias;
    }
}

