/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.test.kernel.annotations.support.TestBean;
import org.jboss.test.kernel.deployment.support.TestAnnotation1;
import org.jboss.test.kernel.deployment.test.AbstractDeploymentTest;

public class AnnotationRedeployTestCase
extends AbstractDeploymentTest {
    public static Test suite() {
        return AnnotationRedeployTestCase.suite(AnnotationRedeployTestCase.class);
    }

    public AnnotationRedeployTestCase(String name) throws Throwable {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationRedeploy() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"test", (String)TestBean.class.getName());
        builder.addAnnotation("@" + TestAnnotation1.class.getName());
        TestClassLoader cl = new TestClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        builder.setClassLoader((Object)cl);
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        MetaData metaData = null;
        TestClassLoader2 tcl = new TestClassLoader2(((Object)((Object)this)).getClass().getClassLoader());
        ClassLoader old = this.setContextClassLoader(tcl);
        try {
            Object annotation;
            KernelControllerContext context = this.deploy(beanMetaData);
            try {
                this.validate();
                metaData = context.getScopeInfo().getMetaData();
                AnnotationRedeployTestCase.assertNotNull((Object)metaData);
                annotation = metaData.getMetaData(TestAnnotation1.class.getName());
                AnnotationRedeployTestCase.assertNotNull((Object)annotation);
                AnnotationRedeployTestCase.assertEquals((Object)cl, (Object)annotation.getClass().getClassLoader());
            }
            finally {
                this.undeploy(context);
            }
            AnnotationRedeployTestCase.assertNull((Object)metaData.getMetaData(TestAnnotation1.class.getName()));
            cl = new TestClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            beanMetaData.setClassLoader((ClassLoaderMetaData)new AbstractClassLoaderMetaData((ValueMetaData)new AbstractValueMetaData((Object)cl)));
            context = this.deploy(beanMetaData);
            try {
                this.validate();
                metaData = context.getScopeInfo().getMetaData();
                AnnotationRedeployTestCase.assertNotNull((Object)metaData);
                annotation = metaData.getMetaData(TestAnnotation1.class.getName());
                AnnotationRedeployTestCase.assertNotNull((Object)annotation);
                AnnotationRedeployTestCase.assertEquals((Object)cl, (Object)annotation.getClass().getClassLoader());
            }
            finally {
                this.undeploy(context);
            }
        }
        finally {
            this.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader setContextClassLoader(ClassLoader tcl) {
        SecurityManager sm = AnnotationRedeployTestCase.suspendSecurity();
        try {
            Thread thread = Thread.currentThread();
            ClassLoader result = thread.getContextClassLoader();
            thread.setContextClassLoader(tcl);
            ClassLoader classLoader = result;
            return classLoader;
        }
        finally {
            AnnotationRedeployTestCase.resumeSecurity((SecurityManager)sm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestClassLoader2
    extends ClassLoader {
        public TestClassLoader2(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (TestAnnotation1.class.getName().equals(name)) {
                throw new ClassNotFoundException("Masked: " + name);
            }
            return super.loadClass(name, resolve);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestClassLoader
    extends ClassLoader {
        public TestClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (TestAnnotation1.class.getName().equals(name)) {
                String resourceName = "/" + name.replace('.', '/') + ".class";
                URL url = AnnotationRedeployTestCase.this.getResource(resourceName);
                InputStream is = null;
                byte[] bytes = null;
                try {
                    is = url.openStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] tmp = new byte[1024];
                    int read = 0;
                    while ((read = is.read(tmp)) >= 0) {
                        baos.write(tmp, 0, read);
                    }
                    bytes = baos.toByteArray();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load class byte code " + name, e);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                }
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            return super.loadClass(name, resolve);
        }
    }
}

