/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.props.test;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.deployment.props.PropertiesGraphFactory;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.BaseTestCase;

public class GraphBuilderTestCase
extends BaseTestCase {
    public GraphBuilderTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return GraphBuilderTestCase.suite(GraphBuilderTestCase.class);
    }

    public void testGraphFromProperties() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("mybean.(class)", "org.jboss.acme.MyBean");
        properties.put("mybean.somenumber", "123L");
        properties.put("mybean.somenumber.type", "java.lang.Long");
        properties.put("mybean.injectee", "(inject).injectee");
        properties.put("injectee.(class)", "org.jboss.acme.MyBean2");
        PropertiesGraphFactory propertiesGraph = new PropertiesGraphFactory(properties);
        KernelDeployment deployment = propertiesGraph.build();
        GraphBuilderTestCase.assertNotNull((Object)deployment);
        List beans = deployment.getBeans();
        GraphBuilderTestCase.assertNotNull((Object)beans);
        GraphBuilderTestCase.assertFalse((boolean)beans.isEmpty());
        BeanMetaData bean1 = (BeanMetaData)beans.get(0);
        this.assertInstanceOf(bean1, AbstractBeanMetaData.class);
        AbstractBeanMetaData abmd1 = (AbstractBeanMetaData)bean1;
        GraphBuilderTestCase.assertNotNull((Object)bean1);
        GraphBuilderTestCase.assertEquals((String)"mybean", (String)bean1.getName());
        GraphBuilderTestCase.assertEquals((String)"org.jboss.acme.MyBean", (String)bean1.getBean());
        Set propertys = bean1.getProperties();
        GraphBuilderTestCase.assertNotNull((Object)propertys);
        GraphBuilderTestCase.assertFalse((boolean)propertys.isEmpty());
        GraphBuilderTestCase.assertEquals((int)2, (int)propertys.size());
        PropertyMetaData pmd1 = abmd1.getProperty("somenumber");
        GraphBuilderTestCase.assertNotNull((Object)pmd1);
        ValueMetaData vmd1 = pmd1.getValue();
        GraphBuilderTestCase.assertNotNull((Object)vmd1);
        this.assertInstanceOf(vmd1, StringValueMetaData.class);
        GraphBuilderTestCase.assertEquals((Object)"123L", (Object)vmd1.getUnderlyingValue());
        GraphBuilderTestCase.assertEquals((String)"java.lang.Long", (String)((StringValueMetaData)vmd1).getType());
        PropertyMetaData pmd2 = abmd1.getProperty("injectee");
        GraphBuilderTestCase.assertNotNull((Object)pmd2);
        ValueMetaData vmd2 = pmd2.getValue();
        GraphBuilderTestCase.assertNotNull((Object)vmd2);
        this.assertInstanceOf(vmd2, AbstractDependencyValueMetaData.class);
        BeanMetaData bean2 = (BeanMetaData)beans.get(1);
        GraphBuilderTestCase.assertNotNull((Object)bean2);
        GraphBuilderTestCase.assertEquals((String)"injectee", (String)bean2.getName());
        GraphBuilderTestCase.assertEquals((String)"org.jboss.acme.MyBean2", (String)bean2.getBean());
    }
}

