/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.ArrayList;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.ThisValueMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.GenericBeanFactoryMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.GenericBeanFactoryRepository;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.test.AbstractKernelDependencyTest;

public class GenericBeanFactoryInstallDependencyTestCase
extends AbstractKernelDependencyTest {
    public static Test suite() {
        return GenericBeanFactoryInstallDependencyTestCase.suite(GenericBeanFactoryInstallDependencyTestCase.class);
    }

    public GenericBeanFactoryInstallDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public GenericBeanFactoryInstallDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testInstallDependencyCorrectOrder() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        GenericBeanFactoryRepository bean1 = (GenericBeanFactoryRepository)context1.getTarget();
        GenericBeanFactoryInstallDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactory bean2 = (GenericBeanFactory)context2.getTarget();
        GenericBeanFactoryInstallDependencyTestCase.assertNotNull((Object)bean2);
        ArrayList<GenericBeanFactory> expected = new ArrayList<GenericBeanFactory>();
        expected.add(bean2);
        GenericBeanFactoryInstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
    }

    public void testInstallDependencyWrongOrder() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.START);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryRepository bean1 = (GenericBeanFactoryRepository)context1.getTarget();
        GenericBeanFactoryInstallDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactory bean2 = (GenericBeanFactory)context2.getTarget();
        GenericBeanFactoryInstallDependencyTestCase.assertNotNull((Object)bean2);
        ArrayList<GenericBeanFactory> expected = new ArrayList<GenericBeanFactory>();
        expected.add(bean2);
        GenericBeanFactoryInstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
    }

    public void testInstallDependencyReinstall() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        GenericBeanFactoryRepository bean1 = (GenericBeanFactoryRepository)context1.getTarget();
        GenericBeanFactoryInstallDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactory bean2 = (GenericBeanFactory)context2.getTarget();
        GenericBeanFactoryInstallDependencyTestCase.assertNotNull((Object)bean2);
        ArrayList<GenericBeanFactory> expected = new ArrayList<GenericBeanFactory>();
        expected.add(bean2);
        GenericBeanFactoryInstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
        this.assertUninstall("Name1");
        this.assertContext("Name2", ControllerState.START);
        expected = new ArrayList();
        GenericBeanFactoryInstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
        context1 = this.assertInstall(0, "Name1");
        this.assertContext("Name2", ControllerState.INSTALLED);
        bean1 = (GenericBeanFactoryRepository)context1.getTarget();
        GenericBeanFactoryInstallDependencyTestCase.assertNotNull((Object)bean1);
        expected = new ArrayList();
        expected.add(bean2);
        GenericBeanFactoryInstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
        this.assertUninstall("Name2");
        this.assertContext("Name1", ControllerState.INSTALLED);
        expected = new ArrayList();
        GenericBeanFactoryInstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
        context2 = this.assertInstall(1, "Name2");
        this.assertContext("Name1", ControllerState.INSTALLED);
        bean2 = (GenericBeanFactory)context2.getTarget();
        GenericBeanFactoryInstallDependencyTestCase.assertNotNull((Object)bean2);
        expected = new ArrayList();
        expected.add(bean2);
        GenericBeanFactoryInstallDependencyTestCase.assertEquals(expected, bean1.getBeans());
    }

    protected void setupBeanMetaDatas() throws Throwable {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("Name1", GenericBeanFactoryRepository.class.getName());
        GenericBeanFactoryMetaData metaData2 = new GenericBeanFactoryMetaData("Name2", SimpleBeanImpl.class.getName());
        ArrayList<AbstractInstallMetaData> installs = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData install = new AbstractInstallMetaData();
        install.setBean("Name1");
        install.setMethodName("addGenericBeanFactory");
        ArrayList<AbstractParameterMetaData> parameters = new ArrayList<AbstractParameterMetaData>();
        parameters.add(new AbstractParameterMetaData(null, (ValueMetaData)new ThisValueMetaData()));
        install.setParameters(parameters);
        installs.add(install);
        metaData2.setInstalls(installs);
        ArrayList<AbstractInstallMetaData> uninstalls = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData uninstall = new AbstractInstallMetaData();
        uninstall.setBean("Name1");
        uninstall.setMethodName("removeGenericBeanFactory");
        parameters = new ArrayList();
        parameters.add(new AbstractParameterMetaData(null, (ValueMetaData)new ThisValueMetaData()));
        uninstall.setParameters(parameters);
        uninstalls.add(uninstall);
        metaData2.setUninstalls(uninstalls);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, this.getBeanMetaData(metaData2)});
    }
}

