/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.override;

import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractLifecycleMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.kernel.annotations.support.AnnotationTester;
import org.jboss.test.kernel.annotations.test.override.AbstractAnnotationOverrideTestCase;

public class LifecycleAnnotationOverrideTestCase
extends AbstractAnnotationOverrideTestCase {
    private Controller controller;
    private ControllerContext context;

    public LifecycleAnnotationOverrideTestCase(String name) throws Throwable {
        super(name);
    }

    public LifecycleAnnotationOverrideTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public static Test suite() {
        return LifecycleAnnotationOverrideTestCase.suite(LifecycleAnnotationOverrideTestCase.class);
    }

    protected String getType() {
        return "Lifecycle";
    }

    protected void addMetaData(AbstractBeanMetaData beanMetaData) {
        beanMetaData.setCreate((LifecycleMetaData)new AbstractLifecycleMetaData("fromXMLCreate"));
        beanMetaData.setStart((LifecycleMetaData)new AbstractLifecycleMetaData("fromXMLStart"));
        beanMetaData.setStop((LifecycleMetaData)new AbstractLifecycleMetaData("fromXMLStop"));
        beanMetaData.setDestroy((LifecycleMetaData)new AbstractLifecycleMetaData("fromXMLDestroy"));
    }

    public void testLifecycleOverride() throws Throwable {
        AnnotationTester tester = this.getTester();
        Object[] values = (Object[])tester.getValue();
        this.assertEquals(new Object[]{"FromXML", "FromXML", null, null}, values);
        this.doUndeploy();
        values = (Object[])tester.getValue();
        this.assertEquals(new Object[]{null, null, "FromXML", "FromXML"}, values);
    }

    protected void afterInstall(KernelController controller, KernelControllerContext context) {
        this.controller = controller;
        this.context = context;
    }

    protected void doUndeploy() {
        this.controller.uninstall(this.context.getName());
        this.controller = null;
        this.context = null;
    }
}

