/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.registry.AbstractKernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.util.NestedRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractKernelTest
extends AbstractTestCaseWithSetup {
    private static DateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", Locale.US);
    private Locale locale;

    public AbstractKernelTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.locale = Locale.getDefault();
        this.setLocale(Locale.US);
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocale(Locale locale) {
        SecurityManager sm = AbstractKernelTest.suspendSecurity();
        try {
            Locale.setDefault(locale);
        }
        finally {
            AbstractKernelTest.resumeSecurity((SecurityManager)sm);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.setLocale(this.locale);
        this.locale = null;
    }

    protected Kernel bootstrap() throws Throwable {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        this.configureLoggingAfterBootstrap();
        return bootstrap.getKernel();
    }

    protected static void assertEqualsRegistryTarget(KernelRegistryEntry e1, KernelRegistryEntry e2) {
        AbstractKernelTest.assertEquals((Object)e1.getTarget(), (Object)e2.getTarget());
    }

    protected static KernelRegistryEntry makeEntry(Object o) {
        return new AbstractKernelRegistryEntry(o);
    }

    protected Date createDate(String date) {
        Locale locale = Locale.getDefault();
        try {
            this.setLocale(Locale.US);
            Date date2 = dateFormat.parse(date);
            return date2;
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        finally {
            this.setLocale(locale);
        }
    }

    protected Date createDate(int year, int month, int day) {
        Calendar calender = Calendar.getInstance();
        calender.clear();
        calender.set(year, month - 1, day, 0, 0, 0);
        return calender.getTime();
    }

    protected void configureLoggingAfterBootstrap() {
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        AbstractTestDelegate delegate = new AbstractTestDelegate(clazz);
        delegate.enableSecurity = true;
        return delegate;
    }
}

