/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classloading.vfs;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.test.classloading.vfs.VFSClassLoader;

public class SecurityActions {
    static VFSClassLoader newClassLoader(URL[] urls) {
        if (System.getSecurityManager() == null) {
            return ClassLoaderActions.NON_PRIVILEGED.newClassLoader(urls);
        }
        return ClassLoaderActions.PRIVILEGED.newClassLoader(urls);
    }

    static interface ClassLoaderActions {
        public static final ClassLoaderActions PRIVILEGED = new ClassLoaderActions(){

            public VFSClassLoader newClassLoader(final URL[] urls) {
                PrivilegedAction<VFSClassLoader> action = new PrivilegedAction<VFSClassLoader>(){

                    @Override
                    public VFSClassLoader run() {
                        return new VFSClassLoader(urls);
                    }
                };
                return AccessController.doPrivileged(action);
            }
        };
        public static final ClassLoaderActions NON_PRIVILEGED = new ClassLoaderActions(){

            public VFSClassLoader newClassLoader(URL[] urls) {
                return new VFSClassLoader(urls);
            }
        };

        public VFSClassLoader newClassLoader(URL[] var1);
    }
}

