/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classloading.vfs;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtil {
    public static URL getLocation(String className) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        return clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    public static ClassLoader getClassLoader(final Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz.");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }
}

