/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.util.Iterator;
import org.jboss.beans.metadata.spi.AliasMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractAliasMetaData
extends JBossObject
implements AliasMetaData,
Serializable {
    private static final long serialVersionUID = 1L;
    private static TypeInfoFactory typeInfoFactory = new IntrospectionTypeInfoFactory();
    public String alias;
    protected boolean replace = true;
    protected String clazz;

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    @Override
    public Object getAliasValue() {
        try {
            if (this.clazz != null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                TypeInfo info = typeInfoFactory.getTypeInfo(this.clazz, cl);
                return info.convertValue((Object)this.alias, this.replace);
            }
            String aliasString = this.alias;
            if (this.replace) {
                aliasString = StringPropertyReplacer.replaceProperties((String)aliasString);
            }
            return aliasString;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error creating alias for " + this.alias, t);
        }
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        visitor.initialVisit(this);
    }

    @Override
    public void describeVisit(MetaDataVisitor vistor) {
        vistor.describeVisit(this);
    }

    @Override
    public Iterator<? extends MetaDataVisitorNode> getChildren() {
        return null;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("alias=").append(this.alias);
        buffer.append(" replace=").append(this.replace);
        if (this.clazz != null) {
            buffer.append(" class=").append(this.clazz);
        }
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.alias);
    }

    protected int getHashCode() {
        return this.alias.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractAliasMetaData)) {
            return false;
        }
        AbstractAliasMetaData amd = (AbstractAliasMetaData)object;
        return this.alias.equals(amd.alias) && this.replace == amd.replace && this.clazz != null && this.clazz.equals(amd.clazz);
    }
}

