/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.registry.test;

import junit.framework.Test;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntryAlreadyRegisteredException;
import org.jboss.kernel.spi.registry.KernelRegistryEntryNotFoundException;
import org.jboss.test.kernel.AbstractKernelTest;

public class RegistryTestCase
extends AbstractKernelTest {
    public static Test suite() {
        return RegistryTestCase.suite(RegistryTestCase.class);
    }

    public RegistryTestCase(String name) {
        super(name);
    }

    public void testGotRegistry() throws Throwable {
        KernelRegistry registry = this.bootstrap().getRegistry();
        RegistryTestCase.assertNotNull((Object)registry);
    }

    public void testRegister() throws Throwable {
        KernelRegistry registry = this.bootstrap().getRegistry();
        KernelRegistryEntry test1 = RegistryTestCase.makeEntry(new Object());
        registry.registerEntry((Object)"Name1", test1);
        RegistryTestCase.assertEqualsRegistryTarget(test1, registry.getEntry((Object)"Name1"));
    }

    public void testDuplicateRegisterError() throws Throwable {
        KernelRegistry registry = this.bootstrap().getRegistry();
        KernelRegistryEntry test1 = RegistryTestCase.makeEntry(new Object());
        registry.registerEntry((Object)"Name1", test1);
        KernelRegistryEntry test2 = RegistryTestCase.makeEntry(new Object());
        try {
            registry.registerEntry((Object)"Name1", test2);
            RegistryTestCase.fail((String)"Expected duplicate registration error");
        }
        catch (KernelRegistryEntryAlreadyRegisteredException e) {
            // empty catch block
        }
        RegistryTestCase.assertEqualsRegistryTarget(test1, registry.getEntry((Object)"Name1"));
    }

    public void testRegisterTwice() throws Throwable {
        KernelRegistry registry = this.bootstrap().getRegistry();
        Object object = new Object();
        KernelRegistryEntry test1 = RegistryTestCase.makeEntry(object);
        registry.registerEntry((Object)"Name1", test1);
        KernelRegistryEntry test2 = RegistryTestCase.makeEntry(object);
        registry.registerEntry((Object)"Name2", test2);
        RegistryTestCase.assertEqualsRegistryTarget(registry.getEntry((Object)"Name1"), registry.getEntry((Object)"Name2"));
    }

    public void testUnregister() throws Throwable {
        KernelRegistry registry = this.bootstrap().getRegistry();
        try {
            registry.getEntry((Object)"Name1");
            RegistryTestCase.fail((String)"Expected not registered error");
        }
        catch (KernelRegistryEntryNotFoundException e) {
            // empty catch block
        }
        try {
            registry.unregisterEntry((Object)"Name1");
            RegistryTestCase.fail((String)"Expected not registered error");
        }
        catch (KernelRegistryEntryNotFoundException e) {
            // empty catch block
        }
        KernelRegistryEntry test1 = RegistryTestCase.makeEntry(new Object());
        registry.registerEntry((Object)"Name1", test1);
        registry.unregisterEntry((Object)"Name1");
        try {
            registry.getEntry((Object)"Name1");
            RegistryTestCase.fail((String)"Expected not registered error");
        }
        catch (KernelRegistryEntryNotFoundException e) {
            // empty catch block
        }
        try {
            registry.unregisterEntry((Object)"Name1");
            RegistryTestCase.fail((String)"Expected not registered error");
        }
        catch (KernelRegistryEntryNotFoundException kernelRegistryEntryNotFoundException) {
            // empty catch block
        }
        registry.registerEntry((Object)"Name1", test1);
        RegistryTestCase.assertEqualsRegistryTarget(test1, registry.getEntry((Object)"Name1"));
    }

    public void testNull() throws Throwable {
        KernelRegistry registry = this.bootstrap().getRegistry();
        try {
            registry.getEntry(null);
            RegistryTestCase.fail((String)"Expected null name error");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            KernelRegistryEntry test1 = RegistryTestCase.makeEntry(new Object());
            registry.registerEntry(null, test1);
            RegistryTestCase.fail((String)"Expected null name error");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            registry.registerEntry((Object)"Name1", null);
            RegistryTestCase.fail((String)"Expected null object error");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            registry.unregisterEntry(null);
            RegistryTestCase.fail((String)"Expected null name error");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void configureLoggingAfterBootstrap() {
    }
}

