/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.lazy.test;

import java.util.Collections;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractLazyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.test.kernel.lazy.support.IRare;
import org.jboss.test.kernel.lazy.support.RareBean;

public abstract class LazyInstantiationTestCase
extends AbstractKernelTest {
    public LazyInstantiationTestCase(String name) {
        super(name);
    }

    public static AbstractTestDelegate getDelegate(Class clazz) throws Exception {
        return new AbstractTestDelegate(clazz);
    }

    protected abstract String getFactoryClassName();

    public void testLazy() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractBeanMetaData bean = new AbstractBeanMetaData("bean", RareBean.class.getName());
        bean.setMode(ControllerMode.MANUAL);
        KernelControllerContext beanContext = controller.install((BeanMetaData)bean);
        controller.change((ControllerContext)beanContext, ControllerState.NOT_INSTALLED);
        ModifiedLazyMetaData lazy = new ModifiedLazyMetaData("bean", this.getFactoryClassName());
        lazy.setInterfaces(Collections.singleton(IRare.class.getName()));
        KernelControllerContext lazyContext = controller.install((BeanMetaData)lazy);
        LazyInstantiationTestCase.assertNotNull((Object)lazyContext);
        LazyInstantiationTestCase.assertEquals((Object)ControllerState.DESCRIBED, (Object)lazyContext.getState());
        controller.change((ControllerContext)beanContext, ControllerState.DESCRIBED);
        controller.change((ControllerContext)lazyContext, ControllerState.INSTALLED);
        IRare lazyRare = (IRare)lazyContext.getTarget();
        LazyInstantiationTestCase.assertNotNull((Object)lazyRare);
        try {
            lazyRare.getHits();
            throw new RuntimeException("Should not be here.");
        }
        catch (Throwable t) {
            this.assertInstanceOf(t, IllegalArgumentException.class);
            controller.change((ControllerContext)beanContext, ControllerState.INSTALLED);
            LazyInstantiationTestCase.assertEquals((int)0, (int)lazyRare.getHits());
            lazyRare.setHits(10);
            LazyInstantiationTestCase.assertEquals((int)5, (int)lazyRare.checkHits(15));
            controller.change((ControllerContext)beanContext, ControllerState.PRE_INSTALL);
            LazyInstantiationTestCase.assertEquals((Object)ControllerState.DESCRIBED, (Object)lazyContext.getState());
            return;
        }
    }

    private class ModifiedLazyMetaData
    extends AbstractLazyMetaData {
        public ModifiedLazyMetaData(String beanName, String factoryClassName) {
            super(beanName);
            this.setFactoryClassName(factoryClassName);
        }
    }
}

