/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.FromContext;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class InjectionTestCase
extends AbstractXMLTest {
    protected AbstractInjectionValueMetaData getInjection(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        Set properties = bean.getProperties();
        InjectionTestCase.assertNotNull((Object)properties);
        InjectionTestCase.assertEquals((int)1, (int)properties.size());
        PropertyMetaData property = (PropertyMetaData)properties.iterator().next();
        InjectionTestCase.assertNotNull((Object)property);
        ValueMetaData value = property.getValue();
        InjectionTestCase.assertNotNull((Object)value);
        InjectionTestCase.assertTrue((boolean)(value instanceof AbstractInjectionValueMetaData));
        return (AbstractInjectionValueMetaData)value;
    }

    public void testInjectionWithBean() throws Exception {
        AbstractInjectionValueMetaData dependency = this.getInjection("InjectionWithBean.xml");
        InjectionTestCase.assertEquals((Object)"Bean1", (Object)dependency.getValue());
        InjectionTestCase.assertNull((Object)dependency.getProperty());
        InjectionTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)dependency.getDependentState());
    }

    public void testInjectionWithProperty() throws Exception {
        AbstractInjectionValueMetaData dependency = this.getInjection("InjectionWithProperty.xml");
        InjectionTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        InjectionTestCase.assertEquals((String)"Property1", (String)dependency.getProperty());
        InjectionTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)dependency.getDependentState());
    }

    public void testInjectionWithState() throws Exception {
        AbstractInjectionValueMetaData dependency = this.getInjection("InjectionWithState.xml");
        InjectionTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        InjectionTestCase.assertNull((Object)dependency.getProperty());
        InjectionTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)dependency.getDependentState());
    }

    public void testInjectionBadNoBean() throws Exception {
        try {
            AbstractInjectionValueMetaData dependency = this.getInjection("InjectionBadNoBean.xml");
            InjectionTestCase.assertNull((Object)dependency.getValue());
        }
        catch (Exception expected) {
            this.checkJBossXBException(IllegalArgumentException.class, expected);
        }
    }

    public void testInjectionWithFromContext() throws Exception {
        AbstractInjectionValueMetaData dependency = this.getInjection("InjectionWithFromContext.xml");
        InjectionTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        InjectionTestCase.assertNull((Object)dependency.getProperty());
        InjectionTestCase.assertEquals((Object)FromContext.getInstance((String)"name"), (Object)dependency.getFromContext());
    }

    public static Test suite() {
        return InjectionTestCase.suite(InjectionTestCase.class);
    }

    public InjectionTestCase(String name) {
        super(name);
    }
}

