/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class FactoryTestCase
extends AbstractXMLTest {
    protected AbstractValueMetaData getFactory(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        ConstructorMetaData constructor = bean.getConstructor();
        FactoryTestCase.assertNotNull((Object)constructor);
        ValueMetaData factory = constructor.getFactory();
        FactoryTestCase.assertNotNull((Object)factory);
        FactoryTestCase.assertTrue((boolean)(factory instanceof AbstractValueMetaData));
        return (AbstractValueMetaData)factory;
    }

    protected AbstractDependencyValueMetaData getFactoryDependency(String name) throws Exception {
        return (AbstractDependencyValueMetaData)this.getFactory(name);
    }

    public void testFactoryWithBean() throws Exception {
        AbstractDependencyValueMetaData dependency = this.getFactoryDependency("FactoryWithBean.xml");
        FactoryTestCase.assertEquals((Object)"Bean1", (Object)dependency.getValue());
        FactoryTestCase.assertNull((Object)dependency.getProperty());
        FactoryTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)dependency.getDependentState());
    }

    public void testFactoryWithProperty() throws Exception {
        AbstractDependencyValueMetaData dependency = this.getFactoryDependency("FactoryWithProperty.xml");
        FactoryTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        FactoryTestCase.assertEquals((String)"Property1", (String)dependency.getProperty());
        FactoryTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)dependency.getDependentState());
    }

    public void testFactoryWithState() throws Exception {
        AbstractDependencyValueMetaData dependency = this.getFactoryDependency("FactoryWithState.xml");
        FactoryTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        FactoryTestCase.assertNull((Object)dependency.getProperty());
        FactoryTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)dependency.getDependentState());
    }

    public void testFactoryWithWildcard() throws Exception {
        this.assertWildcard((ValueMetaData)this.getFactory("FactoryWithWildcard.xml"));
    }

    public void testFactoryBadNoBeanOrWildcard() throws Exception {
        try {
            this.unmarshalBean("FactoryBadNoBeanOrWildcard.xml");
            FactoryTestCase.fail((String)"Should not be here");
        }
        catch (Exception expected) {
            this.checkJBossXBException(IllegalArgumentException.class, expected);
        }
    }

    public static Test suite() {
        return FactoryTestCase.suite(FactoryTestCase.class);
    }

    public FactoryTestCase(String name) {
        super(name);
    }
}

