/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractArrayMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractCollectionMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.beans.metadata.plugins.AbstractMapMetaData;
import org.jboss.beans.metadata.plugins.AbstractSetMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.plugins.ThisValueMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactoryMetaData;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.CallbackMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.kernel.deployment.xml.test.XMLTestDelegate;
import org.jboss.xb.binding.JBossXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractXMLTest
extends AbstractTestCaseWithSetup {
    protected String rootName = this.getRootName();

    public AbstractXMLTest(String name) {
        super(name);
    }

    protected AbstractKernelDeployment unmarshalDeployment(String name) throws Exception {
        return this.unmarshal(name, AbstractKernelDeployment.class);
    }

    protected AbstractBeanMetaData unmarshalBean(String name) throws Exception {
        return this.unmarshal(name, AbstractBeanMetaData.class);
    }

    protected GenericBeanFactoryMetaData unmarshalBeanFactory(String name) throws Exception {
        return this.unmarshal(name, GenericBeanFactoryMetaData.class);
    }

    protected <T> T unmarshal(String name, Class<T> expected) throws Exception {
        String url = this.findXML(name);
        Object object = this.getJBossXBDelegate().unmarshal(url);
        if (object == null) {
            AbstractXMLTest.fail((String)("No object from " + name));
        }
        Serializable serializable = (Serializable)this.assertInstanceOf(object, Serializable.class, false);
        object = this.deserialize(this.serialize(serializable));
        AbstractXMLTest.assertTrue((String)("Object '" + object + "' cannot be assigned to " + expected.getName()), (boolean)expected.isAssignableFrom(object.getClass()));
        return expected.cast(object);
    }

    protected String findXML(String name) {
        URL url = this.getResource(name);
        if (url == null) {
            AbstractXMLTest.fail((String)(name + " not found"));
        }
        return url.toString();
    }

    protected void assertAnnotations(Set<String> expected, Set<AnnotationMetaData> annotations) {
        AbstractXMLTest.assertNotNull(annotations);
        AbstractXMLTest.assertEquals((int)expected.size(), (int)annotations.size());
        HashSet<String> clonedExpected = new HashSet<String>(expected);
        for (AnnotationMetaData annotation : annotations) {
            if (clonedExpected.remove(annotation.getAnnotationInstance().annotationType().getName())) continue;
            AbstractXMLTest.fail((String)("Did not expect " + annotation + " expected " + expected));
        }
        if (clonedExpected.size() != 0) {
            AbstractXMLTest.fail((String)("Expected " + expected + " got " + annotations));
        }
    }

    protected void assertProperties(Set<String> expected, Set<PropertyMetaData> properties) {
        AbstractXMLTest.assertNotNull(properties);
        AbstractXMLTest.assertEquals((int)expected.size(), (int)properties.size());
        HashSet<String> clonedExpected = new HashSet<String>(expected);
        for (PropertyMetaData property : properties) {
            if (clonedExpected.remove(property.getName())) continue;
            AbstractXMLTest.fail((String)("Did not expect " + property + " expected " + expected));
        }
        if (clonedExpected.size() != 0) {
            AbstractXMLTest.fail((String)("Expected " + expected + " got " + properties));
        }
    }

    protected void assertBeanFactoryProperties(Set<String> expected, GenericBeanFactoryMetaData factory) {
        AbstractXMLTest.assertNotNull((Object)factory);
        PropertyMetaData propertiesProperty = factory.getProperty("properties");
        AbstractXMLTest.assertNotNull((Object)propertiesProperty);
        AbstractMapMetaData map = (AbstractMapMetaData)propertiesProperty.getValue();
        AbstractXMLTest.assertNotNull((Object)map);
        Set properties = map.keySet();
        AbstractXMLTest.assertEquals((int)expected.size(), (int)properties.size());
        HashSet<String> clonedExpected = new HashSet<String>(expected);
        for (AbstractValueMetaData property : properties) {
            if (clonedExpected.remove(property.getUnderlyingValue())) continue;
            AbstractXMLTest.fail((String)("Did not expect " + property + " expected " + expected));
        }
        if (clonedExpected.size() != 0) {
            AbstractXMLTest.fail((String)("Expected " + expected + " got " + properties));
        }
    }

    protected void assertDepends(Set<String> expected, Set<DependencyMetaData> depends) {
        AbstractXMLTest.assertNotNull(depends);
        AbstractXMLTest.assertEquals((int)expected.size(), (int)depends.size());
        HashSet<String> clonedExpected = new HashSet<String>(expected);
        for (DependencyMetaData depend : depends) {
            if (clonedExpected.remove(depend.getDependency())) continue;
            AbstractXMLTest.fail((String)("Did not expect " + depend + " expected " + expected));
        }
        if (clonedExpected.size() != 0) {
            AbstractXMLTest.fail((String)("Expected " + expected + " got " + depends));
        }
    }

    protected void assertDemands(Set<String> expected, Set<DemandMetaData> demands) {
        AbstractXMLTest.assertNotNull(demands);
        AbstractXMLTest.assertEquals((int)expected.size(), (int)demands.size());
        HashSet<String> clonedExpected = new HashSet<String>(expected);
        for (DemandMetaData demand : demands) {
            if (clonedExpected.remove(demand.getDemand())) continue;
            AbstractXMLTest.fail((String)("Did not expect " + demand + " expected " + expected));
        }
        if (clonedExpected.size() != 0) {
            AbstractXMLTest.fail((String)("Expected " + expected + " got " + demands));
        }
    }

    protected void assertSupplies(Set<String> expected, Set<SupplyMetaData> supplies) {
        AbstractXMLTest.assertNotNull(supplies);
        AbstractXMLTest.assertEquals((int)expected.size(), (int)supplies.size());
        HashSet<String> clonedExpected = new HashSet<String>(expected);
        for (SupplyMetaData supply : supplies) {
            if (clonedExpected.remove(supply.getSupply())) continue;
            AbstractXMLTest.fail((String)("Did not expect " + supply + " expected " + expected));
        }
        if (clonedExpected.size() != 0) {
            AbstractXMLTest.fail((String)("Expected " + expected + " got " + supplies));
        }
    }

    protected void assertInstalls(List expected, List installs) {
        AbstractXMLTest.assertNotNull((Object)installs);
        AbstractXMLTest.assertEquals((int)expected.size(), (int)installs.size());
        for (int i = 0; i < expected.size(); ++i) {
            InstallMetaData install = (InstallMetaData)installs.get(i);
            String method = (String)expected.get(i);
            AbstractXMLTest.assertEquals((String)method, (String)install.getMethodName());
        }
    }

    protected void assertCallbacks(List expected, List callbacks) {
        AbstractXMLTest.assertNotNull((Object)callbacks);
        AbstractXMLTest.assertEquals((int)expected.size(), (int)callbacks.size());
        for (int i = 0; i < expected.size(); ++i) {
            CallbackMetaData callback = (CallbackMetaData)callbacks.get(i);
            String method = (String)expected.get(i);
            AbstractXMLTest.assertEquals((String)method, (String)callback.getMethodName());
        }
    }

    protected void assertParameters(List expected, List parameters) {
        AbstractXMLTest.assertNotNull((Object)parameters);
        AbstractXMLTest.assertEquals((int)expected.size(), (int)parameters.size());
        for (int i = 0; i < expected.size(); ++i) {
            ParameterMetaData parameter = (ParameterMetaData)parameters.get(i);
            String method = (String)expected.get(i);
            AbstractXMLTest.assertEquals((String)method, (String)parameter.getType());
        }
    }

    protected void assertPlainValue(String expected, ValueMetaData valueMetaData) {
        this.assertValue(expected, valueMetaData);
    }

    protected void assertValue(String expected, ValueMetaData valueMetaData) {
        AbstractXMLTest.assertNotNull((Object)valueMetaData);
        AbstractXMLTest.assertTrue((boolean)(valueMetaData instanceof StringValueMetaData));
        Object value = valueMetaData.getUnderlyingValue();
        AbstractXMLTest.assertEquals((Object)expected, (Object)value);
    }

    protected void assertInjection(ValueMetaData value) {
        AbstractXMLTest.assertNotNull((Object)value);
        AbstractXMLTest.assertTrue((boolean)(value instanceof AbstractDependencyValueMetaData));
    }

    protected void assertNullValue(ValueMetaData value) {
        AbstractXMLTest.assertNotNull((Object)value);
        AbstractXMLTest.assertTrue((boolean)(value instanceof AbstractValueMetaData));
        AbstractXMLTest.assertNull((Object)value.getUnderlyingValue());
    }

    protected void assertWildcard(ValueMetaData value) {
        AbstractXMLTest.assertNotNull((Object)value);
        AbstractXMLTest.assertEquals(AbstractValueMetaData.class, value.getClass());
        Object wildcard = value.getUnderlyingValue();
        AbstractXMLTest.assertNotNull((Object)wildcard);
    }

    protected void assertCollection(ValueMetaData value) {
        AbstractXMLTest.assertNotNull((Object)value);
        AbstractXMLTest.assertTrue((boolean)(value instanceof AbstractCollectionMetaData));
    }

    protected void assertList(ValueMetaData value) {
        AbstractXMLTest.assertNotNull((Object)value);
        AbstractXMLTest.assertTrue((boolean)(value instanceof AbstractListMetaData));
    }

    protected void assertSet(ValueMetaData value) {
        AbstractXMLTest.assertNotNull((Object)value);
        AbstractXMLTest.assertTrue((boolean)(value instanceof AbstractSetMetaData));
    }

    protected void assertArray(ValueMetaData value) {
        AbstractXMLTest.assertNotNull((Object)value);
        AbstractXMLTest.assertTrue((boolean)(value instanceof AbstractArrayMetaData));
    }

    protected void assertMap(ValueMetaData value) {
        AbstractXMLTest.assertNotNull((Object)value);
        AbstractXMLTest.assertTrue((boolean)(value instanceof AbstractMapMetaData));
    }

    protected void assertThis(ValueMetaData value) {
        AbstractXMLTest.assertNotNull((Object)value);
        AbstractXMLTest.assertTrue((boolean)(value instanceof ThisValueMetaData));
    }

    protected void checkJBossXBException(Class<? extends Throwable> expected, Throwable throwable) {
        AbstractXMLTest.checkThrowable(JBossXBException.class, (Throwable)throwable);
        JBossXBException e = (JBossXBException)throwable;
        AbstractXMLTest.checkThrowable(expected, (Throwable)e.getCause());
    }

    public static AbstractTestDelegate getDelegate(Class clazz) throws Exception {
        return new XMLTestDelegate(clazz);
    }

    protected XMLTestDelegate getJBossXBDelegate() {
        return (XMLTestDelegate)this.getDelegate();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.configureLogging();
    }

    protected String getRootName() {
        String longName = ((Object)((Object)this)).getClass().getName();
        int dot = longName.lastIndexOf(46);
        if (dot != -1) {
            return longName.substring(dot + 1);
        }
        return longName;
    }

    protected void configureLogging() {
    }
}

