/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.test.kernel.dependency.support.SimpleBean;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.test.AbstractKernelDependencyTest;

public class PlainAliasTestCase
extends AbstractKernelDependencyTest {
    public PlainAliasTestCase(String name) throws Throwable {
        super(name);
    }

    public PlainAliasTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public static Test suite() {
        return PlainAliasTestCase.suite(PlainAliasTestCase.class);
    }

    protected ControllerContext getAlias(String name) throws Throwable {
        this.installAlias();
        return this.getUtil().getContext(name);
    }

    public void testPlainAliasCorrectOrder() throws Throwable {
        this.buildMetaData();
        ControllerContext context1 = this.assertInstall(0, "OriginalBean");
        ControllerContext context2 = this.getAlias("MyAlias");
        this.assertContext("MyAlias_Alias");
        SimpleBean bean1 = (SimpleBean)context1.getTarget();
        PlainAliasTestCase.assertNotNull((Object)bean1);
        PlainAliasTestCase.assertEquals((String)"String1", (String)bean1.getString());
        PlainAliasTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        ControllerContext alias = this.assertContext("MyAlias");
        PlainAliasTestCase.assertEquals((Object)alias, (Object)context1);
    }

    public void testPlainAliasWrongOrder() throws Throwable {
        this.buildMetaData();
        ControllerContext context1 = this.getAlias("MyAlias");
        PlainAliasTestCase.assertNull((Object)context1);
        this.checkDirectAlias();
        ControllerContext context2 = this.assertInstall(0, "OriginalBean");
        context1 = this.assertContext("MyAlias");
        PlainAliasTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context1.getState());
        this.getDirectAlias(ControllerState.INSTALLED);
        SimpleBean bean1 = (SimpleBean)context2.getTarget();
        PlainAliasTestCase.assertNotNull((Object)bean1);
        PlainAliasTestCase.assertEquals((String)"String1", (String)bean1.getString());
        ControllerContext alias = this.assertContext("MyAlias");
        PlainAliasTestCase.assertEquals((Object)alias, (Object)context1);
    }

    protected void checkDirectAlias() throws Throwable {
        this.getDirectAlias(ControllerState.START).getState();
    }

    protected ControllerContext getDirectAlias(ControllerState state) throws Throwable {
        return this.assertContext("MyAlias_Alias", state);
    }

    public void testPlainAliasReinstall() throws Throwable {
        this.buildMetaData();
        ControllerContext context1 = this.assertInstall(0, "OriginalBean");
        ControllerContext context2 = this.getAlias("MyAlias");
        SimpleBean bean1 = (SimpleBean)context1.getTarget();
        PlainAliasTestCase.assertNotNull((Object)bean1);
        PlainAliasTestCase.assertEquals((String)"String1", (String)bean1.getString());
        PlainAliasTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        ControllerContext alias = this.assertContext("MyAlias");
        PlainAliasTestCase.assertEquals((Object)alias, (Object)context1);
        ControllerContext directAlias = this.assertContext("MyAlias_Alias");
        PlainAliasTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)directAlias.getState());
        this.assertUninstall("OriginalBean");
        PlainAliasTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        PlainAliasTestCase.assertEquals((Object)ControllerState.ERROR, (Object)alias.getState());
        PlainAliasTestCase.assertEquals((Object)this.getDirectAliasUnistallState(), (Object)directAlias.getState());
        PlainAliasTestCase.assertNull((Object)this.getUtil().getContext("OriginalBean"));
        PlainAliasTestCase.assertNull((Object)this.getUtil().getContext("MyAlias"));
        context1 = this.assertInstall(0, "OriginalBean");
        directAlias = this.assertContext("MyAlias_Alias");
        PlainAliasTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)directAlias.getState());
        PlainAliasTestCase.assertEquals((Object)context1, (Object)this.assertContext("MyAlias"));
        this.assertUninstall("MyAlias_Alias");
        PlainAliasTestCase.assertEquals((Object)ControllerState.ERROR, (Object)directAlias.getState());
        PlainAliasTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context1.getState());
        PlainAliasTestCase.assertNull((Object)this.getUtil().getContext("MyAlias"));
        this.checkLastSimpleAliasInstall(context1);
    }

    protected ControllerState getDirectAliasUnistallState() {
        return ControllerState.START;
    }

    protected void checkLastSimpleAliasInstall(ControllerContext context) throws Throwable {
        this.installAlias();
        PlainAliasTestCase.assertEquals((Object)context, (Object)this.assertContext("MyAlias"));
    }

    protected void buildMetaData() throws Throwable {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("OriginalBean", SimpleBeanImpl.class.getName());
        HashSet<AbstractPropertyMetaData> attributes1 = new HashSet<AbstractPropertyMetaData>();
        attributes1.add(new AbstractPropertyMetaData("string", "String1"));
        metaData1.setProperties(attributes1);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1});
    }

    protected void installAlias() throws Throwable {
        KernelController controller = this.getUtil().getKernel().getController();
        controller.addAlias((Object)"MyAlias", (Object)"OriginalBean");
    }
}

