/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.net.URL;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.test.kernel.dependency.support.TestUtil;
import org.jboss.util.Classes;

public class OldAbstractKernelDependencyTest
extends AbstractKernelTest {
    private TestUtil util;
    private boolean xmltest;
    private BeanMetaData[] beanMetaDatas;

    public OldAbstractKernelDependencyTest(String name) throws Throwable {
        this(name, false);
    }

    public OldAbstractKernelDependencyTest(String name, boolean xmltest) throws Throwable {
        super(name);
        this.xmltest = xmltest;
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            Kernel kernel = this.bootstrap();
            this.util = new TestUtil(kernel, this);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected TestUtil getUtil() {
        return this.util;
    }

    protected ControllerContext install(int number, String name) throws Throwable {
        if (this.xmltest) {
            this.deploy(number);
            return this.util.getContext(name);
        }
        return this.util.install(this.beanMetaDatas[number]);
    }

    protected void uninstall(String name) throws Throwable {
        this.util.uninstall(name);
    }

    protected ControllerContext assertInstall(int number, String name) throws Throwable {
        ControllerContext result = this.assertInstall(number, name, ControllerState.INSTALLED);
        this.assertContext(name);
        return result;
    }

    protected ControllerContext assertInstall(int number, String name, ControllerState expected) throws Throwable {
        ControllerContext context = this.install(number, name);
        OldAbstractKernelDependencyTest.assertNotNull((Object)context);
        OldAbstractKernelDependencyTest.assertEquals((Object)expected, (Object)context.getState());
        return context;
    }

    protected ControllerContext assertContext(String name) throws Throwable {
        return this.assertContext(name, ControllerState.INSTALLED);
    }

    protected ControllerContext assertContext(String name, ControllerState expected) throws Throwable {
        ControllerContext context = this.util.getContext(name);
        OldAbstractKernelDependencyTest.assertNotNull((String)("Expected " + name + " state=" + expected.toShortString()), (Object)context);
        OldAbstractKernelDependencyTest.assertEquals((Object)expected, (Object)context.getState());
        return context;
    }

    protected void assertUninstall(String name) throws Throwable {
        this.uninstall(name);
        this.assertNotInstalled(name);
        ControllerContext context = this.util.getContext(name);
        OldAbstractKernelDependencyTest.assertNull((Object)context);
    }

    protected void assertNotInstalled(String name) throws Throwable {
        if (this.util.getInstalledContext(name) != null) {
            OldAbstractKernelDependencyTest.fail((String)"Should not be installed");
        }
    }

    protected void setBeanMetaDatas(BeanMetaData[] beanMetaDatas) {
        if (this.xmltest) {
            return;
        }
        this.beanMetaDatas = beanMetaDatas;
    }

    protected String createName(int number) {
        String packageName = Classes.getPackageName(((Object)((Object)this)).getClass());
        packageName = packageName.replace('.', '/');
        return "/xml-test/" + packageName + '/' + this.getName() + number + ".xml";
    }

    protected void deploy(int number) throws Throwable {
        String name = this.createName(number);
        this.getLog().debug((Object)("Using " + name));
        URL url = this.getResource(name);
        if (url == null) {
            throw new RuntimeException("Resource not found: " + name);
        }
        this.getLog().debug((Object)("url=" + url));
        this.util.deploy(url);
    }

    protected void configureLoggingAfterBootstrap() {
    }
}

