/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.ArrayList;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.test.kernel.dependency.support.SimpleBeanInstallSelf;
import org.jboss.test.kernel.dependency.test.AbstractKernelDependencyTest;

public class InstallSelfDependencyTestCase
extends AbstractKernelDependencyTest {
    public static Test suite() {
        return InstallSelfDependencyTestCase.suite(InstallSelfDependencyTestCase.class);
    }

    public InstallSelfDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public InstallSelfDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testInstallSelfDependencyCorrectOrder() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context = this.assertInstall(0, "Name1");
        SimpleBeanInstallSelf bean = (SimpleBeanInstallSelf)context.getTarget();
        InstallSelfDependencyTestCase.assertNotNull((Object)bean);
        InstallSelfDependencyTestCase.assertTrue((boolean)bean.getInstalled());
    }

    public void testInstallSelfDependencyReinstall() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context = this.assertInstall(0, "Name1");
        SimpleBeanInstallSelf bean = (SimpleBeanInstallSelf)context.getTarget();
        InstallSelfDependencyTestCase.assertNotNull((Object)bean);
        InstallSelfDependencyTestCase.assertTrue((boolean)bean.getInstalled());
        this.assertUninstall("Name1");
        InstallSelfDependencyTestCase.assertFalse((boolean)bean.getInstalled());
        context = this.assertInstall(0, "Name1");
        bean = (SimpleBeanInstallSelf)context.getTarget();
        InstallSelfDependencyTestCase.assertNotNull((Object)bean);
        InstallSelfDependencyTestCase.assertTrue((boolean)bean.getInstalled());
    }

    protected void setupBeanMetaDatas() throws Throwable {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("Name1", SimpleBeanInstallSelf.class.getName());
        ArrayList<AbstractInstallMetaData> installs = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData install = new AbstractInstallMetaData();
        install.setMethodName("install");
        installs.add(install);
        metaData1.setInstalls(installs);
        ArrayList<AbstractInstallMetaData> uninstalls = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData uninstall = new AbstractInstallMetaData();
        uninstall.setMethodName("uninstall");
        uninstalls.add(uninstall);
        metaData1.setUninstalls(uninstalls);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1});
    }
}

