/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactoryMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithDependency;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithDependencyImpl;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class GenericBeanFactoryPlainDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return GenericBeanFactoryPlainDependencyTestCase.suite(GenericBeanFactoryPlainDependencyTestCase.class);
    }

    public GenericBeanFactoryPlainDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public GenericBeanFactoryPlainDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testGenericBeanFactoryDependencyCorrectOrder() throws Throwable {
        this.genericBeanFactoryDependencyCorrectOrder();
        this.assertInstall(0, "simple");
        ControllerContext context2 = this.assertInstall(1, "aspect");
        GenericBeanFactory factory = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithDependency bean = (SimpleBeanWithDependency)factory.createBean();
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((String)"factory", (String)bean.getString());
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((String)"String1", (String)bean.getSimpleBean().getString());
    }

    public void genericBeanFactoryDependencyCorrectOrder() {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryDependencyWrongOrder() throws Throwable {
        this.genericBeanFactoryDependencyWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "aspect", ControllerState.INSTANTIATED);
        this.assertInstall(0, "simple");
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        GenericBeanFactory factory = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithDependency bean = (SimpleBeanWithDependency)factory.createBean();
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((String)"factory", (String)bean.getString());
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((String)"String1", (String)bean.getSimpleBean().getString());
    }

    public void genericBeanFactoryDependencyWrongOrder() {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryDependencyReinstall() throws Throwable {
        this.genericBeanFactoryDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "simple");
        ControllerContext context2 = this.assertInstall(1, "aspect");
        GenericBeanFactory factory = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithDependency bean = (SimpleBeanWithDependency)factory.createBean();
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((String)"factory", (String)bean.getString());
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((String)"String1", (String)bean.getSimpleBean().getString());
        this.assertUninstall("simple");
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((Object)ControllerState.INSTANTIATED, (Object)context2.getState());
        context1 = this.assertInstall(0, "simple");
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        factory = (GenericBeanFactory)context2.getTarget();
        bean = (SimpleBeanWithDependency)factory.createBean();
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((String)"factory", (String)bean.getString());
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((String)"String1", (String)bean.getSimpleBean().getString());
        this.assertUninstall("aspect");
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context1.getState());
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context2.getState());
        context2 = this.assertInstall(1, "aspect");
        factory = (GenericBeanFactory)context2.getTarget();
        bean = (SimpleBeanWithDependency)factory.createBean();
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((String)"factory", (String)bean.getString());
        GenericBeanFactoryPlainDependencyTestCase.assertEquals((String)"String1", (String)bean.getSimpleBean().getString());
    }

    public void genericBeanFactoryDependencyReinstall() {
        this.buildMetaData();
    }

    protected void buildMetaData() {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("simple", SimpleBeanImpl.class.getName());
        HashSet<AbstractPropertyMetaData> attributes1 = new HashSet<AbstractPropertyMetaData>();
        attributes1.add(new AbstractPropertyMetaData("string", "String1"));
        metaData1.setProperties(attributes1);
        GenericBeanFactoryMetaData metaData2 = new GenericBeanFactoryMetaData("aspect");
        metaData2.addProperty((PropertyMetaData)new AbstractPropertyMetaData("bean", SimpleBeanWithDependencyImpl.class.getName()));
        metaData2.addProperty((PropertyMetaData)new AbstractPropertyMetaData("constructor", (Object)new AbstractConstructorMetaData()));
        metaData2.addBeanProperty((PropertyMetaData)new AbstractPropertyMetaData("simpleBean", (ValueMetaData)new AbstractDependencyValueMetaData((Object)"simple")));
        metaData2.addBeanProperty((PropertyMetaData)new AbstractPropertyMetaData("string", (ValueMetaData)new AbstractValueMetaData((Object)"factory")));
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }
}

