/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractArrayMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class ConstructorClassLoaderTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return ConstructorClassLoaderTestCase.suite(ConstructorClassLoaderTestCase.class);
    }

    public ConstructorClassLoaderTestCase(String name) throws Throwable {
        super(name);
    }

    public ConstructorClassLoaderTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testConstructorClassLoaderCorrectOrder() throws Throwable {
        this.constructorClassLoaderCorrectOrder();
        this.assertInstall(3, "URL");
        ControllerContext clCtx = this.assertInstall(0, "VFSClassLoader");
        ControllerContext bean1Ctx = this.assertInstall(1, "VFSBean1");
        ControllerContext bean2Ctx = this.assertInstall(2, "VFSBean2");
        Object clTarget = clCtx.getTarget();
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)clTarget.getClass().getName());
        ClassLoader cl0 = clTarget.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertNotSame((Object)"org.jboss.test.classloading.vfs.VFSClassLoader", (Object)cl0.getClass().getName());
        Object bean2 = bean2Ctx.getTarget();
        ClassLoader cl2 = bean2.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertEquals((Object)clTarget, (Object)cl2);
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)cl2.getClass().getName());
        Object bean1 = bean1Ctx.getTarget();
        ClassLoader cl1 = bean1.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertEquals((Object)clTarget, (Object)cl1);
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)cl1.getClass().getName());
    }

    public void constructorClassLoaderCorrectOrder() throws Throwable {
        AbstractBeanMetaData metaData3 = new AbstractBeanMetaData("URL", "java.net.URL");
        AbstractConstructorMetaData cmd3 = new AbstractConstructorMetaData();
        metaData3.setConstructor((ConstructorMetaData)cmd3);
        cmd3.setFactoryClass("org.jboss.test.classloading.vfs.ClassLoaderUtil");
        cmd3.setFactoryMethod("getLocation");
        AbstractParameterMetaData pmd3 = new AbstractParameterMetaData((Object)((Object)((Object)this)).getClass().getName());
        ArrayList<AbstractParameterMetaData> params3 = new ArrayList<AbstractParameterMetaData>();
        params3.add(pmd3);
        cmd3.setParameters(params3);
        AbstractDependencyValueMetaData url = new AbstractDependencyValueMetaData((Object)"URL");
        AbstractBeanMetaData metaData0 = new AbstractBeanMetaData("VFSClassLoader", "org.jboss.test.classloading.vfs.VFSClassLoader");
        AbstractConstructorMetaData clCMD = new AbstractConstructorMetaData();
        AbstractArrayMetaData array = new AbstractArrayMetaData();
        array.add((MetaDataVisitorNode)url);
        AbstractParameterMetaData urls = new AbstractParameterMetaData(null, (ValueMetaData)array);
        ArrayList<AbstractParameterMetaData> constructor0 = new ArrayList<AbstractParameterMetaData>();
        constructor0.add(urls);
        clCMD.setParameters(constructor0);
        clCMD.setFactoryClass("org.jboss.test.classloading.vfs.VFSClassLoaderFactory");
        clCMD.setFactoryMethod("newClassLoader");
        metaData0.setConstructor((ConstructorMetaData)clCMD);
        AbstractDependencyValueMetaData vfsCL = new AbstractDependencyValueMetaData((Object)"VFSClassLoader");
        String bean1Type = "org.jboss.test.kernel.dependency.classloader.SimpleBeanImpl";
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("VFSBean1", bean1Type);
        HashSet<AbstractPropertyMetaData> attributes1 = new HashSet<AbstractPropertyMetaData>();
        attributes1.add(new AbstractPropertyMetaData("string", "String1"));
        metaData1.setProperties(attributes1);
        metaData1.setClassLoader((ClassLoaderMetaData)new AbstractClassLoaderMetaData((ValueMetaData)vfsCL));
        AbstractBeanMetaData metaData2 = new AbstractBeanMetaData("VFSBean2", "org.jboss.test.kernel.dependency.classloader.SimpleBeanWithConstructorClassLoaderImpl");
        HashSet<AbstractPropertyMetaData> attributes2 = new HashSet<AbstractPropertyMetaData>();
        attributes2.add(new AbstractPropertyMetaData("string", "String2"));
        metaData2.setProperties(attributes2);
        metaData2.setClassLoader((ClassLoaderMetaData)new AbstractClassLoaderMetaData((ValueMetaData)vfsCL));
        ArrayList<AbstractParameterMetaData> constructor2 = new ArrayList<AbstractParameterMetaData>();
        String bean1Iface = "org.jboss.test.kernel.dependency.classloader.SimpleBean";
        AbstractDependencyValueMetaData bean2Depends = new AbstractDependencyValueMetaData((Object)"VFSBean1");
        AbstractParameterMetaData param = new AbstractParameterMetaData(bean1Iface, (ValueMetaData)bean2Depends);
        constructor2.add(param);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        metaData2.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructor2);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData0, metaData1, metaData2, metaData3});
    }

    public void testConstructorClassLoaderWrongOrder() throws Throwable {
        this.constructorClassLoaderWrongOrder();
        this.assertInstall(3, "URL");
        ControllerContext bean1Ctx = this.assertInstall(1, "VFSBean1", ControllerState.NOT_INSTALLED);
        ControllerContext bean2Ctx = this.assertInstall(2, "VFSBean2", ControllerState.NOT_INSTALLED);
        ControllerContext clCtx = this.assertInstall(0, "VFSClassLoader");
        ConstructorClassLoaderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)bean1Ctx.getState());
        ConstructorClassLoaderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)bean2Ctx.getState());
        Object clTarget = clCtx.getTarget();
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)clTarget.getClass().getName());
        ClassLoader cl0 = clTarget.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertNotSame((Object)"org.jboss.test.classloading.vfs.VFSClassLoader", (Object)cl0.getClass().getName());
        Object bean2 = bean2Ctx.getTarget();
        ClassLoader cl2 = bean2.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertEquals((Object)clTarget, (Object)cl2);
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)cl2.getClass().getName());
        Object bean1 = bean1Ctx.getTarget();
        ClassLoader cl1 = bean1.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertEquals((Object)clTarget, (Object)cl1);
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)cl1.getClass().getName());
    }

    public void constructorClassLoaderWrongOrder() throws Throwable {
        AbstractBeanMetaData metaData3 = new AbstractBeanMetaData("URL", "java.net.URL");
        AbstractConstructorMetaData cmd3 = new AbstractConstructorMetaData();
        metaData3.setConstructor((ConstructorMetaData)cmd3);
        cmd3.setFactoryClass("org.jboss.test.classloading.vfs.ClassLoaderUtil");
        cmd3.setFactoryMethod("getLocation");
        AbstractParameterMetaData pmd3 = new AbstractParameterMetaData((Object)((Object)((Object)this)).getClass().getName());
        ArrayList<AbstractParameterMetaData> params3 = new ArrayList<AbstractParameterMetaData>();
        params3.add(pmd3);
        cmd3.setParameters(params3);
        AbstractDependencyValueMetaData url = new AbstractDependencyValueMetaData((Object)"URL");
        AbstractBeanMetaData metaData0 = new AbstractBeanMetaData("VFSClassLoader", "org.jboss.test.classloading.vfs.VFSClassLoader");
        AbstractConstructorMetaData clCMD = new AbstractConstructorMetaData();
        AbstractArrayMetaData array = new AbstractArrayMetaData();
        array.add((MetaDataVisitorNode)url);
        AbstractParameterMetaData urls = new AbstractParameterMetaData(null, (ValueMetaData)array);
        ArrayList<AbstractParameterMetaData> constructor0 = new ArrayList<AbstractParameterMetaData>();
        constructor0.add(urls);
        clCMD.setParameters(constructor0);
        clCMD.setFactoryClass("org.jboss.test.classloading.vfs.VFSClassLoaderFactory");
        clCMD.setFactoryMethod("newClassLoader");
        metaData0.setConstructor((ConstructorMetaData)clCMD);
        AbstractDependencyValueMetaData vfsCL = new AbstractDependencyValueMetaData((Object)"VFSClassLoader");
        String bean1Type = "org.jboss.test.kernel.dependency.classloader.SimpleBeanImpl";
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("VFSBean1", bean1Type);
        HashSet<AbstractPropertyMetaData> attributes1 = new HashSet<AbstractPropertyMetaData>();
        attributes1.add(new AbstractPropertyMetaData("string", "String1"));
        metaData1.setProperties(attributes1);
        metaData1.setClassLoader((ClassLoaderMetaData)new AbstractClassLoaderMetaData((ValueMetaData)vfsCL));
        AbstractBeanMetaData metaData2 = new AbstractBeanMetaData("VFSBean2", "org.jboss.test.kernel.dependency.classloader.SimpleBeanWithConstructorClassLoaderImpl");
        HashSet<AbstractPropertyMetaData> attributes2 = new HashSet<AbstractPropertyMetaData>();
        attributes2.add(new AbstractPropertyMetaData("string", "String2"));
        metaData2.setProperties(attributes2);
        metaData2.setClassLoader((ClassLoaderMetaData)new AbstractClassLoaderMetaData((ValueMetaData)vfsCL));
        ArrayList<AbstractParameterMetaData> constructor2 = new ArrayList<AbstractParameterMetaData>();
        String bean1Iface = "org.jboss.test.kernel.dependency.classloader.SimpleBean";
        AbstractDependencyValueMetaData bean2Depends = new AbstractDependencyValueMetaData((Object)"VFSBean1");
        AbstractParameterMetaData param = new AbstractParameterMetaData(bean1Iface, (ValueMetaData)bean2Depends);
        constructor2.add(param);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        metaData2.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructor2);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData0, metaData1, metaData2, metaData3});
    }

    public void testConstructorClassLoaderReinstall() throws Throwable {
        this.constructorClassLoaderReinstall();
        this.assertInstall(3, "URL");
        ControllerContext clCtx = this.assertInstall(0, "VFSClassLoader");
        ControllerContext bean1Ctx = this.assertInstall(1, "VFSBean1");
        ControllerContext bean2Ctx = this.assertInstall(2, "VFSBean2");
        Object clTarget = clCtx.getTarget();
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)clTarget.getClass().getName());
        ClassLoader cl0 = clTarget.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertNotSame((Object)"org.jboss.test.classloading.vfs.VFSClassLoader", (Object)cl0.getClass().getName());
        Object bean2 = bean2Ctx.getTarget();
        ClassLoader cl2 = bean2.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertEquals((Object)clTarget, (Object)cl2);
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)cl2.getClass().getName());
        Object bean1 = bean1Ctx.getTarget();
        ClassLoader cl1 = bean1.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertEquals((Object)clTarget, (Object)cl1);
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)cl1.getClass().getName());
        this.assertUninstall("VFSClassLoader");
        ConstructorClassLoaderTestCase.assertEquals((Object)ControllerState.ERROR, (Object)clCtx.getState());
        ConstructorClassLoaderTestCase.assertEquals((Object)ControllerState.NOT_INSTALLED, (Object)bean1Ctx.getState());
        ConstructorClassLoaderTestCase.assertEquals((Object)ControllerState.NOT_INSTALLED, (Object)bean2Ctx.getState());
        clCtx = this.assertInstall(0, "VFSClassLoader");
        ConstructorClassLoaderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)bean1Ctx.getState());
        ConstructorClassLoaderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)bean2Ctx.getState());
        clTarget = clCtx.getTarget();
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)clTarget.getClass().getName());
        cl0 = clTarget.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertNotSame((Object)"org.jboss.test.classloading.vfs.VFSClassLoader", (Object)cl0.getClass().getName());
        bean2 = bean2Ctx.getTarget();
        cl2 = bean2.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertEquals((Object)clTarget, (Object)cl2);
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)cl2.getClass().getName());
        bean1 = bean1Ctx.getTarget();
        cl1 = bean1.getClass().getClassLoader();
        ConstructorClassLoaderTestCase.assertEquals((Object)clTarget, (Object)cl1);
        ConstructorClassLoaderTestCase.assertEquals((String)"org.jboss.test.classloading.vfs.VFSClassLoader", (String)cl1.getClass().getName());
    }

    public void constructorClassLoaderReinstall() throws Throwable {
        AbstractBeanMetaData metaData3 = new AbstractBeanMetaData("URL", "java.net.URL");
        AbstractConstructorMetaData cmd3 = new AbstractConstructorMetaData();
        metaData3.setConstructor((ConstructorMetaData)cmd3);
        cmd3.setFactoryClass("org.jboss.test.classloading.vfs.ClassLoaderUtil");
        cmd3.setFactoryMethod("getLocation");
        AbstractParameterMetaData pmd3 = new AbstractParameterMetaData((Object)((Object)((Object)this)).getClass().getName());
        ArrayList<AbstractParameterMetaData> params3 = new ArrayList<AbstractParameterMetaData>();
        params3.add(pmd3);
        cmd3.setParameters(params3);
        AbstractDependencyValueMetaData url = new AbstractDependencyValueMetaData((Object)"URL");
        AbstractBeanMetaData metaData0 = new AbstractBeanMetaData("VFSClassLoader", "org.jboss.test.classloading.vfs.VFSClassLoader");
        AbstractConstructorMetaData clCMD = new AbstractConstructorMetaData();
        AbstractArrayMetaData array = new AbstractArrayMetaData();
        array.add((MetaDataVisitorNode)url);
        AbstractParameterMetaData urls = new AbstractParameterMetaData(null, (ValueMetaData)array);
        ArrayList<AbstractParameterMetaData> constructor0 = new ArrayList<AbstractParameterMetaData>();
        constructor0.add(urls);
        clCMD.setParameters(constructor0);
        clCMD.setFactoryClass("org.jboss.test.classloading.vfs.VFSClassLoaderFactory");
        clCMD.setFactoryMethod("newClassLoader");
        metaData0.setConstructor((ConstructorMetaData)clCMD);
        AbstractDependencyValueMetaData vfsCL = new AbstractDependencyValueMetaData((Object)"VFSClassLoader");
        String bean1Type = "org.jboss.test.kernel.dependency.classloader.SimpleBeanImpl";
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("VFSBean1", bean1Type);
        HashSet<AbstractPropertyMetaData> attributes1 = new HashSet<AbstractPropertyMetaData>();
        attributes1.add(new AbstractPropertyMetaData("string", "String1"));
        metaData1.setProperties(attributes1);
        metaData1.setClassLoader((ClassLoaderMetaData)new AbstractClassLoaderMetaData((ValueMetaData)vfsCL));
        AbstractBeanMetaData metaData2 = new AbstractBeanMetaData("VFSBean2", "org.jboss.test.kernel.dependency.classloader.SimpleBeanWithConstructorClassLoaderImpl");
        HashSet<AbstractPropertyMetaData> attributes2 = new HashSet<AbstractPropertyMetaData>();
        attributes2.add(new AbstractPropertyMetaData("string", "String2"));
        metaData2.setProperties(attributes2);
        metaData2.setClassLoader((ClassLoaderMetaData)new AbstractClassLoaderMetaData((ValueMetaData)vfsCL));
        ArrayList<AbstractParameterMetaData> constructor2 = new ArrayList<AbstractParameterMetaData>();
        String bean1Iface = "org.jboss.test.kernel.dependency.classloader.SimpleBean";
        AbstractDependencyValueMetaData bean2Depends = new AbstractDependencyValueMetaData((Object)"VFSBean1");
        AbstractParameterMetaData param = new AbstractParameterMetaData(bean1Iface, (ValueMetaData)bean2Depends);
        constructor2.add(param);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        metaData2.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructor2);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData0, metaData1, metaData2, metaData3});
    }
}

