/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractSetMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.test.kernel.config.support.CustomSet;
import org.jboss.test.kernel.config.support.MyObject;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.support.UnmodifiableGetterBean;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class SetTestCase
extends AbstractKernelConfigTest {
    MyObject object1 = new MyObject("object1");
    MyObject object2 = new MyObject("object2");
    String string1 = "string1";
    String string2 = "string2";

    public static Test suite() {
        return SetTestCase.suite(SetTestCase.class);
    }

    public SetTestCase(String name) {
        super(name);
    }

    public SetTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public void testSimpleSetFromObjects() throws Throwable {
        SimpleBean bean = this.simpleSetFromObjects();
        SetTestCase.assertNotNull((Object)bean);
        Set result = bean.getSet();
        SetTestCase.assertNotNull((String)"Should be a set", (Object)result);
        HashSet<MyObject> expected = new HashSet<MyObject>();
        expected.add(this.object1);
        expected.add(this.object2);
        expected.add(this.object2);
        expected.add(this.object1);
        SetTestCase.assertEquals(expected, (Object)result);
    }

    public SimpleBean simpleSetFromObjects() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        AbstractValueMetaData vmd1 = new AbstractValueMetaData((Object)this.object1);
        AbstractValueMetaData vmd2 = new AbstractValueMetaData((Object)this.object2);
        AbstractValueMetaData vmd3 = new AbstractValueMetaData((Object)this.object1);
        AbstractSetMetaData smd = new AbstractSetMetaData();
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("set", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure((BeanMetaData)bmd);
    }

    public void testSimpleSetFromStrings() throws Throwable {
        SimpleBean bean = this.simpleSetFromStrings();
        SetTestCase.assertNotNull((Object)bean);
        Set result = bean.getSet();
        SetTestCase.assertNotNull((String)"Should be a set", (Object)result);
        HashSet<String> expected = new HashSet<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        SetTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean simpleSetFromStrings() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractSetMetaData smd = new AbstractSetMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("set", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomSetExplicit() throws Throwable {
        SimpleBean bean = this.customSetExplicit();
        SetTestCase.assertNotNull((Object)bean);
        Set result = bean.getSet();
        SetTestCase.assertNotNull((String)"Should be a set", (Object)result);
        SetTestCase.assertTrue((String)("Not a CustomSet: " + result.getClass()), (boolean)(result instanceof CustomSet));
        HashSet<String> expected = new HashSet<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        SetTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean customSetExplicit() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractSetMetaData smd = new AbstractSetMetaData();
        smd.setType(CustomSet.class.getName());
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("set", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomSetFromSignature() throws Throwable {
        SimpleBean bean = this.customSetFromSignature();
        SetTestCase.assertNotNull((Object)bean);
        CustomSet result = bean.getCustomSet();
        SetTestCase.assertNotNull((String)"Should be a set", (Object)result);
        SetTestCase.assertTrue((String)("Not a CustomSet: " + result.getClass()), (boolean)(result instanceof CustomSet));
        HashSet<String> expected = new HashSet<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        SetTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean customSetFromSignature() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractSetMetaData smd = new AbstractSetMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("customSet", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomSetPreInstantiated() throws Throwable {
        SimpleBean bean = this.customSetPreInstantiated();
        SetTestCase.assertNotNull((Object)bean);
        CustomSet result = bean.getPreInstantiatedSet();
        SetTestCase.assertNotNull((String)"Should be a set", (Object)result);
        SetTestCase.assertTrue((String)("Not a CustomSet: " + result.getClass()), (boolean)(result instanceof CustomSet));
        SetTestCase.assertTrue((String)"Not preinstantiated", (boolean)result.getPreInstantiated());
        HashSet<String> expected = new HashSet<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        SetTestCase.assertEquals(expected, (Object)result);
        Set setter = bean.setterSet;
        SetTestCase.assertNotNull((Object)setter);
        SetTestCase.assertFalse((String)"Empty setterSet", (boolean)setter.isEmpty());
    }

    protected SimpleBean customSetPreInstantiated() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("test1", SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractSetMetaData smd = new AbstractSetMetaData();
        smd.setElementType("java.lang.String");
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("preInstantiatedSet", (ValueMetaData)smd);
        properties.add(pmd);
        AbstractSetMetaData lmd = new AbstractSetMetaData();
        lmd.setElementType("java.lang.String");
        lmd.add((MetaDataVisitorNode)new StringValueMetaData("element"));
        AbstractPropertyMetaData pmd2 = new AbstractPropertyMetaData("setterSet", (ValueMetaData)lmd);
        properties.add(pmd2);
        return (SimpleBean)this.instantiate(controller, (BeanMetaData)bmd);
    }

    public void testUnmodifiableSetPreInstantiated() throws Throwable {
        UnmodifiableGetterBean bean = this.unmodifiableSetPreInstantiated();
        SetTestCase.assertNotNull((Object)bean);
        Set result = bean.getSet();
        SetTestCase.assertNotNull((String)"Should be a set", (Object)result);
        HashSet<String> expected = new HashSet<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        SetTestCase.assertEquals(expected, (Object)result);
    }

    protected UnmodifiableGetterBean unmodifiableSetPreInstantiated() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("test1", UnmodifiableGetterBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractSetMetaData smd = new AbstractSetMetaData();
        smd.setElementType("java.lang.String");
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("set", (ValueMetaData)smd);
        pmd.setPreInstantiate(false);
        properties.add(pmd);
        return (UnmodifiableGetterBean)this.instantiate(controller, (BeanMetaData)bmd);
    }

    public void testSetWithValueTypeOverride() throws Throwable {
        SimpleBean bean = this.setWithValueTypeOverride();
        SetTestCase.assertNotNull((Object)bean);
        Set result = bean.getSet();
        SetTestCase.assertNotNull((String)"Should be a set", (Object)result);
        SetTestCase.assertTrue((String)("Not a CustomSet: " + result.getClass()), (boolean)(result instanceof CustomSet));
        HashSet<Object> expected = new HashSet<Object>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        expected.add(new Integer(1));
        SetTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean setWithValueTypeOverride() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd4 = new StringValueMetaData("1");
        vmd4.setConfigurator(configurator);
        vmd4.setType("java.lang.Integer");
        AbstractSetMetaData smd = new AbstractSetMetaData();
        smd.setType(CustomSet.class.getName());
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        smd.add((MetaDataVisitorNode)vmd4);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("set", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testSetNotASet() throws Throwable {
        try {
            this.setNotASet();
            SetTestCase.fail((String)"Expected a failure trying to set a set on a non set attribute");
        }
        catch (Exception expected) {
            this.checkSetNotASetException(expected);
        }
    }

    protected void checkSetNotASetException(Exception exception) {
        SetTestCase.checkThrowable(ClassCastException.class, (Throwable)exception);
    }

    protected SimpleBean setNotASet() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractSetMetaData smd = new AbstractSetMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("AString", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testSetIsInterface() throws Throwable {
        try {
            this.setIsInterface();
            SetTestCase.fail((String)"Expected a failure trying to use an interface for the set type");
        }
        catch (Exception expected) {
            this.checkSetIsInterfaceException(expected);
        }
    }

    protected void checkSetIsInterfaceException(Exception exception) {
        SetTestCase.checkThrowable(IllegalArgumentException.class, (Throwable)exception);
    }

    protected SimpleBean setIsInterface() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractSetMetaData smd = new AbstractSetMetaData();
        smd.setType("java.util.Set");
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("set", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }
}

