/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractAnnotationMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.test.kernel.config.support.SimpleAnnotation;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyReplaceTestCase
extends AbstractKernelConfigTest {
    private static final String PROP_NAME = "test.property.value";
    private static final String BRACKET_PROP_NAME = "${test.property.value}";
    private static final String CONST = "PropertyReplaceTestCase";

    public PropertyReplaceTestCase(String name) {
        super(name);
    }

    public PropertyReplaceTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public static Test suite() {
        return PropertyReplaceTestCase.suite(PropertyReplaceTestCase.class);
    }

    private List<ObjectCreator> singlePropertyCreator(final boolean replace) {
        ObjectCreator oc = new ObjectCreator(){

            public Object createObject() throws Throwable {
                return PropertyReplaceTestCase.this.instantiateReplacePropertyValue(replace);
            }
        };
        return Collections.singletonList(oc);
    }

    public void testPropertyWithPropertyValue() throws Throwable {
        this.doTestProperty(true, this.singlePropertyCreator(true));
    }

    public void testPropertyWithIgnoreReplace() throws Throwable {
        this.doTestProperty(false, this.createCreators());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationPropertyReplace() throws Throwable {
        SecurityManager sm = PropertyReplaceTestCase.suspendSecurity();
        try {
            SimpleAnnotation replAnn = this.instantiateAnnotation(true);
            PropertyReplaceTestCase.assertEquals((String)"test.PropertyReplaceTestCase.Name", (String)replAnn.name());
            SimpleAnnotation ignAnn = this.instantiateAnnotation(false);
            PropertyReplaceTestCase.assertEquals((String)"test.${test.property.value}.Name", (String)ignAnn.name());
        }
        finally {
            PropertyReplaceTestCase.resumeSecurity((SecurityManager)sm);
        }
    }

    protected SimpleAnnotation instantiateAnnotation(boolean replace) throws Throwable {
        AbstractAnnotationMetaData annotation = new AbstractAnnotationMetaData();
        annotation.setAnnotation("@org.jboss.test.kernel.config.support.SimpleAnnotation(name = \"test.${test.property.value}.Name\")");
        annotation.setReplace(replace);
        return (SimpleAnnotation)annotation.getAnnotationInstance();
    }

    protected List<ObjectCreator> createCreators() {
        return this.singlePropertyCreator(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestProperty(boolean replace, List<ObjectCreator> ocs) throws Throwable {
        SecurityManager sm = PropertyReplaceTestCase.suspendSecurity();
        try {
            System.setProperty(PROP_NAME, CONST);
            for (ObjectCreator oc : ocs) {
                Object value = oc.createObject();
                PropertyReplaceTestCase.assertNotNull((Object)value);
                PropertyReplaceTestCase.assertEquals(String.class, value.getClass());
                String checkValue = replace ? CONST : BRACKET_PROP_NAME;
                PropertyReplaceTestCase.assertEquals((Object)checkValue, (Object)value);
            }
        }
        finally {
            PropertyReplaceTestCase.resumeSecurity((SecurityManager)sm);
        }
    }

    protected Object instantiateReplacePropertyValue(boolean replace) throws Throwable {
        AbstractPropertyMetaData property = new AbstractPropertyMetaData("key", BRACKET_PROP_NAME, String.class.getName());
        StringValueMetaData svmd = (StringValueMetaData)this.assertInstanceOf(property.getValue(), StringValueMetaData.class, false);
        svmd.setReplace(replace);
        svmd.setConfigurator(this.bootstrap().getConfigurator());
        return svmd.getValue(null, Thread.currentThread().getContextClassLoader());
    }

    protected static interface ObjectCreator {
        public Object createObject() throws Throwable;
    }
}

