/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractMapMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.test.kernel.config.support.CustomMap;
import org.jboss.test.kernel.config.support.MyObject;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.support.UnmodifiableGetterBean;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class MapTestCase
extends AbstractKernelConfigTest {
    MyObject object1 = new MyObject("object1");
    MyObject object2 = new MyObject("object2");
    String string1 = "string1";
    String string2 = "string2";
    String integer = "integer";

    public static Test suite() {
        return MapTestCase.suite(MapTestCase.class);
    }

    public MapTestCase(String name) {
        super(name);
    }

    public MapTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public void testSimpleMapFromObjects() throws Throwable {
        SimpleBean bean = this.simpleMapFromObjects();
        MapTestCase.assertNotNull((Object)bean);
        Map result = bean.getMap();
        MapTestCase.assertNotNull((String)"Should be a map", (Object)result);
        HashMap<MyObject, MyObject> expected = new HashMap<MyObject, MyObject>();
        expected.put(this.object1, this.object2);
        expected.put(this.object2, this.object1);
        MapTestCase.assertEquals(expected, (Object)result);
    }

    public SimpleBean simpleMapFromObjects() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        AbstractValueMetaData key1 = new AbstractValueMetaData((Object)this.object1);
        AbstractValueMetaData value1 = new AbstractValueMetaData((Object)this.object2);
        AbstractValueMetaData key2 = new AbstractValueMetaData((Object)this.object2);
        AbstractValueMetaData value2 = new AbstractValueMetaData((Object)this.object1);
        AbstractMapMetaData smd = new AbstractMapMetaData();
        smd.put((MetaDataVisitorNode)key1, (MetaDataVisitorNode)value1);
        smd.put((MetaDataVisitorNode)key2, (MetaDataVisitorNode)value2);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("map", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure((BeanMetaData)bmd);
    }

    public void testSimpleMapFromStrings() throws Throwable {
        SimpleBean bean = this.simpleMapFromStrings();
        MapTestCase.assertNotNull((Object)bean);
        Map result = bean.getMap();
        MapTestCase.assertNotNull((String)"Should be a map", (Object)result);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(this.string1, this.string2);
        expected.put(this.string2, this.string1);
        MapTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean simpleMapFromStrings() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData kmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData kmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string1);
        AbstractMapMetaData smd = new AbstractMapMetaData();
        smd.setKeyType("java.lang.String");
        smd.setValueType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.put((MetaDataVisitorNode)kmd1, (MetaDataVisitorNode)vmd1);
        smd.put((MetaDataVisitorNode)kmd2, (MetaDataVisitorNode)vmd2);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("map", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomMapExplicit() throws Throwable {
        SimpleBean bean = this.customMapExplicit();
        MapTestCase.assertNotNull((Object)bean);
        Map result = bean.getMap();
        MapTestCase.assertNotNull((String)"Should be a map", (Object)result);
        MapTestCase.assertTrue((String)("Not a CustomMap: " + result.getClass()), (boolean)(result instanceof CustomMap));
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(this.string1, this.string2);
        expected.put(this.string2, this.string1);
        MapTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean customMapExplicit() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData kmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData kmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string1);
        AbstractMapMetaData smd = new AbstractMapMetaData();
        smd.setType(CustomMap.class.getName());
        smd.setKeyType("java.lang.String");
        smd.setValueType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.put((MetaDataVisitorNode)kmd1, (MetaDataVisitorNode)vmd1);
        smd.put((MetaDataVisitorNode)kmd2, (MetaDataVisitorNode)vmd2);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("map", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomMapFromSignature() throws Throwable {
        SimpleBean bean = this.customMapFromSignature();
        MapTestCase.assertNotNull((Object)bean);
        CustomMap result = bean.getCustomMap();
        MapTestCase.assertNotNull((String)"Should be a map", (Object)result);
        MapTestCase.assertTrue((String)("Not a CustomMap: " + result.getClass()), (boolean)(result instanceof CustomMap));
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(this.string1, this.string2);
        expected.put(this.string2, this.string1);
        MapTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean customMapFromSignature() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData kmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData kmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string1);
        AbstractMapMetaData smd = new AbstractMapMetaData();
        smd.setKeyType("java.lang.String");
        smd.setValueType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.put((MetaDataVisitorNode)kmd1, (MetaDataVisitorNode)vmd1);
        smd.put((MetaDataVisitorNode)kmd2, (MetaDataVisitorNode)vmd2);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("customMap", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomMapPreInstantiated() throws Throwable {
        SimpleBean bean = this.customMapPreInstantiated();
        MapTestCase.assertNotNull((Object)bean);
        CustomMap result = bean.getPreInstantiatedMap();
        MapTestCase.assertNotNull((String)"Should be a map", (Object)result);
        MapTestCase.assertTrue((String)("Not a CustomMap: " + result.getClass()), (boolean)(result instanceof CustomMap));
        MapTestCase.assertTrue((String)"Not preinstantiated", (boolean)result.getPreInstantiated());
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(this.string1, this.string2);
        expected.put(this.string2, this.string1);
        MapTestCase.assertEquals(expected, (Object)result);
        Map setter = bean.setterMap;
        MapTestCase.assertNotNull((Object)setter);
        MapTestCase.assertFalse((String)"Empty setterMap", (boolean)setter.isEmpty());
    }

    protected SimpleBean customMapPreInstantiated() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("test1", SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData kmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData kmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string1);
        AbstractMapMetaData smd = new AbstractMapMetaData();
        smd.setKeyType("java.lang.String");
        smd.setValueType("java.lang.String");
        smd.put((MetaDataVisitorNode)kmd1, (MetaDataVisitorNode)vmd1);
        smd.put((MetaDataVisitorNode)kmd2, (MetaDataVisitorNode)vmd2);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("preInstantiatedMap", (ValueMetaData)smd);
        properties.add(pmd);
        AbstractMapMetaData lmd = new AbstractMapMetaData();
        lmd.setKeyType("java.lang.String");
        lmd.setValueType("java.lang.String");
        lmd.put((MetaDataVisitorNode)new StringValueMetaData("justKey"), (MetaDataVisitorNode)new StringValueMetaData("justValue"));
        AbstractPropertyMetaData pmd2 = new AbstractPropertyMetaData("setterMap", (ValueMetaData)lmd);
        properties.add(pmd2);
        return (SimpleBean)this.instantiate(controller, (BeanMetaData)bmd);
    }

    public void testUnmodifiableMapPreInstantiated() throws Throwable {
        UnmodifiableGetterBean bean = this.unmodifiableMapPreInstantiated();
        MapTestCase.assertNotNull((Object)bean);
        Map result = bean.getMap();
        MapTestCase.assertNotNull((String)"Should be a map", (Object)result);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(this.string1, this.string2);
        expected.put(this.string2, this.string1);
        MapTestCase.assertEquals(expected, (Object)result);
    }

    protected UnmodifiableGetterBean unmodifiableMapPreInstantiated() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("test1", UnmodifiableGetterBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData kmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData kmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string1);
        AbstractMapMetaData smd = new AbstractMapMetaData();
        smd.setKeyType("java.lang.String");
        smd.setValueType("java.lang.String");
        smd.put((MetaDataVisitorNode)kmd1, (MetaDataVisitorNode)vmd1);
        smd.put((MetaDataVisitorNode)kmd2, (MetaDataVisitorNode)vmd2);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("map", (ValueMetaData)smd);
        pmd.setPreInstantiate(false);
        properties.add(pmd);
        return (UnmodifiableGetterBean)this.instantiate(controller, (BeanMetaData)bmd);
    }

    public void testMapWithKeyTypeOverride() throws Throwable {
        SimpleBean bean = this.mapWithKeyTypeOverride();
        MapTestCase.assertNotNull((Object)bean);
        Map result = bean.getMap();
        MapTestCase.assertNotNull((String)"Should be a map", (Object)result);
        MapTestCase.assertTrue((String)("Not a CustomMap: " + result.getClass()), (boolean)(result instanceof CustomMap));
        HashMap<Object, String> expected = new HashMap<Object, String>();
        expected.put(this.string1, this.string2);
        expected.put(this.string2, this.string1);
        expected.put(1, this.integer);
        MapTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean mapWithKeyTypeOverride() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData kmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData kmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData kmd3 = new StringValueMetaData("1");
        StringValueMetaData vmd1 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd3 = new StringValueMetaData(this.integer);
        kmd3.setConfigurator(configurator);
        kmd3.setType("java.lang.Integer");
        AbstractMapMetaData smd = new AbstractMapMetaData();
        smd.setType(CustomMap.class.getName());
        smd.setKeyType("java.lang.String");
        smd.setValueType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.put((MetaDataVisitorNode)kmd1, (MetaDataVisitorNode)vmd1);
        smd.put((MetaDataVisitorNode)kmd2, (MetaDataVisitorNode)vmd2);
        smd.put((MetaDataVisitorNode)kmd3, (MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("map", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testMapWithValueTypeOverride() throws Throwable {
        SimpleBean bean = this.mapWithValueTypeOverride();
        MapTestCase.assertNotNull((Object)bean);
        Map result = bean.getMap();
        MapTestCase.assertNotNull((String)"Should be a map", (Object)result);
        MapTestCase.assertTrue((String)("Not a CustomMap: " + result.getClass()), (boolean)(result instanceof CustomMap));
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put(this.string1, this.string2);
        expected.put(this.string2, this.string1);
        expected.put(this.integer, 1);
        MapTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean mapWithValueTypeOverride() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData kmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData kmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData kmd3 = new StringValueMetaData(this.integer);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd3 = new StringValueMetaData("1");
        vmd3.setConfigurator(configurator);
        vmd3.setType("java.lang.Integer");
        AbstractMapMetaData smd = new AbstractMapMetaData();
        smd.setType(CustomMap.class.getName());
        smd.setKeyType("java.lang.String");
        smd.setValueType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.put((MetaDataVisitorNode)kmd1, (MetaDataVisitorNode)vmd1);
        smd.put((MetaDataVisitorNode)kmd2, (MetaDataVisitorNode)vmd2);
        smd.put((MetaDataVisitorNode)kmd3, (MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("map", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testMapNotAMap() throws Throwable {
        try {
            this.mapNotAMap();
            MapTestCase.fail((String)"Expected a failure trying to set a map on a non map attribute");
        }
        catch (Exception expected) {
            this.checkMapNotAMapException(expected);
        }
    }

    protected void checkMapNotAMapException(Exception exception) {
        MapTestCase.checkThrowable(ClassCastException.class, (Throwable)exception);
    }

    protected SimpleBean mapNotAMap() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData kmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData kmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string1);
        AbstractMapMetaData smd = new AbstractMapMetaData();
        smd.setKeyType("java.lang.String");
        smd.setValueType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.put((MetaDataVisitorNode)kmd1, (MetaDataVisitorNode)vmd1);
        smd.put((MetaDataVisitorNode)kmd2, (MetaDataVisitorNode)vmd2);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("AString", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testMapIsInterface() throws Throwable {
        try {
            this.mapIsInterface();
            MapTestCase.fail((String)"Expected a failure trying to use an interface for the map type");
        }
        catch (Exception expected) {
            this.checkMapIsInterfaceException(expected);
        }
    }

    protected void checkMapIsInterfaceException(Exception exception) {
        MapTestCase.checkThrowable(IllegalArgumentException.class, (Throwable)exception);
    }

    protected SimpleBean mapIsInterface() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData kmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData kmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string1);
        AbstractMapMetaData smd = new AbstractMapMetaData();
        smd.setType("java.util.Map");
        smd.setKeyType("java.lang.String");
        smd.setValueType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.put((MetaDataVisitorNode)kmd1, (MetaDataVisitorNode)vmd1);
        smd.put((MetaDataVisitorNode)kmd2, (MetaDataVisitorNode)vmd2);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("map", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }
}

