/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.plugins.AbstractArrayMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractCollectionMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.beans.metadata.plugins.AbstractMapMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractSetMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class InstantiateTestCase
extends AbstractKernelConfigTest {
    public static Test suite() {
        return InstantiateTestCase.suite(InstantiateTestCase.class);
    }

    public InstantiateTestCase(String name) {
        super(name);
    }

    public InstantiateTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public void testSimpleInstantiateFromBeanInfo() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanInfo info = configurator.getBeanInfo(SimpleBean.class);
        SimpleBean bean = (SimpleBean)this.instantiate(configurator, info);
        InstantiateTestCase.assertEquals((String)"()", (String)bean.getConstructorUsed());
    }

    public void testSimpleInstantiateFromBeanMetaData() throws Throwable {
        SimpleBean bean = this.simpleInstantiateFromBeanMetaData();
        InstantiateTestCase.assertEquals((String)"()", (String)bean.getConstructorUsed());
    }

    protected SimpleBean simpleInstantiateFromBeanMetaData() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testParameterInstantiateFromBeanMetaData() throws Throwable {
        SimpleBean bean = this.parameterInstantiateFromBeanMetaData();
        InstantiateTestCase.assertEquals((String)"Constructor Value", (String)bean.getConstructorUsed());
        InstantiateTestCase.assertEquals((String)"Constructor Value", (String)bean.getAString());
    }

    protected SimpleBean parameterInstantiateFromBeanMetaData() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData((Object)"Constructor Value");
        constructorParams.add(pmd);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testParameterInstantiateWithTypeOverride() throws Throwable {
        SimpleBean bean = this.parameterInstantiateWithTypeOverride();
        InstantiateTestCase.assertEquals((String)"java.lang.Integer:7", (String)bean.getConstructorUsed());
        InstantiateTestCase.assertEquals((Object)new Integer(7), (Object)bean.getAnInt());
    }

    protected SimpleBean parameterInstantiateWithTypeOverride() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData();
        pmd.setType("java.lang.Integer");
        StringValueMetaData svmd = new StringValueMetaData("7");
        pmd.setValue((ValueMetaData)svmd);
        constructorParams.add(pmd);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testParameterInstantiateFromNull() throws Throwable {
        SimpleBean bean = this.parameterInstantiateFromNull();
        InstantiateTestCase.assertEquals(null, (String)bean.getConstructorUsed());
        InstantiateTestCase.assertEquals(null, (String)bean.getAString());
    }

    protected SimpleBean parameterInstantiateFromNull() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData();
        pmd.setType("java.lang.String");
        pmd.setValue((ValueMetaData)new AbstractValueMetaData());
        constructorParams.add(pmd);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testParameterInstantiateViaInterfaceWithTypeOverride() throws Throwable {
        SimpleBean bean = this.parameterInstantiateViaInterfaceWithTypeOverride();
        InstantiateTestCase.assertEquals((String)"java.lang.Comparable:java.lang.Integer:12", (String)bean.getConstructorUsed());
        InstantiateTestCase.assertEquals((Object)12, (Object)bean.getAnObject());
    }

    protected SimpleBean parameterInstantiateViaInterfaceWithTypeOverride() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData();
        pmd.setType("java.lang.Comparable");
        StringValueMetaData svmd = new StringValueMetaData("12");
        svmd.setConfigurator(configurator);
        svmd.setType("java.lang.Integer");
        pmd.setValue((ValueMetaData)svmd);
        constructorParams.add(pmd);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testParameterInstantiateWithCollection() throws Throwable {
        SimpleBean bean = this.parameterInstantiateWithCollection();
        InstantiateTestCase.assertEquals((String)"java.util.Collection:java.util.ArrayList:[1, 2]", (String)bean.getConstructorUsed());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1");
        expected.add("2");
        InstantiateTestCase.assertEquals(expected, (Object)bean.getCollection());
    }

    protected SimpleBean parameterInstantiateWithCollection() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData();
        pmd.setType("java.util.Collection");
        AbstractCollectionMetaData collection = new AbstractCollectionMetaData();
        collection.setConfigurator(configurator);
        collection.setElementType("java.lang.String");
        collection.add((MetaDataVisitorNode)new StringValueMetaData("1"));
        collection.add((MetaDataVisitorNode)new StringValueMetaData("2"));
        pmd.setValue((ValueMetaData)collection);
        constructorParams.add(pmd);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testParameterInstantiateWithList() throws Throwable {
        SimpleBean bean = this.parameterInstantiateWithList();
        InstantiateTestCase.assertEquals((String)"java.util.List:java.util.ArrayList:[1, 2]", (String)bean.getConstructorUsed());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1");
        expected.add("2");
        InstantiateTestCase.assertEquals(expected, (Object)bean.getList());
    }

    protected SimpleBean parameterInstantiateWithList() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData();
        pmd.setType("java.util.List");
        AbstractListMetaData collection = new AbstractListMetaData();
        collection.setConfigurator(configurator);
        collection.setElementType("java.lang.String");
        collection.add((MetaDataVisitorNode)new StringValueMetaData("1"));
        collection.add((MetaDataVisitorNode)new StringValueMetaData("2"));
        pmd.setValue((ValueMetaData)collection);
        constructorParams.add(pmd);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testParameterInstantiateWithSet() throws Throwable {
        SimpleBean bean = this.parameterInstantiateWithSet();
        InstantiateTestCase.assertEquals((String)"java.util.Set:java.util.HashSet:[1]", (String)bean.getConstructorUsed());
        HashSet<String> expected = new HashSet<String>();
        expected.add("1");
        InstantiateTestCase.assertEquals(expected, (Object)bean.getSet());
    }

    protected SimpleBean parameterInstantiateWithSet() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData();
        pmd.setType("java.util.Set");
        AbstractSetMetaData collection = new AbstractSetMetaData();
        collection.setConfigurator(configurator);
        collection.setElementType("java.lang.String");
        collection.add((MetaDataVisitorNode)new StringValueMetaData("1"));
        pmd.setValue((ValueMetaData)collection);
        constructorParams.add(pmd);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testParameterInstantiateWithArray() throws Throwable {
        SimpleBean bean = this.parameterInstantiateWithArray();
        InstantiateTestCase.assertEquals((String)"Array:[Ljava.lang.String;:[1, 2]", (String)bean.getConstructorUsed());
        Object[] expected = new String[]{"1", "2"};
        this.assertEquals(expected, bean.getArray());
    }

    protected SimpleBean parameterInstantiateWithArray() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData();
        pmd.setType(new Object[0].getClass().getName());
        AbstractArrayMetaData collection = new AbstractArrayMetaData();
        collection.setConfigurator(configurator);
        collection.setType("[Ljava.lang.String;");
        collection.setElementType("java.lang.String");
        collection.add((MetaDataVisitorNode)new StringValueMetaData("1"));
        collection.add((MetaDataVisitorNode)new StringValueMetaData("2"));
        pmd.setValue((ValueMetaData)collection);
        constructorParams.add(pmd);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testParameterInstantiateWithMap() throws Throwable {
        SimpleBean bean = this.parameterInstantiateWithMap();
        InstantiateTestCase.assertEquals((String)"java.util.Map:java.util.HashMap:{1=2}", (String)bean.getConstructorUsed());
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("1", "2");
        InstantiateTestCase.assertEquals(expected, (Object)bean.getMap());
    }

    protected SimpleBean parameterInstantiateWithMap() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData();
        pmd.setType("java.util.Map");
        AbstractMapMetaData collection = new AbstractMapMetaData();
        collection.setConfigurator(configurator);
        collection.setKeyType("java.lang.String");
        collection.setValueType("java.lang.String");
        collection.put((MetaDataVisitorNode)new StringValueMetaData("1"), (MetaDataVisitorNode)new StringValueMetaData("2"));
        pmd.setValue((ValueMetaData)collection);
        constructorParams.add(pmd);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testParameterInstantiateWithProperties() throws Throwable {
        SimpleBean bean = this.parameterInstantiateWithProperties();
        InstantiateTestCase.assertEquals((String)"java.util.Hashtable:java.util.Properties:{1=2}", (String)bean.getConstructorUsed());
        Properties expected = new Properties();
        expected.put("1", "2");
        InstantiateTestCase.assertEquals((Object)expected, (Object)bean.getMap());
    }

    protected SimpleBean parameterInstantiateWithProperties() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData();
        pmd.setType("java.util.Hashtable");
        AbstractMapMetaData collection = new AbstractMapMetaData();
        collection.setConfigurator(configurator);
        collection.setType("java.util.Properties");
        collection.setKeyType("java.lang.String");
        collection.setValueType("java.lang.String");
        collection.put((MetaDataVisitorNode)new StringValueMetaData("1"), (MetaDataVisitorNode)new StringValueMetaData("2"));
        pmd.setValue((ValueMetaData)collection);
        constructorParams.add(pmd);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testValueInstantiateFromValue() throws Throwable {
        Object object = this.valueInstantiateFromValue();
        InstantiateTestCase.assertEquals((Object)"AString", (Object)object);
    }

    protected Object valueInstantiateFromValue() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData();
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        StringValueMetaData vmd = new StringValueMetaData("AString");
        vmd.setType(String.class.getName());
        vmd.setConfigurator(configurator);
        cmd.setValue((ValueMetaData)vmd);
        return this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testValueInstantiateFromCollection() throws Throwable {
        Object object = this.valueInstantiateFromCollection();
        InstantiateTestCase.assertNotNull((Object)object);
        InstantiateTestCase.assertTrue((boolean)(object instanceof Collection));
        InstantiateTestCase.assertEquals(new ArrayList(), (Object)object);
    }

    protected Object valueInstantiateFromCollection() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData();
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        AbstractCollectionMetaData vmd = new AbstractCollectionMetaData();
        cmd.setValue((ValueMetaData)vmd);
        return this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testValueInstantiateFromList() throws Throwable {
        Object object = this.valueInstantiateFromList();
        InstantiateTestCase.assertNotNull((Object)object);
        InstantiateTestCase.assertTrue((boolean)(object instanceof List));
        InstantiateTestCase.assertEquals(new ArrayList(), (Object)object);
    }

    protected Object valueInstantiateFromList() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData();
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        AbstractListMetaData vmd = new AbstractListMetaData();
        cmd.setValue((ValueMetaData)vmd);
        return this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testValueInstantiateFromSet() throws Throwable {
        Object object = this.valueInstantiateFromSet();
        InstantiateTestCase.assertNotNull((Object)object);
        InstantiateTestCase.assertTrue((boolean)(object instanceof Set));
        InstantiateTestCase.assertEquals(new HashSet(), (Object)object);
    }

    protected Object valueInstantiateFromSet() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData();
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        AbstractSetMetaData vmd = new AbstractSetMetaData();
        cmd.setValue((ValueMetaData)vmd);
        return this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testValueInstantiateFromArray() throws Throwable {
        Object object = this.valueInstantiateFromArray();
        InstantiateTestCase.assertNotNull((Object)object);
        InstantiateTestCase.assertTrue((boolean)object.getClass().isArray());
    }

    protected Object valueInstantiateFromArray() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData();
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        AbstractArrayMetaData vmd = new AbstractArrayMetaData();
        vmd.setElementType(String.class.getName());
        vmd.setConfigurator(configurator);
        cmd.setValue((ValueMetaData)vmd);
        return this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testValueInstantiateFromObject() throws Throwable {
        Object object = this.valueInstantiateFromObject();
        InstantiateTestCase.assertNotNull((Object)object);
        InstantiateTestCase.assertTrue((object.getClass() == Object.class ? 1 : 0) != 0);
    }

    protected Object valueInstantiateFromObject() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData();
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        AbstractValueMetaData vmd = new AbstractValueMetaData();
        vmd.setValue(new Object());
        cmd.setValue((ValueMetaData)vmd);
        return this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testConstructorDoesNotExist() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData("doesNotExist", "Constructor Value");
        constructorParams.add(pmd);
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setParameters(constructorParams);
        try {
            this.instantiate(configurator, (BeanMetaData)bmd);
            InstantiateTestCase.fail((String)"Should not be here");
        }
        catch (JoinpointException expected) {
            // empty catch block
        }
    }
}

