/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.test.kernel.config.support.XMLUtil;

public class AbstractKernelConfigTest
extends AbstractKernelTest {
    protected boolean xmltest = false;

    public AbstractKernelConfigTest(String name) {
        super(name);
    }

    public AbstractKernelConfigTest(String name, boolean xmltest) {
        super(name);
        this.xmltest = xmltest;
    }

    protected Kernel bootstrap() throws Throwable {
        if (this.xmltest) {
            throw new RuntimeException("Not to be invoked from an xml test");
        }
        return super.bootstrap();
    }

    protected XMLUtil bootstrapXML(boolean validate) throws Throwable {
        Kernel kernel = super.bootstrap();
        return new XMLUtil(kernel, this, validate);
    }

    protected Object instantiate(KernelConfigurator configurator, BeanInfo info) throws Throwable {
        Joinpoint joinPoint = configurator.getConstructorJoinPoint(info);
        return joinPoint.dispatch();
    }

    protected Object instantiateAndConfigure(BeanMetaData metaData) throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        return this.instantiateAndConfigure(configurator, metaData);
    }

    protected Object instantiateAndConfigure(KernelConfigurator configurator, BeanMetaData metaData) throws Throwable {
        Object result = this.instantiate(configurator, metaData);
        this.configure(configurator, result, metaData);
        return result;
    }

    protected Object instantiate(BeanMetaData metaData) throws Throwable {
        return this.instantiate(this.bootstrap().getController(), metaData);
    }

    protected Object instantiate(BeanMetaData metaData, ControllerState expectedState) throws Throwable {
        return this.instantiate(this.bootstrap().getController(), metaData, expectedState);
    }

    protected Object instantiate(KernelController controller, BeanMetaData metaData) throws Throwable {
        return this.instantiate(controller, metaData, null);
    }

    protected Object instantiate(KernelController controller, BeanMetaData metaData, ControllerState expectedState) throws Throwable {
        metaData.setMode(ControllerMode.AUTOMATIC);
        KernelControllerContext kernelControllerContext = controller.install(metaData);
        if (expectedState != null) {
            AbstractKernelConfigTest.assertEquals((Object)expectedState, (Object)kernelControllerContext.getState());
        }
        this.afterInstall(controller, kernelControllerContext);
        return kernelControllerContext.getTarget();
    }

    protected void afterInstall(KernelController controller, KernelControllerContext context) throws Throwable {
    }

    protected Object instantiate(KernelConfigurator configurator, BeanMetaData metaData) throws Throwable {
        Joinpoint joinPoint = configurator.getConstructorJoinPoint(metaData);
        return joinPoint.dispatch();
    }

    protected void configure(KernelConfigurator configurator, Object bean, BeanMetaData metaData) throws Throwable {
        BeanInfo info = configurator.getBeanInfo(metaData);
        this.configure(configurator, bean, info, metaData);
    }

    protected void configure(KernelConfigurator configurator, Object bean, BeanInfo info, BeanMetaData metaData) throws Throwable {
        Set joinPoints = configurator.getPropertySetterJoinPoints(info, metaData);
        for (TargettedJoinpoint joinPoint : joinPoints) {
            joinPoint.setTarget(bean);
            joinPoint.dispatch();
        }
    }

    protected void configure(KernelConfigurator configurator, Object bean, BeanInfo info, PropertyMetaData metaData) throws Throwable {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        TargettedJoinpoint joinPoint = configurator.getPropertySetterJoinPoint(info, cl, metaData);
        joinPoint.setTarget(bean);
        joinPoint.dispatch();
    }

    protected void unconfigure(KernelConfigurator configurator, Object bean, BeanInfo info, BeanMetaData metaData) throws Throwable {
        Set joinPoints = configurator.getPropertyNullerJoinPoints(info, metaData);
        for (TargettedJoinpoint joinPoint : joinPoints) {
            joinPoint.setTarget(bean);
            try {
                joinPoint.dispatch();
            }
            catch (Throwable ignored) {}
        }
    }

    protected void configureLoggingAfterBootstrap() {
    }
}

