/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapter;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.config.property.PropertyKernelConfig;
import org.jboss.kernel.plugins.dependency.AbstractKernelController;
import org.jboss.kernel.plugins.dependency.DescribeAction;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.test.BaseTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanAnnotationAdapterTestCase
extends BaseTestCase {
    protected AbstractBeanAnnotationAdapterTestCase(String name) {
        super(name);
    }

    protected abstract BeanAnnotationAdapter getBeanAnnotationAdapterClass();

    protected Set<Annotation> getAnnotations() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAnnotations(Object bean) throws Throwable {
        KernelController controller = this.getController();
        String name = bean.toString();
        AbstractBeanMetaData beanMetaData = new AbstractBeanMetaData(name, bean.getClass().getName());
        try {
            controller.install((BeanMetaData)beanMetaData, bean);
        }
        finally {
            controller.uninstall((Object)name);
        }
    }

    protected KernelController getController() throws Throwable {
        BasicBootstrap bootstrap = new BasicBootstrap((KernelConfig)new TestKernelConfig());
        bootstrap.run();
        Kernel kernel = bootstrap.getKernel();
        KernelController controller = kernel.getController();
        this.assertInstanceOf(controller, TestController.class);
        return controller;
    }

    private class TestDescribeAction
    extends DescribeAction {
        private TestDescribeAction() {
        }

        protected BeanAnnotationAdapter getBeanAnnotationAdapter() {
            return AbstractBeanAnnotationAdapterTestCase.this.getBeanAnnotationAdapterClass();
        }
    }

    private class TestController
    extends AbstractKernelController {
        private TestDescribeAction describe;

        public TestController() throws Exception {
            this.describe = new TestDescribeAction();
        }

        protected void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable {
            if (ControllerState.DESCRIBED.equals((Object)toState)) {
                this.describe.install(context);
            } else {
                super.install(context, fromState, toState);
            }
        }

        protected void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState) {
            if (ControllerState.DESCRIBED.equals((Object)fromState)) {
                this.describe.uninstall(context);
            } else {
                super.uninstall(context, fromState, toState);
            }
        }
    }

    private class TestKernelConfig
    extends PropertyKernelConfig {
        public TestKernelConfig() {
            super(null);
        }

        public KernelController createKernelController() throws Throwable {
            return new TestController();
        }
    }
}

